/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.route53.model.Tag;
import com.amazonaws.services.route53.model.TagResourceType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ChangeTagsForResourceRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String resourceType;
    private String resourceId;
    private ListWithAutoConstructFlag<Tag> addTags;
    private ListWithAutoConstructFlag<String> removeTagKeys;

    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public ChangeTagsForResourceRequest withResourceType(String resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    public void setResourceType(TagResourceType resourceType) {
        this.resourceType = resourceType.toString();
    }

    public ChangeTagsForResourceRequest withResourceType(TagResourceType resourceType) {
        this.resourceType = resourceType.toString();
        return this;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public ChangeTagsForResourceRequest withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public List<Tag> getAddTags() {
        if (this.addTags == null) {
            this.addTags = new ListWithAutoConstructFlag();
            this.addTags.setAutoConstruct(true);
        }
        return this.addTags;
    }

    public void setAddTags(Collection<Tag> addTags) {
        if (addTags == null) {
            this.addTags = null;
            return;
        }
        ListWithAutoConstructFlag addTagsCopy = new ListWithAutoConstructFlag(addTags.size());
        addTagsCopy.addAll(addTags);
        this.addTags = addTagsCopy;
    }

    public ChangeTagsForResourceRequest withAddTags(Tag ... addTags) {
        if (this.getAddTags() == null) {
            this.setAddTags(new ArrayList<Tag>(addTags.length));
        }
        for (Tag value : addTags) {
            this.getAddTags().add(value);
        }
        return this;
    }

    public ChangeTagsForResourceRequest withAddTags(Collection<Tag> addTags) {
        if (addTags == null) {
            this.addTags = null;
        } else {
            ListWithAutoConstructFlag addTagsCopy = new ListWithAutoConstructFlag(addTags.size());
            addTagsCopy.addAll(addTags);
            this.addTags = addTagsCopy;
        }
        return this;
    }

    public List<String> getRemoveTagKeys() {
        if (this.removeTagKeys == null) {
            this.removeTagKeys = new ListWithAutoConstructFlag();
            this.removeTagKeys.setAutoConstruct(true);
        }
        return this.removeTagKeys;
    }

    public void setRemoveTagKeys(Collection<String> removeTagKeys) {
        if (removeTagKeys == null) {
            this.removeTagKeys = null;
            return;
        }
        ListWithAutoConstructFlag removeTagKeysCopy = new ListWithAutoConstructFlag(removeTagKeys.size());
        removeTagKeysCopy.addAll(removeTagKeys);
        this.removeTagKeys = removeTagKeysCopy;
    }

    public ChangeTagsForResourceRequest withRemoveTagKeys(String ... removeTagKeys) {
        if (this.getRemoveTagKeys() == null) {
            this.setRemoveTagKeys(new ArrayList<String>(removeTagKeys.length));
        }
        for (String value : removeTagKeys) {
            this.getRemoveTagKeys().add(value);
        }
        return this;
    }

    public ChangeTagsForResourceRequest withRemoveTagKeys(Collection<String> removeTagKeys) {
        if (removeTagKeys == null) {
            this.removeTagKeys = null;
        } else {
            ListWithAutoConstructFlag removeTagKeysCopy = new ListWithAutoConstructFlag(removeTagKeys.size());
            removeTagKeysCopy.addAll(removeTagKeys);
            this.removeTagKeys = removeTagKeysCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceType() != null) {
            sb.append("ResourceType: " + this.getResourceType() + ",");
        }
        if (this.getResourceId() != null) {
            sb.append("ResourceId: " + this.getResourceId() + ",");
        }
        if (this.getAddTags() != null) {
            sb.append("AddTags: " + this.getAddTags() + ",");
        }
        if (this.getRemoveTagKeys() != null) {
            sb.append("RemoveTagKeys: " + this.getRemoveTagKeys());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        hashCode = 31 * hashCode + (this.getResourceId() == null ? 0 : this.getResourceId().hashCode());
        hashCode = 31 * hashCode + (this.getAddTags() == null ? 0 : this.getAddTags().hashCode());
        hashCode = 31 * hashCode + (this.getRemoveTagKeys() == null ? 0 : this.getRemoveTagKeys().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeTagsForResourceRequest)) {
            return false;
        }
        ChangeTagsForResourceRequest other = (ChangeTagsForResourceRequest)obj;
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        if (other.getResourceType() != null && !other.getResourceType().equals(this.getResourceType())) {
            return false;
        }
        if (other.getResourceId() == null ^ this.getResourceId() == null) {
            return false;
        }
        if (other.getResourceId() != null && !other.getResourceId().equals(this.getResourceId())) {
            return false;
        }
        if (other.getAddTags() == null ^ this.getAddTags() == null) {
            return false;
        }
        if (other.getAddTags() != null && !other.getAddTags().equals(this.getAddTags())) {
            return false;
        }
        if (other.getRemoveTagKeys() == null ^ this.getRemoveTagKeys() == null) {
            return false;
        }
        return other.getRemoveTagKeys() == null || other.getRemoveTagKeys().equals(this.getRemoveTagKeys());
    }
}

