/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.management.request;

import com.hazelcast.management.ManagementCenterService;
import com.hazelcast.management.operation.ScriptExecutorOperation;
import com.hazelcast.management.request.ConsoleRequest;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ExecuteScriptRequest
implements ConsoleRequest {
    private static final byte NULL = 0;
    private static final byte MAP = 1;
    private static final byte COLLECTION = 2;
    private static final byte OTHER = -1;
    private String script;
    private String engine;
    private Set<Address> targets;
    private boolean targetAllMembers = false;
    private Map<String, Object> bindings;

    public ExecuteScriptRequest() {
    }

    public ExecuteScriptRequest(String script, String engine, boolean targetAllMembers, Map<String, Object> bindings) {
        this.script = script;
        this.engine = engine;
        this.targets = new HashSet<Address>(0);
        this.targetAllMembers = targetAllMembers;
        this.bindings = bindings;
    }

    public ExecuteScriptRequest(String script, String engine, Set<Address> targets, Map<String, Object> bindings) {
        this.script = script;
        this.targets = targets;
        this.engine = engine;
        this.targetAllMembers = false;
        this.bindings = bindings;
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public void writeResponse(ManagementCenterService mcs, ObjectDataOutput dos) throws Exception {
        Object result = null;
        ScriptExecutorOperation operation = new ScriptExecutorOperation(this.engine, this.script, this.bindings);
        result = this.targetAllMembers ? mcs.callOnAllMembers(operation) : (this.targets.isEmpty() ? Byte.valueOf((byte)0) : (this.targets.size() == 1 ? mcs.call(this.targets.iterator().next(), operation) : mcs.callOnAddresses(this.targets, operation)));
        if (result != null) {
            if (result instanceof Map) {
                dos.writeByte(1);
                this.writeMap(dos, (Map)result);
            } else if (result instanceof Collection) {
                dos.writeByte(2);
                this.writeCollection(dos, (Collection)result);
            } else {
                dos.writeByte(-1);
                dos.writeObject(result);
            }
        } else {
            dos.writeByte(0);
        }
    }

    @Override
    public Object readResponse(ObjectDataInput in) throws IOException {
        byte flag = in.readByte();
        switch (flag) {
            case 1: {
                return this.readMap(in);
            }
            case 2: {
                return this.readCollection(in);
            }
            case -1: {
                return in.readObject();
            }
        }
        return null;
    }

    private void writeMap(ObjectDataOutput dos, Map result) throws IOException {
        int size = result != null ? result.size() : 0;
        dos.writeInt(size);
        if (size > 0) {
            Set entries = result.entrySet();
            for (Map.Entry entry : entries) {
                dos.writeObject(entry.getKey());
                dos.writeObject(entry.getValue());
            }
        }
    }

    private Map readMap(ObjectDataInput in) throws IOException {
        int size = in.readInt();
        HashMap props = new HashMap(size);
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                Object key = in.readObject();
                Object value = in.readObject();
                props.put(key, value);
            }
        }
        return props;
    }

    private void writeCollection(ObjectDataOutput dos, Collection result) throws IOException {
        int size = result != null ? result.size() : 0;
        dos.writeInt(size);
        if (size > 0) {
            Iterator iter = result.iterator();
            while (iter.hasNext()) {
                dos.writeObject(iter.next());
            }
        }
    }

    private Collection readCollection(ObjectDataInput in) throws IOException {
        int size = in.readInt();
        ArrayList coll = new ArrayList(size);
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                Object value = in.readObject();
                coll.add(value);
            }
        }
        return coll;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.script);
        out.writeUTF(this.engine);
        out.writeBoolean(this.targetAllMembers);
        out.writeInt(this.targets.size());
        for (Address target : this.targets) {
            target.writeData(out);
        }
        this.writeMap(out, this.bindings);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.script = in.readUTF();
        this.engine = in.readUTF();
        this.targetAllMembers = in.readBoolean();
        int size = in.readInt();
        this.targets = new HashSet<Address>(size);
        for (int i = 0; i < size; ++i) {
            Address target = new Address();
            target.readData(in);
            this.targets.add(target);
        }
        this.bindings = this.readMap(in);
    }
}

