/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.sqs.model.GetQueueAttributesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class GetQueueAttributesRequestMarshaller
implements Marshaller<Request<GetQueueAttributesRequest>, GetQueueAttributesRequest> {
    public Request<GetQueueAttributesRequest> marshall(GetQueueAttributesRequest getQueueAttributesRequest) {
        if (getQueueAttributesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getQueueAttributesRequest, "AmazonSQS");
        request.addParameter("Action", "GetQueueAttributes");
        request.addParameter("Version", "2012-11-05");
        if (getQueueAttributesRequest.getQueueUrl() != null) {
            request.addParameter("QueueUrl", StringUtils.fromString((String)getQueueAttributesRequest.getQueueUrl()));
        }
        List<String> attributeNamesList = getQueueAttributesRequest.getAttributeNames();
        int attributeNamesListIndex = 1;
        for (String attributeNamesListValue : attributeNamesList) {
            if (attributeNamesListValue != null) {
                request.addParameter("AttributeName." + attributeNamesListIndex, StringUtils.fromString((String)attributeNamesListValue));
            }
            ++attributeNamesListIndex;
        }
        return request;
    }
}

