/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.client.samples;

import org.apache.airavata.api.Airavata;
import org.apache.airavata.api.client.AiravataClientFactory;
import org.apache.airavata.client.samples.CreateLaunchExperiment;
import org.apache.airavata.model.error.AiravataClientException;
import org.apache.airavata.model.error.AiravataSystemException;
import org.apache.airavata.model.error.ExperimentNotFoundException;
import org.apache.airavata.model.error.InvalidRequestException;
import org.apache.airavata.model.security.AuthzToken;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CancelExperiments {
    public static final String THRIFT_SERVER_HOST = "gw56.iu.xsede.org";
    public static final int THRIFT_SERVER_PORT = 8930;
    private static final Logger logger = LoggerFactory.getLogger(CreateLaunchExperiment.class);
    private static final String DEFAULT_USER = "default.registry.user";
    private static final String DEFAULT_GATEWAY = "default";
    private static Airavata.Client client;

    public static void main(String[] args) {
        try {
            client = AiravataClientFactory.createAiravataClient((String)THRIFT_SERVER_HOST, (int)8930);
            String expeId = "echoExperiment_31c132fd-87ea-4781-803c-ae5f04a79baf";
            CancelExperiments.terminateExperiment(client, expeId);
            System.out.println("retrieved exp id : " + expeId);
        }
        catch (Exception e) {
            logger.error("Error while connecting with server", (Object)e.getMessage());
            e.printStackTrace();
        }
    }

    public static void terminateExperiment(Airavata.Client client, String expId) throws TException {
        try {
            client.terminateExperiment(new AuthzToken(""), expId, DEFAULT_GATEWAY);
        }
        catch (ExperimentNotFoundException e) {
            logger.error("Error occured while launching the experiment...", (Object)e.getMessage());
            throw new ExperimentNotFoundException(e);
        }
        catch (AiravataSystemException e) {
            logger.error("Error occured while launching the experiment...", (Object)e.getMessage());
            throw new AiravataSystemException(e);
        }
        catch (InvalidRequestException e) {
            logger.error("Error occured while launching the experiment...", (Object)e.getMessage());
            throw new InvalidRequestException(e);
        }
        catch (AiravataClientException e) {
            logger.error("Error occured while launching the experiment...", (Object)e.getMessage());
            throw new AiravataClientException(e);
        }
        catch (TException e) {
            logger.error("Error occured while launching the experiment...", (Object)e.getMessage());
            throw new TException((Throwable)e);
        }
    }
}

