/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.workflow.catalog.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.airavata.model.WorkflowModel;
import org.apache.airavata.model.application.io.DataType;
import org.apache.airavata.model.application.io.InputDataObjectType;
import org.apache.airavata.registry.core.workflow.catalog.resources.WorkflowCatalogResource;
import org.apache.airavata.registry.core.workflow.catalog.resources.WorkflowInputResource;
import org.apache.airavata.registry.core.workflow.catalog.resources.WorkflowResource;
import org.apache.airavata.registry.cpi.WorkflowCatalogException;

public class WorkflowCatalogThriftConversion {
    public static InputDataObjectType getWorkflowInput(WorkflowInputResource resource) {
        InputDataObjectType input = new InputDataObjectType();
        input.setName(resource.getInputKey());
        input.setApplicationArgument(resource.getAppArgument());
        input.setInputOrder(resource.getInputOrder());
        input.setType(DataType.valueOf((String)resource.getDataType()));
        input.setMetaData(resource.getMetadata());
        input.setUserFriendlyDescription(resource.getUserFriendlyDesc());
        input.setIsRequired(resource.getRequired());
        input.setRequiredToAddedToCommandLine(resource.getRequiredToCMD());
        input.setDataStaged(resource.isDataStaged());
        return input;
    }

    public static List<InputDataObjectType> getWFInputs(List<WorkflowCatalogResource> resources) {
        ArrayList<InputDataObjectType> inputResources = new ArrayList<InputDataObjectType>();
        if (resources != null && !resources.isEmpty()) {
            for (WorkflowCatalogResource resource : resources) {
                inputResources.add(WorkflowCatalogThriftConversion.getWorkflowInput((WorkflowInputResource)resource));
            }
        }
        return inputResources;
    }

    public static WorkflowModel getWorkflow(WorkflowResource resource) throws WorkflowCatalogException {
        WorkflowModel workflow = new WorkflowModel();
        workflow.setTemplateId(resource.getWfTemplateId());
        workflow.setGraph(resource.getGraph());
        workflow.setName(resource.getWfName());
        if (resource.getImage() != null) {
            workflow.setImage(resource.getImage().getBytes());
        }
        WorkflowInputResource inputResource = new WorkflowInputResource();
        List<WorkflowCatalogResource> resources = inputResource.get("templateID", resource.getWfTemplateId());
        workflow.setWorkflowInputs(WorkflowCatalogThriftConversion.getWFInputs(resources));
        return workflow;
    }
}

