/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.workflow.catalog.resources;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.AiravataUtils;
import org.apache.airavata.registry.core.workflow.catalog.model.Workflow;
import org.apache.airavata.registry.core.workflow.catalog.model.WorkflowStatus;
import org.apache.airavata.registry.core.workflow.catalog.model.WorkflowStatus_PK;
import org.apache.airavata.registry.core.workflow.catalog.resources.WorkflowCatAbstractResource;
import org.apache.airavata.registry.core.workflow.catalog.resources.WorkflowCatalogResource;
import org.apache.airavata.registry.core.workflow.catalog.utils.WorkflowCatalogJPAUtils;
import org.apache.airavata.registry.core.workflow.catalog.utils.WorkflowCatalogQueryGenerator;
import org.apache.airavata.registry.core.workflow.catalog.utils.WorkflowCatalogResourceType;
import org.apache.airavata.registry.cpi.WorkflowCatalogException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowStatusResource
extends WorkflowCatAbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowStatusResource.class);
    private String statusId;
    private String state;
    private String reason;
    private String templateId;
    private Timestamp updatedTime;

    @Override
    public void remove(Object identifier) throws WorkflowCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new WorkflowCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = WorkflowCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            WorkflowCatalogQueryGenerator generator = new WorkflowCatalogQueryGenerator("WorkflowStatus", new Object[0][]);
            generator.setParameter("statusId", ids.get("statusId"));
            generator.setParameter("templateId", ids.get("templateId"));
            Query q = generator.deleteQuery(em);
            q.executeUpdate();
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new WorkflowCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public WorkflowCatalogResource get(Object identifier) throws WorkflowCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new WorkflowCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = WorkflowCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            WorkflowCatalogQueryGenerator generator = new WorkflowCatalogQueryGenerator("WorkflowStatus", new Object[0][]);
            generator.setParameter("statusId", ids.get("statusId"));
            generator.setParameter("templateId", ids.get("templateId"));
            Query q = generator.selectQuery(em);
            WorkflowStatus status = (WorkflowStatus)q.getSingleResult();
            WorkflowStatusResource statusResource = (WorkflowStatusResource)WorkflowCatalogJPAUtils.getResource(WorkflowCatalogResourceType.WORKFLOW_STATUS, status);
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            WorkflowStatusResource workflowStatusResource = statusResource;
            return workflowStatusResource;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new WorkflowCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public List<WorkflowCatalogResource> get(String fieldName, Object value) throws WorkflowCatalogException {
        ArrayList<WorkflowCatalogResource> statusResources = new ArrayList<WorkflowCatalogResource>();
        EntityManager em = null;
        try {
            em = WorkflowCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            WorkflowCatalogQueryGenerator generator = new WorkflowCatalogQueryGenerator("WorkflowStatus", new Object[0][]);
            if (fieldName.equals("templateId")) {
                generator.setParameter("templateId", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        WorkflowStatus WorkflowStatus2 = (WorkflowStatus)result;
                        WorkflowStatusResource statusResource = (WorkflowStatusResource)WorkflowCatalogJPAUtils.getResource(WorkflowCatalogResourceType.WORKFLOW_STATUS, WorkflowStatus2);
                        statusResources.add(statusResource);
                    }
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for Workflow status Resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for Workflow status Resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new WorkflowCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return statusResources;
    }

    @Override
    public List<WorkflowCatalogResource> getAll() throws WorkflowCatalogException {
        return null;
    }

    @Override
    public List<String> getAllIds() throws WorkflowCatalogException {
        return null;
    }

    @Override
    public List<String> getIds(String fieldName, Object value) throws WorkflowCatalogException {
        ArrayList<String> statusResourceIds = new ArrayList<String>();
        EntityManager em = null;
        try {
            em = WorkflowCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            WorkflowCatalogQueryGenerator generator = new WorkflowCatalogQueryGenerator("WorkflowStatus", new Object[0][]);
            if (fieldName.equals("templateId")) {
                generator.setParameter("templateId", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        WorkflowStatus WorkflowStatus2 = (WorkflowStatus)result;
                        statusResourceIds.add(WorkflowStatus2.getTemplateId());
                    }
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for Workflow Status resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for Workflow Status Resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new WorkflowCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return statusResourceIds;
    }

    @Override
    public void save() throws WorkflowCatalogException {
        EntityManager em = null;
        try {
            em = WorkflowCatalogJPAUtils.getEntityManager();
            WorkflowStatus existingStatus = (WorkflowStatus)em.find(WorkflowStatus.class, (Object)new WorkflowStatus_PK(this.templateId, this.statusId));
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            em = WorkflowCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            if (existingStatus != null) {
                existingStatus.setTemplateId(this.templateId);
                Workflow workflow = (Workflow)em.find(Workflow.class, (Object)this.templateId);
                existingStatus.setWorkflow(workflow);
                existingStatus.setReason(this.reason);
                existingStatus.setState(this.state);
                existingStatus.setUpdateTime(AiravataUtils.getCurrentTimestamp());
                em.merge((Object)existingStatus);
            } else {
                WorkflowStatus status = new WorkflowStatus();
                status.setTemplateId(this.templateId);
                Workflow workflow = (Workflow)em.find(Workflow.class, (Object)this.templateId);
                status.setWorkflow(workflow);
                status.setReason(this.reason);
                status.setState(this.state);
                status.setUpdateTime(AiravataUtils.getCurrentTimestamp());
                em.persist((Object)status);
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new WorkflowCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public boolean isExists(Object identifier) throws WorkflowCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new WorkflowCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = WorkflowCatalogJPAUtils.getEntityManager();
            WorkflowStatus status = (WorkflowStatus)em.find(WorkflowStatus.class, (Object)new WorkflowStatus_PK((String)ids.get("templateId"), (String)ids.get("statusId")));
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            boolean bl = status != null;
            return bl;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new WorkflowCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public String getStatusId() {
        return this.statusId;
    }

    public void setStatusId(String statusId) {
        this.statusId = statusId;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public Timestamp getUpdatedTime() {
        return this.updatedTime;
    }

    public void setUpdatedTime(Timestamp updatedTime) {
        this.updatedTime = updatedTime;
    }
}

