/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.app.catalog.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription;
import org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule;
import org.apache.airavata.model.appcatalog.appdeployment.CommandObject;
import org.apache.airavata.model.appcatalog.appdeployment.SetEnvPaths;
import org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription;
import org.apache.airavata.model.appcatalog.computeresource.BatchQueue;
import org.apache.airavata.model.appcatalog.computeresource.CloudJobSubmission;
import org.apache.airavata.model.appcatalog.computeresource.ComputeResourceDescription;
import org.apache.airavata.model.appcatalog.computeresource.FileSystems;
import org.apache.airavata.model.appcatalog.computeresource.JobManagerCommand;
import org.apache.airavata.model.appcatalog.computeresource.JobSubmissionInterface;
import org.apache.airavata.model.appcatalog.computeresource.JobSubmissionProtocol;
import org.apache.airavata.model.appcatalog.computeresource.LOCALSubmission;
import org.apache.airavata.model.appcatalog.computeresource.MonitorMode;
import org.apache.airavata.model.appcatalog.computeresource.ProviderName;
import org.apache.airavata.model.appcatalog.computeresource.ResourceJobManager;
import org.apache.airavata.model.appcatalog.computeresource.ResourceJobManagerType;
import org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission;
import org.apache.airavata.model.appcatalog.computeresource.UnicoreJobSubmission;
import org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference;
import org.apache.airavata.model.appcatalog.gatewayprofile.GatewayResourceProfile;
import org.apache.airavata.model.appcatalog.gatewayprofile.StoragePreference;
import org.apache.airavata.model.appcatalog.storageresource.StorageResourceDescription;
import org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference;
import org.apache.airavata.model.appcatalog.userresourceprofile.UserResourceProfile;
import org.apache.airavata.model.appcatalog.userresourceprofile.UserStoragePreference;
import org.apache.airavata.model.application.io.DataType;
import org.apache.airavata.model.application.io.InputDataObjectType;
import org.apache.airavata.model.application.io.OutputDataObjectType;
import org.apache.airavata.model.data.movement.DataMovementInterface;
import org.apache.airavata.model.data.movement.DataMovementProtocol;
import org.apache.airavata.model.data.movement.GridFTPDataMovement;
import org.apache.airavata.model.data.movement.LOCALDataMovement;
import org.apache.airavata.model.data.movement.SCPDataMovement;
import org.apache.airavata.model.data.movement.SecurityProtocol;
import org.apache.airavata.model.data.movement.UnicoreDataMovement;
import org.apache.airavata.model.parallelism.ApplicationParallelismType;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatalogResource;
import org.apache.airavata.registry.core.app.catalog.resources.AppDeploymentResource;
import org.apache.airavata.registry.core.app.catalog.resources.AppEnvironmentResource;
import org.apache.airavata.registry.core.app.catalog.resources.AppInterfaceResource;
import org.apache.airavata.registry.core.app.catalog.resources.AppModuleMappingAppCatalogResourceAppCat;
import org.apache.airavata.registry.core.app.catalog.resources.AppModuleResource;
import org.apache.airavata.registry.core.app.catalog.resources.ApplicationInputResource;
import org.apache.airavata.registry.core.app.catalog.resources.ApplicationOutputResource;
import org.apache.airavata.registry.core.app.catalog.resources.BatchQueueResource;
import org.apache.airavata.registry.core.app.catalog.resources.CloudSubmissionResource;
import org.apache.airavata.registry.core.app.catalog.resources.ComputeHostPreferenceResource;
import org.apache.airavata.registry.core.app.catalog.resources.ComputeResourceFileSystemResource;
import org.apache.airavata.registry.core.app.catalog.resources.ComputeResourceResource;
import org.apache.airavata.registry.core.app.catalog.resources.DataMovementInterfaceResource;
import org.apache.airavata.registry.core.app.catalog.resources.GatewayProfileResource;
import org.apache.airavata.registry.core.app.catalog.resources.GlobusGKEndpointResource;
import org.apache.airavata.registry.core.app.catalog.resources.GridftpDataMovementResource;
import org.apache.airavata.registry.core.app.catalog.resources.GridftpEndpointResource;
import org.apache.airavata.registry.core.app.catalog.resources.HostAliasAppResource;
import org.apache.airavata.registry.core.app.catalog.resources.HostIPAddressResource;
import org.apache.airavata.registry.core.app.catalog.resources.JobManagerCommandResource;
import org.apache.airavata.registry.core.app.catalog.resources.JobSubmissionInterfaceResource;
import org.apache.airavata.registry.core.app.catalog.resources.LibraryApendPathResource;
import org.apache.airavata.registry.core.app.catalog.resources.LibraryPrepandPathResource;
import org.apache.airavata.registry.core.app.catalog.resources.LocalDataMovementResource;
import org.apache.airavata.registry.core.app.catalog.resources.LocalSubmissionResource;
import org.apache.airavata.registry.core.app.catalog.resources.ModuleLoadCmdResource;
import org.apache.airavata.registry.core.app.catalog.resources.ParallelismPrefixCommandResource;
import org.apache.airavata.registry.core.app.catalog.resources.PostJobCommandResource;
import org.apache.airavata.registry.core.app.catalog.resources.PreJobCommandResource;
import org.apache.airavata.registry.core.app.catalog.resources.ResourceJobManagerResource;
import org.apache.airavata.registry.core.app.catalog.resources.ScpDataMovementResource;
import org.apache.airavata.registry.core.app.catalog.resources.SshJobSubmissionResource;
import org.apache.airavata.registry.core.app.catalog.resources.StorageInterfaceResource;
import org.apache.airavata.registry.core.app.catalog.resources.StoragePreferenceResource;
import org.apache.airavata.registry.core.app.catalog.resources.StorageResourceResource;
import org.apache.airavata.registry.core.app.catalog.resources.UnicoreDataMovementResource;
import org.apache.airavata.registry.core.app.catalog.resources.UnicoreJobSubmissionResource;
import org.apache.airavata.registry.core.app.catalog.resources.UserComputeHostPreferenceResource;
import org.apache.airavata.registry.core.app.catalog.resources.UserResourceProfileResource;
import org.apache.airavata.registry.core.app.catalog.resources.UserStoragePreferenceResource;
import org.apache.airavata.registry.cpi.AppCatalogException;

public class AppCatalogThriftConversion {
    public static ComputeResourceResource getComputeHostResource(ComputeResourceDescription description) {
        ComputeResourceResource resource = new ComputeResourceResource();
        resource.setHostName(description.getHostName());
        resource.setResourceDescription(description.getResourceDescription());
        resource.setResourceId(description.getComputeResourceId());
        resource.setMaxMemoryPerNode(description.getMaxMemoryPerNode());
        resource.setCpusPerNode(description.getCpusPerNode());
        resource.setDefaultNodeCount(description.getDefaultNodeCount());
        resource.setDefaultCPUCount(description.getDefaultCPUCount());
        resource.setDefaultWalltime(description.getDefaultWalltime());
        resource.setEnabled(description.isEnabled());
        resource.setGatewayUsageReporting(description.isGatewayUsageReporting());
        resource.setGatewayUsageExec(description.getGatewayUsageExecutable());
        resource.setGatewayUsageModLoadCMD(description.getGatewayUsageModuleLoadCommand());
        return resource;
    }

    public static StorageResourceResource getStorageResource(StorageResourceDescription description) {
        StorageResourceResource resource = new StorageResourceResource();
        resource.setHostName(description.getHostName());
        resource.setResourceDescription(description.getStorageResourceDescription());
        resource.setStorageResourceId(description.getStorageResourceId());
        resource.setEnabled(description.isEnabled());
        return resource;
    }

    public static ComputeResourceDescription getComputeHostDescription(ComputeResourceResource resource) throws AppCatalogException {
        DataMovementInterfaceResource dmiResource;
        List<AppCatalogResource> dmiList;
        JobSubmissionInterfaceResource jsiResource;
        List<AppCatalogResource> hsiList;
        BatchQueueResource bqResource;
        List<AppCatalogResource> batchQueues;
        HostIPAddressResource ipAddressResource;
        List<AppCatalogResource> ipAddresses;
        ComputeResourceDescription description = new ComputeResourceDescription();
        description.setComputeResourceId(resource.getResourceId());
        description.setHostName(resource.getHostName());
        description.setResourceDescription(resource.getResourceDescription());
        description.setMaxMemoryPerNode(resource.getMaxMemoryPerNode());
        description.setCpusPerNode(resource.getCpusPerNode());
        description.setDefaultNodeCount(resource.getDefaultNodeCount());
        description.setDefaultCPUCount(resource.getDefaultCPUCount());
        description.setDefaultWalltime(resource.getDefaultWalltime());
        description.setEnabled(resource.isEnabled());
        description.setGatewayUsageReporting(resource.isGatewayUsageReporting());
        description.setGatewayUsageExecutable(resource.getGatewayUsageExec());
        description.setGatewayUsageModuleLoadCommand(resource.getGatewayUsageModLoadCMD());
        HostAliasAppResource aliasResource = new HostAliasAppResource();
        List<AppCatalogResource> resources = aliasResource.get("resourceID", resource.getResourceId());
        if (resources != null && !resources.isEmpty()) {
            description.setHostAliases(AppCatalogThriftConversion.getHostAliases(resources));
        }
        if ((ipAddresses = (ipAddressResource = new HostIPAddressResource()).get("resourceID", resource.getResourceId())) != null && !ipAddresses.isEmpty()) {
            description.setIpAddresses(AppCatalogThriftConversion.getIpAddresses(ipAddresses));
        }
        if ((batchQueues = (bqResource = new BatchQueueResource()).get("computeResourceId", resource.getResourceId())) != null && !batchQueues.isEmpty()) {
            description.setBatchQueues(AppCatalogThriftConversion.getBatchQueues(batchQueues));
        }
        ComputeResourceFileSystemResource fsResource = new ComputeResourceFileSystemResource();
        List<AppCatalogResource> fsList = fsResource.get("computeResourceId", resource.getResourceId());
        description.setFileSystems(new HashMap());
        if (fsList != null && !fsList.isEmpty()) {
            for (AppCatalogResource r : fsList) {
                ComputeResourceFileSystemResource rr = (ComputeResourceFileSystemResource)r;
                description.getFileSystems().put(FileSystems.valueOf((String)rr.getFileSystem()), rr.getPath());
            }
        }
        if ((hsiList = (jsiResource = new JobSubmissionInterfaceResource()).get("computeResourceId", resource.getResourceId())) != null && !hsiList.isEmpty()) {
            description.setJobSubmissionInterfaces(AppCatalogThriftConversion.getJobSubmissionInterfaces(hsiList));
        }
        if ((dmiList = (dmiResource = new DataMovementInterfaceResource()).get("computeResourceId", resource.getResourceId())) != null && !dmiList.isEmpty()) {
            description.setDataMovementInterfaces(AppCatalogThriftConversion.getDataMovementInterfaces(dmiList));
        }
        return description;
    }

    public static StorageResourceDescription getStorageDescription(StorageResourceResource resource) throws AppCatalogException {
        StorageResourceDescription description = new StorageResourceDescription();
        description.setStorageResourceId(resource.getStorageResourceId());
        description.setHostName(resource.getHostName());
        description.setStorageResourceDescription(resource.getResourceDescription());
        description.setEnabled(resource.isEnabled());
        StorageInterfaceResource interfaceResource = new StorageInterfaceResource();
        interfaceResource.setStorageResourceId(resource.getStorageResourceId());
        List<AppCatalogResource> resources = interfaceResource.get("storageResourceId", resource.getStorageResourceId());
        if (resources != null && !resources.isEmpty()) {
            description.setDataMovementInterfaces(AppCatalogThriftConversion.getDataMovementInterfacesForStorageResource(resources));
        }
        return description;
    }

    public static List<ComputeResourceDescription> getComputeDescriptionList(List<AppCatalogResource> resources) throws AppCatalogException {
        ArrayList<ComputeResourceDescription> list = new ArrayList<ComputeResourceDescription>();
        for (AppCatalogResource resource : resources) {
            list.add(AppCatalogThriftConversion.getComputeHostDescription((ComputeResourceResource)resource));
        }
        return list;
    }

    public static List<StorageResourceDescription> getStorageDescriptionList(List<AppCatalogResource> resources) throws AppCatalogException {
        ArrayList<StorageResourceDescription> list = new ArrayList<StorageResourceDescription>();
        for (AppCatalogResource resource : resources) {
            list.add(AppCatalogThriftConversion.getStorageDescription((StorageResourceResource)resource));
        }
        return list;
    }

    public static List<String> getHostAliases(List<AppCatalogResource> resources) {
        ArrayList<String> hostAliases = new ArrayList<String>();
        for (AppCatalogResource alias : resources) {
            hostAliases.add(((HostAliasAppResource)alias).getAlias());
        }
        return hostAliases;
    }

    public static List<String> getIpAddresses(List<AppCatalogResource> resources) {
        ArrayList<String> hostIpAddresses = new ArrayList<String>();
        for (AppCatalogResource resource : resources) {
            hostIpAddresses.add(((HostIPAddressResource)resource).getIpaddress());
        }
        return hostIpAddresses;
    }

    public static List<BatchQueue> getBatchQueues(List<AppCatalogResource> resources) {
        ArrayList<BatchQueue> batchQueues = new ArrayList<BatchQueue>();
        for (AppCatalogResource resource : resources) {
            batchQueues.add(AppCatalogThriftConversion.getBatchQueue((BatchQueueResource)resource));
        }
        return batchQueues;
    }

    public static List<DataMovementInterface> getDataMovementInterfaces(List<AppCatalogResource> resources) {
        ArrayList<DataMovementInterface> dataMovementInterfaces = new ArrayList<DataMovementInterface>();
        for (AppCatalogResource resource : resources) {
            dataMovementInterfaces.add(AppCatalogThriftConversion.getDataMovementInterface((DataMovementInterfaceResource)resource));
        }
        return dataMovementInterfaces;
    }

    public static List<DataMovementInterface> getDataMovementInterfacesForStorageResource(List<AppCatalogResource> resources) {
        ArrayList<DataMovementInterface> dataMovementInterfaces = new ArrayList<DataMovementInterface>();
        for (AppCatalogResource resource : resources) {
            dataMovementInterfaces.add(AppCatalogThriftConversion.getDataMovementInterfaceForStorageResource((StorageInterfaceResource)resource));
        }
        return dataMovementInterfaces;
    }

    public static DataMovementInterface getDataMovementInterfaceForStorageResource(StorageInterfaceResource resource) {
        DataMovementInterface dmi = new DataMovementInterface();
        dmi.setDataMovementInterfaceId(resource.getDataMovementInterfaceId());
        dmi.setDataMovementProtocol(DataMovementProtocol.valueOf((String)resource.getDataMovementProtocol()));
        dmi.setPriorityOrder(resource.getPriorityOrder());
        return dmi;
    }

    public static DataMovementInterface getDataMovementInterface(DataMovementInterfaceResource resource) {
        DataMovementInterface dmi = new DataMovementInterface();
        dmi.setDataMovementInterfaceId(resource.getDataMovementInterfaceId());
        dmi.setDataMovementProtocol(DataMovementProtocol.valueOf((String)resource.getDataMovementProtocol()));
        dmi.setPriorityOrder(resource.getPriorityOrder());
        return dmi;
    }

    public static DataMovementInterfaceResource getDataMovementInterfaceResource(DataMovementInterface dataMovementInterface) {
        DataMovementInterfaceResource dmi = new DataMovementInterfaceResource();
        dmi.setDataMovementInterfaceId(dataMovementInterface.getDataMovementInterfaceId());
        dmi.setDataMovementProtocol(dataMovementInterface.getDataMovementProtocol().toString());
        dmi.setPriorityOrder(dataMovementInterface.getPriorityOrder());
        return dmi;
    }

    public static StorageInterfaceResource getStorageInterface(DataMovementInterface resource) {
        StorageInterfaceResource storageInterfaceResource = new StorageInterfaceResource();
        storageInterfaceResource.setDataMovementInterfaceId(resource.getDataMovementInterfaceId());
        storageInterfaceResource.setDataMovementProtocol(resource.getDataMovementProtocol().toString());
        storageInterfaceResource.setPriorityOrder(resource.getPriorityOrder());
        return storageInterfaceResource;
    }

    public static List<JobSubmissionInterface> getJobSubmissionInterfaces(List<AppCatalogResource> resources) {
        ArrayList<JobSubmissionInterface> jobSubmissionInterfaces = new ArrayList<JobSubmissionInterface>();
        for (AppCatalogResource resource : resources) {
            jobSubmissionInterfaces.add(AppCatalogThriftConversion.getJobSubmissionInterface((JobSubmissionInterfaceResource)resource));
        }
        return jobSubmissionInterfaces;
    }

    public static JobSubmissionInterface getJobSubmissionInterface(JobSubmissionInterfaceResource resource) {
        JobSubmissionInterface jsi = new JobSubmissionInterface();
        jsi.setJobSubmissionInterfaceId(resource.getJobSubmissionInterfaceId());
        jsi.setJobSubmissionProtocol(JobSubmissionProtocol.valueOf((String)resource.getJobSubmissionProtocol()));
        jsi.setPriorityOrder(resource.getPriorityOrder());
        return jsi;
    }

    public static JobSubmissionInterfaceResource getJobSubmissionInterface(JobSubmissionInterface resource) {
        JobSubmissionInterfaceResource jsi = new JobSubmissionInterfaceResource();
        jsi.setJobSubmissionInterfaceId(resource.getJobSubmissionInterfaceId());
        jsi.setJobSubmissionProtocol(resource.getJobSubmissionProtocol().toString());
        jsi.setPriorityOrder(resource.getPriorityOrder());
        return jsi;
    }

    public static BatchQueue getBatchQueue(BatchQueueResource resource) {
        BatchQueue batchQueue = new BatchQueue();
        batchQueue.setMaxJobsInQueue(resource.getMaxJobInQueue());
        batchQueue.setMaxNodes(resource.getMaxNodes());
        batchQueue.setMaxProcessors(resource.getMaxProcessors());
        batchQueue.setMaxRunTime(resource.getMaxRuntime());
        batchQueue.setMaxMemory(resource.getMaxMemory());
        batchQueue.setQueueDescription(resource.getQueueDescription());
        batchQueue.setQueueName(resource.getQueueName());
        batchQueue.setCpuPerNode(resource.getCpuPerNode());
        batchQueue.setDefaultNodeCount(resource.getDefaultNodeCount());
        batchQueue.setDefaultCPUCount(resource.getDefaultCPUCount());
        batchQueue.setDefaultWalltime(resource.getDefaultWalltime());
        batchQueue.setQueueSpecificMacros(resource.getQueueSpecificMacros());
        batchQueue.setIsDefaultQueue(resource.isDefaultQueue());
        return batchQueue;
    }

    public static BatchQueueResource getBatchQueue(BatchQueue resource) {
        BatchQueueResource batchQueue = new BatchQueueResource();
        batchQueue.setMaxJobInQueue(resource.getMaxJobsInQueue());
        batchQueue.setMaxNodes(resource.getMaxNodes());
        batchQueue.setMaxProcessors(resource.getMaxProcessors());
        batchQueue.setMaxRuntime(resource.getMaxRunTime());
        batchQueue.setQueueDescription(resource.getQueueDescription());
        batchQueue.setQueueName(resource.getQueueName());
        batchQueue.setMaxMemory(resource.getMaxMemory());
        batchQueue.setCpuPerNode(resource.getCpuPerNode());
        batchQueue.setDefaultCPUCount(resource.getDefaultCPUCount());
        batchQueue.setDefaultNodeCount(resource.getDefaultNodeCount());
        batchQueue.setDefaultWalltime(resource.getDefaultWalltime());
        batchQueue.setQueueSpecificMacros(resource.getQueueSpecificMacros());
        batchQueue.setIsDefaultQueue(resource.isIsDefaultQueue());
        return batchQueue;
    }

    public static SshJobSubmissionResource getSSHJobSubmission(SSHJobSubmission submission) {
        SshJobSubmissionResource resource = new SshJobSubmissionResource();
        resource.setAlternativeSshHostname(submission.getAlternativeSSHHostName());
        resource.setJobSubmissionInterfaceId(submission.getJobSubmissionInterfaceId());
        ResourceJobManagerResource resourceJobManager = AppCatalogThriftConversion.getResourceJobManager(submission.getResourceJobManager());
        resource.setResourceJobManagerId(resourceJobManager.getResourceJobManagerId());
        if (submission.getMonitorMode() != null) {
            resource.setMonitorMode(submission.getMonitorMode().toString());
        }
        resource.setResourceJobManagerResource(resourceJobManager);
        if (submission.getSecurityProtocol() != null) {
            resource.setSecurityProtocol(submission.getSecurityProtocol().toString());
        }
        resource.setSshPort(submission.getSshPort());
        return resource;
    }

    public static UnicoreJobSubmissionResource getUnicoreJobSubmission(UnicoreJobSubmission submission) {
        UnicoreJobSubmissionResource resource = new UnicoreJobSubmissionResource();
        resource.setjobSubmissionInterfaceId(submission.getJobSubmissionInterfaceId());
        if (submission.getSecurityProtocol() != null) {
            resource.setSecurityProtocol(submission.getSecurityProtocol().toString());
        }
        resource.setUnicoreEndpointUrl(submission.getUnicoreEndPointURL());
        return resource;
    }

    public static UnicoreDataMovementResource getUnicoreDMResource(UnicoreDataMovement dataMovement) {
        UnicoreDataMovementResource resource = new UnicoreDataMovementResource();
        resource.setDataMovementId(dataMovement.getDataMovementInterfaceId());
        if (dataMovement.getSecurityProtocol() != null) {
            resource.setSecurityProtocol(dataMovement.getSecurityProtocol().toString());
        }
        resource.setUnicoreEndpointUrl(dataMovement.getUnicoreEndPointURL());
        return resource;
    }

    public static CloudSubmissionResource getCloudJobSubmission(CloudJobSubmission submission) {
        CloudSubmissionResource resource = new CloudSubmissionResource();
        resource.setJobSubmissionInterfaceId(submission.getJobSubmissionInterfaceId());
        if (submission.getSecurityProtocol() != null) {
            resource.setSecurityProtocol(submission.getSecurityProtocol().toString());
        }
        if (submission.getProviderName() != null) {
            resource.setProviderName(submission.getProviderName().toString());
        }
        resource.setUserAccountName(submission.getUserAccountName());
        resource.setNodeId(submission.getNodeId());
        resource.setExecutableType(submission.getExecutableType());
        return resource;
    }

    public static LocalDataMovementResource getLocalDataMovement(LOCALDataMovement localSubmission) throws AppCatalogException {
        LocalDataMovementResource submission = new LocalDataMovementResource();
        submission.setDataMovementInterfaceId(localSubmission.getDataMovementInterfaceId());
        return submission;
    }

    public static LOCALDataMovement getLocalDataMovement(LocalDataMovementResource localSubmission) throws AppCatalogException {
        LOCALDataMovement submission = new LOCALDataMovement();
        submission.setDataMovementInterfaceId(localSubmission.getDataMovementInterfaceId());
        return submission;
    }

    public static LocalSubmissionResource getLocalJobSubmission(LOCALSubmission localSubmission) throws AppCatalogException {
        LocalSubmissionResource submission = new LocalSubmissionResource();
        submission.setJobSubmissionInterfaceId(localSubmission.getJobSubmissionInterfaceId());
        ResourceJobManagerResource resourceJobManager = AppCatalogThriftConversion.getResourceJobManager(localSubmission.getResourceJobManager());
        submission.setResourceJobManagerId(resourceJobManager.getResourceJobManagerId());
        submission.setResourceJobManagerResource(resourceJobManager);
        return submission;
    }

    public static LOCALSubmission getLocalJobSubmission(LocalSubmissionResource localSubmission) throws AppCatalogException {
        LOCALSubmission submission = new LOCALSubmission();
        submission.setJobSubmissionInterfaceId(localSubmission.getJobSubmissionInterfaceId());
        submission.setResourceJobManager(AppCatalogThriftConversion.getResourceJobManager(localSubmission.getResourceJobManagerResource()));
        submission.setSecurityProtocol(SecurityProtocol.valueOf((String)localSubmission.getSecurityProtocol()));
        return submission;
    }

    public static ResourceJobManagerResource getResourceJobManager(ResourceJobManager manager) {
        ResourceJobManagerResource r = new ResourceJobManagerResource();
        r.setResourceJobManagerId(manager.getResourceJobManagerId());
        r.setJobManagerBinPath(manager.getJobManagerBinPath());
        r.setPushMonitoringEndpoint(manager.getPushMonitoringEndpoint());
        r.setResourceJobManagerType(manager.getResourceJobManagerType().toString());
        return r;
    }

    public static ResourceJobManager getResourceJobManager(ResourceJobManagerResource manager) throws AppCatalogException {
        ResourceJobManager r = new ResourceJobManager();
        r.setResourceJobManagerId(manager.getResourceJobManagerId());
        r.setJobManagerBinPath(manager.getJobManagerBinPath());
        r.setPushMonitoringEndpoint(manager.getPushMonitoringEndpoint());
        r.setResourceJobManagerType(ResourceJobManagerType.valueOf((String)manager.getResourceJobManagerType()));
        r.setJobManagerCommands(new HashMap());
        JobManagerCommandResource jmcr = new JobManagerCommandResource();
        List<AppCatalogResource> jmcrList = jmcr.get("resourceJobManagerId", manager.getResourceJobManagerId());
        if (jmcrList != null && !jmcrList.isEmpty()) {
            for (AppCatalogResource rrr : jmcrList) {
                JobManagerCommandResource rr = (JobManagerCommandResource)rrr;
                r.getJobManagerCommands().put(JobManagerCommand.valueOf((String)rr.getCommandType()), rr.getCommand());
            }
        }
        r.setParallelismPrefix(new HashMap());
        ParallelismPrefixCommandResource prefixCommandResource = new ParallelismPrefixCommandResource();
        List<AppCatalogResource> resourceList = prefixCommandResource.get("resourceJobManagerId", manager.getResourceJobManagerId());
        if (resourceList != null && !resourceList.isEmpty()) {
            for (AppCatalogResource rrr : resourceList) {
                ParallelismPrefixCommandResource rr = (ParallelismPrefixCommandResource)rrr;
                r.getParallelismPrefix().put(ApplicationParallelismType.valueOf((String)rr.getCommandType()), rr.getCommand());
            }
        }
        return r;
    }

    public static SSHJobSubmission getSSHJobSubmissionDescription(SshJobSubmissionResource submission) throws AppCatalogException {
        SSHJobSubmission sshJobSubmission = new SSHJobSubmission();
        sshJobSubmission.setAlternativeSSHHostName(submission.getAlternativeSshHostname());
        sshJobSubmission.setJobSubmissionInterfaceId(submission.getJobSubmissionInterfaceId());
        sshJobSubmission.setResourceJobManager(AppCatalogThriftConversion.getResourceJobManager(submission.getResourceJobManagerResource()));
        sshJobSubmission.setSecurityProtocol(SecurityProtocol.valueOf((String)submission.getSecurityProtocol()));
        sshJobSubmission.setSshPort(submission.getSshPort());
        if (submission.getMonitorMode() != null) {
            sshJobSubmission.setMonitorMode(MonitorMode.valueOf((String)submission.getMonitorMode()));
        }
        return sshJobSubmission;
    }

    public static UnicoreJobSubmission getUnicoreJobSubmissionDescription(UnicoreJobSubmissionResource submission) throws AppCatalogException {
        UnicoreJobSubmission unicoreJobSubmission = new UnicoreJobSubmission();
        unicoreJobSubmission.setUnicoreEndPointURL(submission.getUnicoreEndpointUrl());
        unicoreJobSubmission.setJobSubmissionInterfaceId(submission.getjobSubmissionInterfaceId());
        if (submission.getSecurityProtocol() != null) {
            unicoreJobSubmission.setSecurityProtocol(SecurityProtocol.valueOf((String)submission.getSecurityProtocol()));
        }
        return unicoreJobSubmission;
    }

    public static UnicoreDataMovement getUnicoreDMDescription(UnicoreDataMovementResource resource) throws AppCatalogException {
        UnicoreDataMovement dataMovement = new UnicoreDataMovement();
        dataMovement.setUnicoreEndPointURL(resource.getUnicoreEndpointUrl());
        dataMovement.setDataMovementInterfaceId(resource.getDataMovementId());
        if (resource.getSecurityProtocol() != null) {
            dataMovement.setSecurityProtocol(SecurityProtocol.valueOf((String)resource.getSecurityProtocol()));
        }
        return dataMovement;
    }

    public static CloudJobSubmission getCloudJobSubmissionDescription(CloudSubmissionResource submission) throws AppCatalogException {
        CloudJobSubmission cloudJobSubmission = new CloudJobSubmission();
        cloudJobSubmission.setJobSubmissionInterfaceId(submission.getJobSubmissionInterfaceId());
        cloudJobSubmission.setExecutableType(submission.getExecutableType());
        cloudJobSubmission.setSecurityProtocol(SecurityProtocol.valueOf((String)submission.getSecurityProtocol()));
        cloudJobSubmission.setNodeId(submission.getNodeId());
        cloudJobSubmission.setUserAccountName(submission.getUserAccountName());
        cloudJobSubmission.setProviderName(ProviderName.valueOf((String)submission.getProviderName()));
        return cloudJobSubmission;
    }

    public static SCPDataMovement getSCPDataMovementDescription(ScpDataMovementResource dataMovementResource) throws AppCatalogException {
        SCPDataMovement dataMovement = new SCPDataMovement();
        dataMovement.setDataMovementInterfaceId(dataMovementResource.getDataMovementInterfaceId());
        dataMovement.setAlternativeSCPHostName(dataMovementResource.getAlternativeScpHostname());
        dataMovement.setSecurityProtocol(SecurityProtocol.valueOf((String)dataMovementResource.getSecurityProtocol()));
        dataMovement.setSshPort(dataMovementResource.getSshPort());
        return dataMovement;
    }

    public static ScpDataMovementResource getSCPDataMovementDescription(SCPDataMovement dataMovementResource) throws AppCatalogException {
        ScpDataMovementResource dataMovement = new ScpDataMovementResource();
        dataMovement.setDataMovementInterfaceId(dataMovementResource.getDataMovementInterfaceId());
        dataMovement.setAlternativeScpHostname(dataMovementResource.getAlternativeSCPHostName());
        dataMovement.setSecurityProtocol(dataMovementResource.getSecurityProtocol().toString());
        dataMovement.setSshPort(dataMovementResource.getSshPort());
        return dataMovement;
    }

    public static GridFTPDataMovement getGridFTPDataMovementDescription(GridftpDataMovementResource dataMovementResource) throws AppCatalogException {
        GridFTPDataMovement dataMovement = new GridFTPDataMovement();
        dataMovement.setDataMovementInterfaceId(dataMovementResource.getDataMovementInterfaceId());
        dataMovement.setSecurityProtocol(SecurityProtocol.valueOf((String)dataMovementResource.getSecurityProtocol()));
        GridftpEndpointResource endpointResource = new GridftpEndpointResource();
        List<AppCatalogResource> endpoints = endpointResource.get("dataMovementInterfaceId", dataMovementResource.getDataMovementInterfaceId());
        if (endpoints != null && !endpoints.isEmpty()) {
            dataMovement.setGridFTPEndPoints(AppCatalogThriftConversion.getGridFTPDMEPList(endpoints));
        }
        return dataMovement;
    }

    public static GridftpDataMovementResource getGridFTPDataMovementDescription(GridFTPDataMovement dataMovementResource) throws AppCatalogException {
        GridftpDataMovementResource dataMovement = new GridftpDataMovementResource();
        dataMovement.setDataMovementInterfaceId(dataMovementResource.getDataMovementInterfaceId());
        dataMovement.setSecurityProtocol(dataMovementResource.getSecurityProtocol().toString());
        return dataMovement;
    }

    public static List<String> getGridFTPDMEPList(List<AppCatalogResource> endpoints) {
        ArrayList<String> list = new ArrayList<String>();
        for (AppCatalogResource resource : endpoints) {
            list.add(((GridftpEndpointResource)resource).getEndpoint());
        }
        return list;
    }

    public static List<String> getGlobusGateKeeperEndPointList(List<AppCatalogResource> resources) throws AppCatalogException {
        ArrayList<String> list = new ArrayList<String>();
        for (AppCatalogResource resource : resources) {
            list.add(((GlobusGKEndpointResource)resource).getEndpoint());
        }
        return list;
    }

    public static ApplicationModule getApplicationModuleDesc(AppModuleResource resource) {
        ApplicationModule module = new ApplicationModule();
        module.setAppModuleId(resource.getModuleId());
        module.setAppModuleDescription(resource.getModuleDesc());
        module.setAppModuleName(resource.getModuleName());
        module.setAppModuleVersion(resource.getModuleVersion());
        return module;
    }

    public static ApplicationInterfaceDescription getApplicationInterfaceDescription(AppInterfaceResource resource) throws AppCatalogException {
        ApplicationOutputResource outputResource;
        List<AppCatalogResource> appOutputs;
        ApplicationInputResource inputResource;
        List<AppCatalogResource> appInputs;
        ApplicationInterfaceDescription description = new ApplicationInterfaceDescription();
        description.setApplicationInterfaceId(resource.getInterfaceId());
        description.setApplicationName(resource.getAppName());
        description.setApplicationDescription(resource.getAppDescription());
        description.setArchiveWorkingDirectory(resource.isArchiveWorkingDirectory());
        description.setHasOptionalFileInputs(resource.isHasOptionalFileInputs());
        AppModuleMappingAppCatalogResourceAppCat appModuleMappingResource = new AppModuleMappingAppCatalogResourceAppCat();
        List<AppCatalogResource> appModules = appModuleMappingResource.get("interfaceID", resource.getInterfaceId());
        if (appModules != null && !appModules.isEmpty()) {
            description.setApplicationModules(AppCatalogThriftConversion.getAppModuleIds(appModules));
        }
        if ((appInputs = (inputResource = new ApplicationInputResource()).get("interfaceID", resource.getInterfaceId())) != null && !appInputs.isEmpty()) {
            description.setApplicationInputs(AppCatalogThriftConversion.getAppInputs(appInputs));
        }
        if ((appOutputs = (outputResource = new ApplicationOutputResource()).get("interfaceID", resource.getInterfaceId())) != null && !appOutputs.isEmpty()) {
            description.setApplicationOutputs(AppCatalogThriftConversion.getAppOutputs(appOutputs));
        }
        return description;
    }

    public static List<String> getAppModuleIds(List<AppCatalogResource> appModuleMappings) {
        ArrayList<String> modules = new ArrayList<String>();
        for (AppCatalogResource resource : appModuleMappings) {
            modules.add(((AppModuleMappingAppCatalogResourceAppCat)resource).getModuleId());
        }
        return modules;
    }

    public static List<ApplicationModule> getAppModules(List<AppCatalogResource> appModules) {
        ArrayList<ApplicationModule> modules = new ArrayList<ApplicationModule>();
        for (AppCatalogResource resource : appModules) {
            modules.add(AppCatalogThriftConversion.getApplicationModuleDesc((AppModuleResource)resource));
        }
        return modules;
    }

    public static List<ApplicationInterfaceDescription> getAppInterfaceDescList(List<AppCatalogResource> appInterfaces) throws AppCatalogException {
        ArrayList<ApplicationInterfaceDescription> interfaceDescriptions = new ArrayList<ApplicationInterfaceDescription>();
        for (AppCatalogResource resource : appInterfaces) {
            interfaceDescriptions.add(AppCatalogThriftConversion.getApplicationInterfaceDescription((AppInterfaceResource)resource));
        }
        return interfaceDescriptions;
    }

    public static List<InputDataObjectType> getAppInputs(List<AppCatalogResource> resources) {
        ArrayList<InputDataObjectType> inputs = new ArrayList<InputDataObjectType>();
        for (AppCatalogResource resource : resources) {
            inputs.add(AppCatalogThriftConversion.getInputDataObjType((ApplicationInputResource)resource));
        }
        return inputs;
    }

    public static InputDataObjectType getInputDataObjType(ApplicationInputResource input) {
        InputDataObjectType inputDataObjectType = new InputDataObjectType();
        inputDataObjectType.setName(input.getInputKey());
        inputDataObjectType.setValue(input.getInputVal());
        inputDataObjectType.setApplicationArgument(input.getAppArgument());
        inputDataObjectType.setInputOrder(input.getInputOrder());
        inputDataObjectType.setMetaData(input.getMetadata());
        inputDataObjectType.setType(DataType.valueOf((String)input.getDataType()));
        inputDataObjectType.setStandardInput(input.isStandardInput());
        inputDataObjectType.setUserFriendlyDescription(input.getUserFriendlyDesc());
        inputDataObjectType.setIsRequired(input.getRequired());
        inputDataObjectType.setRequiredToAddedToCommandLine(input.getRequiredToCMD());
        inputDataObjectType.setDataStaged(input.isDataStaged());
        inputDataObjectType.setIsReadOnly(input.isReadOnly());
        return inputDataObjectType;
    }

    public static List<OutputDataObjectType> getAppOutputs(List<AppCatalogResource> resources) {
        ArrayList<OutputDataObjectType> outputs = new ArrayList<OutputDataObjectType>();
        for (AppCatalogResource resource : resources) {
            outputs.add(AppCatalogThriftConversion.getOutputDataObjType((ApplicationOutputResource)resource));
        }
        return outputs;
    }

    public static OutputDataObjectType getOutputDataObjType(ApplicationOutputResource output) {
        OutputDataObjectType outputDataObjectType = new OutputDataObjectType();
        outputDataObjectType.setName(output.getOutputKey());
        outputDataObjectType.setValue(output.getOutputVal());
        outputDataObjectType.setType(DataType.valueOf((String)output.getDataType()));
        outputDataObjectType.setIsRequired(output.getRequired());
        outputDataObjectType.setRequiredToAddedToCommandLine(output.getRequiredToCMD());
        outputDataObjectType.setDataMovement(output.isDataMovement());
        outputDataObjectType.setLocation(output.getDataNameLocation());
        outputDataObjectType.setSearchQuery(output.getSearchQuery());
        outputDataObjectType.setApplicationArgument(output.getAppArgument());
        outputDataObjectType.setOutputStreaming(output.isOutputStreaming());
        return outputDataObjectType;
    }

    public static ApplicationDeploymentDescription getApplicationDeploymentDescription(AppDeploymentResource resource) throws AppCatalogException {
        PostJobCommandResource postJobCommandResource;
        List<AppCatalogResource> postJobCommands;
        PreJobCommandResource preJobCommandResource;
        List<AppCatalogResource> preJobCommands;
        AppEnvironmentResource appEnvironmentResource;
        List<AppCatalogResource> appEnvList;
        LibraryApendPathResource apendPathResource;
        List<AppCatalogResource> libApendPaths;
        LibraryPrepandPathResource prepandPathResource;
        List<AppCatalogResource> libPrepandPaths;
        ApplicationDeploymentDescription description = new ApplicationDeploymentDescription();
        description.setAppDeploymentId(resource.getDeploymentId());
        description.setAppModuleId(resource.getAppModuleId());
        description.setComputeHostId(resource.getHostId());
        description.setExecutablePath(resource.getExecutablePath());
        if (resource.getParallelism() != null) {
            description.setParallelism(ApplicationParallelismType.valueOf((String)resource.getParallelism()));
        }
        description.setAppDeploymentDescription(resource.getAppDes());
        description.setDefaultQueueName(resource.getDefaultQueueName());
        description.setDefaultCPUCount(resource.getDefaultCPUCount());
        description.setDefaultNodeCount(resource.getDefaultNodeCount());
        description.setDefaultWalltime(resource.getDefaultWalltime());
        description.setEditableByUser(resource.isEditableByUser());
        ModuleLoadCmdResource cmdResource = new ModuleLoadCmdResource();
        List<AppCatalogResource> moduleLoadCmds = cmdResource.get("appDeploymentId", resource.getDeploymentId());
        if (moduleLoadCmds != null && !moduleLoadCmds.isEmpty()) {
            for (AppCatalogResource moduleLoadCmd : moduleLoadCmds) {
                description.addToModuleLoadCmds(AppCatalogThriftConversion.getCommandObject(((ModuleLoadCmdResource)moduleLoadCmd).getCmd(), ((ModuleLoadCmdResource)moduleLoadCmd).getOrder()));
            }
        }
        if ((libPrepandPaths = (prepandPathResource = new LibraryPrepandPathResource()).get("deploymentID", resource.getDeploymentId())) != null && !libPrepandPaths.isEmpty()) {
            description.setLibPrependPaths(AppCatalogThriftConversion.getLibPrepandPaths(libPrepandPaths));
        }
        if ((libApendPaths = (apendPathResource = new LibraryApendPathResource()).get("deploymentID", resource.getDeploymentId())) != null && !libApendPaths.isEmpty()) {
            description.setLibAppendPaths(AppCatalogThriftConversion.getLibApendPaths(libApendPaths));
        }
        if ((appEnvList = (appEnvironmentResource = new AppEnvironmentResource()).get("deploymentID", resource.getDeploymentId())) != null && !appEnvList.isEmpty()) {
            description.setSetEnvironment(AppCatalogThriftConversion.getAppEnvPaths(appEnvList));
        }
        if ((preJobCommands = (preJobCommandResource = new PreJobCommandResource()).get("deploymentId", resource.getDeploymentId())) != null && !preJobCommands.isEmpty()) {
            for (AppCatalogResource prejobCommand : preJobCommands) {
                description.addToPreJobCommands(AppCatalogThriftConversion.getCommandObject(((PreJobCommandResource)prejobCommand).getCommand(), ((PreJobCommandResource)prejobCommand).getOrder()));
            }
        }
        if ((postJobCommands = (postJobCommandResource = new PostJobCommandResource()).get("deploymentId", resource.getDeploymentId())) != null && !postJobCommands.isEmpty()) {
            for (AppCatalogResource postjobCommand : postJobCommands) {
                description.addToPostJobCommands(AppCatalogThriftConversion.getCommandObject(((PostJobCommandResource)postjobCommand).getCommand(), ((PostJobCommandResource)postjobCommand).getOrder()));
            }
        }
        return description;
    }

    private static CommandObject getCommandObject(String command, int commandOrder) {
        CommandObject commandObject = new CommandObject();
        commandObject.setCommand(command);
        commandObject.setCommandOrder(commandOrder);
        return commandObject;
    }

    public static List<ApplicationDeploymentDescription> getAppDepDescList(List<AppCatalogResource> resources) throws AppCatalogException {
        ArrayList<ApplicationDeploymentDescription> appList = new ArrayList<ApplicationDeploymentDescription>();
        for (AppCatalogResource resource : resources) {
            appList.add(AppCatalogThriftConversion.getApplicationDeploymentDescription((AppDeploymentResource)resource));
        }
        return appList;
    }

    public static SetEnvPaths getSetEnvPath(AppCatalogResource resource) {
        SetEnvPaths envPaths = new SetEnvPaths();
        if (resource instanceof LibraryPrepandPathResource) {
            envPaths.setName(((LibraryPrepandPathResource)resource).getName());
            envPaths.setValue(((LibraryPrepandPathResource)resource).getValue());
            return envPaths;
        }
        if (resource instanceof LibraryApendPathResource) {
            envPaths.setName(((LibraryApendPathResource)resource).getName());
            envPaths.setValue(((LibraryApendPathResource)resource).getValue());
            return envPaths;
        }
        if (resource instanceof AppEnvironmentResource) {
            AppEnvironmentResource environmentResource = (AppEnvironmentResource)resource;
            envPaths.setName(environmentResource.getName());
            envPaths.setValue(environmentResource.getValue());
            if (environmentResource.getOrder() != null) {
                envPaths.setEnvPathOrder(environmentResource.getOrder().intValue());
            }
            return envPaths;
        }
        return null;
    }

    public static List<SetEnvPaths> getLibPrepandPaths(List<AppCatalogResource> prepandPaths) {
        ArrayList<SetEnvPaths> pathList = new ArrayList<SetEnvPaths>();
        for (AppCatalogResource resource : prepandPaths) {
            pathList.add(AppCatalogThriftConversion.getSetEnvPath(resource));
        }
        return pathList;
    }

    public static List<SetEnvPaths> getLibApendPaths(List<AppCatalogResource> appendPaths) {
        ArrayList<SetEnvPaths> pathList = new ArrayList<SetEnvPaths>();
        for (AppCatalogResource resource : appendPaths) {
            pathList.add(AppCatalogThriftConversion.getSetEnvPath(resource));
        }
        return pathList;
    }

    public static List<SetEnvPaths> getAppEnvPaths(List<AppCatalogResource> appEnvPaths) {
        ArrayList<SetEnvPaths> pathList = new ArrayList<SetEnvPaths>();
        for (AppCatalogResource resource : appEnvPaths) {
            pathList.add(AppCatalogThriftConversion.getSetEnvPath(resource));
        }
        return pathList;
    }

    public static ComputeResourcePreference getComputeResourcePreference(ComputeHostPreferenceResource resource) {
        ComputeResourcePreference preference = new ComputeResourcePreference();
        preference.setComputeResourceId(resource.getResourceId());
        preference.setOverridebyAiravata(resource.getOverrideByAiravata());
        if (resource.getPreferredJobProtocol() != null) {
            preference.setPreferredJobSubmissionProtocol(JobSubmissionProtocol.valueOf((String)resource.getPreferredJobProtocol()));
        }
        if (resource.getPreferedDMProtocol() != null) {
            preference.setPreferredDataMovementProtocol(DataMovementProtocol.valueOf((String)resource.getPreferedDMProtocol()));
        }
        preference.setPreferredBatchQueue(resource.getBatchQueue());
        preference.setScratchLocation(resource.getScratchLocation());
        preference.setAllocationProjectNumber(resource.getProjectNumber());
        preference.setLoginUserName(resource.getLoginUserName());
        preference.setResourceSpecificCredentialStoreToken(resource.getResourceCSToken());
        if (null != resource.getUsageReportingGatewayId()) {
            preference.setUsageReportingGatewayId(resource.getUsageReportingGatewayId());
        } else {
            preference.setUsageReportingGatewayId(resource.getGatewayId());
        }
        preference.setQualityOfService(resource.getQualityOfService());
        preference.setReservation(resource.getReservation());
        if (resource.getReservationStartTime() != null) {
            preference.setReservationStartTime(resource.getReservationStartTime().getTime());
        }
        if (resource.getReservationEndTime() != null) {
            preference.setReservationEndTime(resource.getReservationEndTime().getTime());
        }
        preference.setSshAccountProvisioner(resource.getSshAccountProvisioner());
        if (resource.getSshAccountProvisionerConfigurations() != null && !resource.getSshAccountProvisionerConfigurations().isEmpty()) {
            HashMap<String, String> sshAccountProvisionerConfigCopy = new HashMap<String, String>(resource.getSshAccountProvisionerConfigurations());
            preference.setSshAccountProvisionerConfig(sshAccountProvisionerConfigCopy);
        }
        preference.setSshAccountProvisionerAdditionalInfo(resource.getSshAccountProvisionerAdditionalInfo());
        return preference;
    }

    public static UserComputeResourcePreference getUserComputeResourcePreference(UserComputeHostPreferenceResource resource) {
        UserComputeResourcePreference preference = new UserComputeResourcePreference();
        preference.setComputeResourceId(resource.getResourceId());
        preference.setPreferredBatchQueue(resource.getBatchQueue());
        preference.setScratchLocation(resource.getScratchLocation());
        preference.setAllocationProjectNumber(resource.getProjectNumber());
        preference.setLoginUserName(resource.getLoginUserName());
        preference.setResourceSpecificCredentialStoreToken(resource.getResourceCSToken());
        preference.setQualityOfService(resource.getQualityOfService());
        preference.setReservation(resource.getReservation());
        if (resource.getReservationStartTime() != null) {
            preference.setReservationStartTime(resource.getReservationStartTime().getTime());
        }
        if (resource.getReservationEndTime() != null) {
            preference.setReservationEndTime(resource.getReservationEndTime().getTime());
        }
        preference.setValidated(resource.isValidated());
        return preference;
    }

    public static List<ComputeResourcePreference> getComputeResourcePreferences(List<AppCatalogResource> resources) {
        ArrayList<ComputeResourcePreference> preferences = new ArrayList<ComputeResourcePreference>();
        if (resources != null && !resources.isEmpty()) {
            for (AppCatalogResource resource : resources) {
                preferences.add(AppCatalogThriftConversion.getComputeResourcePreference((ComputeHostPreferenceResource)resource));
            }
        }
        return preferences;
    }

    public static List<UserComputeResourcePreference> getUserComputeResourcePreferences(List<AppCatalogResource> resources) {
        ArrayList<UserComputeResourcePreference> preferences = new ArrayList<UserComputeResourcePreference>();
        if (resources != null && !resources.isEmpty()) {
            for (AppCatalogResource resource : resources) {
                preferences.add(AppCatalogThriftConversion.getUserComputeResourcePreference((UserComputeHostPreferenceResource)resource));
            }
        }
        return preferences;
    }

    public static StoragePreference getDataStoragePreference(StoragePreferenceResource resource) {
        StoragePreference preference = new StoragePreference();
        preference.setStorageResourceId(resource.getStorageResourceId());
        preference.setFileSystemRootLocation(resource.getFsRootLocation());
        preference.setLoginUserName(resource.getLoginUserName());
        preference.setResourceSpecificCredentialStoreToken(resource.getResourceCSToken());
        return preference;
    }

    public static List<StoragePreference> getDataStoragePreferences(List<AppCatalogResource> resources) {
        ArrayList<StoragePreference> preferences = new ArrayList<StoragePreference>();
        if (resources != null && !resources.isEmpty()) {
            for (AppCatalogResource resource : resources) {
                preferences.add(AppCatalogThriftConversion.getDataStoragePreference((StoragePreferenceResource)resource));
            }
        }
        return preferences;
    }

    public static UserStoragePreference getUserDataStoragePreference(UserStoragePreferenceResource resource) {
        UserStoragePreference preference = new UserStoragePreference();
        preference.setStorageResourceId(resource.getStorageResourceId());
        preference.setFileSystemRootLocation(resource.getFsRootLocation());
        preference.setLoginUserName(resource.getLoginUserName());
        preference.setResourceSpecificCredentialStoreToken(resource.getResourceCSToken());
        return preference;
    }

    public static List<UserStoragePreference> getUserDataStoragePreferences(List<AppCatalogResource> resources) {
        ArrayList<UserStoragePreference> preferences = new ArrayList<UserStoragePreference>();
        if (resources != null && !resources.isEmpty()) {
            for (AppCatalogResource resource : resources) {
                preferences.add(AppCatalogThriftConversion.getUserDataStoragePreference((UserStoragePreferenceResource)resource));
            }
        }
        return preferences;
    }

    public static GatewayResourceProfile getGatewayResourceProfile(GatewayProfileResource gw, List<ComputeResourcePreference> preferences, List<StoragePreference> storagePreferences) {
        GatewayResourceProfile gatewayProfile = new GatewayResourceProfile();
        gatewayProfile.setGatewayID(gw.getGatewayID());
        gatewayProfile.setCredentialStoreToken(gw.getCredentialStoreToken());
        gatewayProfile.setIdentityServerTenant(gw.getIdentityServerTenant());
        gatewayProfile.setIdentityServerPwdCredToken(gw.getIdentityServerPwdCredToken());
        gatewayProfile.setComputeResourcePreferences(preferences);
        gatewayProfile.setStoragePreferences(storagePreferences);
        return gatewayProfile;
    }

    public static UserResourceProfile getUserResourceProfile(UserResourceProfileResource gw, List<UserComputeResourcePreference> preferences, List<UserStoragePreference> storagePreferences) {
        UserResourceProfile userResourceProfile = new UserResourceProfile();
        userResourceProfile.setGatewayID(gw.getGatewayID());
        userResourceProfile.setUserId(gw.getUserId());
        userResourceProfile.setCredentialStoreToken(gw.getCredentialStoreToken());
        userResourceProfile.setIdentityServerTenant(gw.getIdentityServerTenant());
        userResourceProfile.setIdentityServerPwdCredToken(gw.getIdentityServerPwdCredToken());
        userResourceProfile.setUserComputeResourcePreferences(preferences);
        userResourceProfile.setUserStoragePreferences(storagePreferences);
        return userResourceProfile;
    }

    public static UserResourceProfile createNullUserResourceProfile(String userId, String gatewayId) {
        UserResourceProfile userResourceProfile = new UserResourceProfile(userId, gatewayId);
        userResourceProfile.setIsNull(true);
        return userResourceProfile;
    }
}

