/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.app.catalog.resources;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.AiravataUtils;
import org.apache.airavata.registry.core.app.catalog.model.GridftpDataMovement;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatAbstractResource;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatalogResource;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogJPAUtils;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogQueryGenerator;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogResourceType;
import org.apache.airavata.registry.cpi.AppCatalogException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GridftpDataMovementResource
extends AppCatAbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(GridftpDataMovementResource.class);
    private String dataMovementInterfaceId;
    private String securityProtocol;
    private Timestamp createdTime;
    private Timestamp updatedTime;

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(Timestamp createdTime) {
        this.createdTime = createdTime;
    }

    public Timestamp getUpdatedTime() {
        return this.updatedTime;
    }

    public void setUpdatedTime(Timestamp updatedTime) {
        this.updatedTime = updatedTime;
    }

    @Override
    public void remove(Object identifier) throws AppCatalogException {
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("GridftpDataMovement", new Object[0][]);
            generator.setParameter("dataMovementInterfaceId", identifier);
            Query q = generator.deleteQuery(em);
            q.executeUpdate();
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public AppCatalogResource get(Object identifier) throws AppCatalogException {
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("GridftpDataMovement", new Object[0][]);
            generator.setParameter("dataMovementInterfaceId", identifier);
            Query q = generator.selectQuery(em);
            GridftpDataMovement gridftpDataMovement = (GridftpDataMovement)q.getSingleResult();
            GridftpDataMovementResource gridftpDataMovementResource = (GridftpDataMovementResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.GRIDFTP_DATA_MOVEMENT, gridftpDataMovement);
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            GridftpDataMovementResource gridftpDataMovementResource2 = gridftpDataMovementResource;
            return gridftpDataMovementResource2;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public List<AppCatalogResource> get(String fieldName, Object value) throws AppCatalogException {
        ArrayList<AppCatalogResource> gridftpDataMovementResources = new ArrayList<AppCatalogResource>();
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("GridftpDataMovement", new Object[0][]);
            if (fieldName.equals("dataMovementInterfaceId") || fieldName.equals("securityProtocol")) {
                generator.setParameter(fieldName, value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                for (Object result : results) {
                    GridftpDataMovement gridftpDataMovement = (GridftpDataMovement)result;
                    GridftpDataMovementResource gridftpDataMovementResource = (GridftpDataMovementResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.GRIDFTP_DATA_MOVEMENT, gridftpDataMovement);
                    gridftpDataMovementResources.add(gridftpDataMovementResource);
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for Gridftp Data Movement Resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for Gridftp Data Movement Resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return gridftpDataMovementResources;
    }

    @Override
    public List<AppCatalogResource> getAll() throws AppCatalogException {
        return null;
    }

    @Override
    public List<String> getAllIds() throws AppCatalogException {
        return null;
    }

    @Override
    public List<String> getIds(String fieldName, Object value) throws AppCatalogException {
        ArrayList<String> gridftpDataMovementResourceIDs = new ArrayList<String>();
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("GridftpDataMovement", new Object[0][]);
            if (fieldName.equals("dataMovementInterfaceId") || fieldName.equals("securityProtocol")) {
                generator.setParameter(fieldName, value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                for (Object result : results) {
                    GridftpDataMovement gridftpDataMovement = (GridftpDataMovement)result;
                    GridftpDataMovementResource gridftpDataMovementResource = (GridftpDataMovementResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.GRIDFTP_DATA_MOVEMENT, gridftpDataMovement);
                    gridftpDataMovementResourceIDs.add(gridftpDataMovementResource.getDataMovementInterfaceId());
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for Gridftp Data Movement Resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for Gridftp Data Movement Resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return gridftpDataMovementResourceIDs;
    }

    @Override
    public void save() throws AppCatalogException {
        EntityManager em = null;
        try {
            GridftpDataMovement gridftpDataMovement;
            em = AppCatalogJPAUtils.getEntityManager();
            GridftpDataMovement existingGridftpDataMovement = (GridftpDataMovement)em.find(GridftpDataMovement.class, (Object)this.dataMovementInterfaceId);
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            if (existingGridftpDataMovement == null) {
                gridftpDataMovement = new GridftpDataMovement();
                gridftpDataMovement.setCreationTime(AiravataUtils.getCurrentTimestamp());
            } else {
                gridftpDataMovement = existingGridftpDataMovement;
                gridftpDataMovement.setUpdateTime(AiravataUtils.getCurrentTimestamp());
            }
            gridftpDataMovement.setDataMovementInterfaceId(this.getDataMovementInterfaceId());
            gridftpDataMovement.setSecurityProtocol(this.getSecurityProtocol());
            if (existingGridftpDataMovement == null) {
                em.persist((Object)gridftpDataMovement);
            } else {
                em.merge((Object)gridftpDataMovement);
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public boolean isExists(Object identifier) throws AppCatalogException {
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            GridftpDataMovement gridftpDataMovement = (GridftpDataMovement)em.find(GridftpDataMovement.class, identifier);
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            boolean bl = gridftpDataMovement != null;
            return bl;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public String getDataMovementInterfaceId() {
        return this.dataMovementInterfaceId;
    }

    public String getSecurityProtocol() {
        return this.securityProtocol;
    }

    public void setDataMovementInterfaceId(String dataMovementInterfaceId) {
        this.dataMovementInterfaceId = dataMovementInterfaceId;
    }

    public void setSecurityProtocol(String securityProtocol) {
        this.securityProtocol = securityProtocol;
    }
}

