/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.jdbc.handlers.builtin;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.CollectionImpl;
import org.wso2.carbon.registry.core.Comment;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.Tag;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.HandlerManager;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class SymLinkHandler
extends Handler {
    private static final Log log = LogFactory.getLog(ResourceImpl.class);
    private static Set<SymLinkHandler> symLinkHandlers = new HashSet<SymLinkHandler>();
    private String mountPoint;
    private String targetPoint;
    private String author;
    private boolean isHandlerRegistered = false;

    @Override
    public int hashCode() {
        return this.getEqualsComparator().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null && obj instanceof SymLinkHandler && ((SymLinkHandler)obj).getEqualsComparator().equals(this.getEqualsComparator());
    }

    private String getEqualsComparator() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append("|");
        sb.append(this.mountPoint);
        sb.append("|");
        sb.append(this.targetPoint);
        sb.append("|");
        sb.append(this.author);
        return sb.toString();
    }

    @Override
    public void put(RequestContext requestContext) throws RegistryException {
        this.registerHandler(requestContext.getSystemRegistry());
        String fullPath = requestContext.getResourcePath().getPath();
        String actualPath = this.getActualPath(fullPath);
        try {
            Resource resource = requestContext.getResource();
            resource.removeProperty("registry.mountpoint");
            resource.removeProperty("registry.targetpoint");
            resource.removeProperty("registry.author");
            resource.removeProperty("registry.link");
            resource.removeProperty("registry.actualpath");
            requestContext.getRegistry().put(actualPath, requestContext.getResource());
            requestContext.setProcessingComplete(true);
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage());
        }
    }

    @Override
    public boolean resourceExists(RequestContext requestContext) throws RegistryException {
        this.registerHandler(requestContext.getSystemRegistry());
        boolean resourceExists = false;
        String fullPath = requestContext.getResourcePath().getPath();
        String subPath = fullPath.substring(this.mountPoint.length(), fullPath.length());
        String actualPath = this.targetPoint + subPath;
        try {
            resourceExists = requestContext.getRegistry().resourceExists(actualPath);
        }
        catch (Exception e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Could not create the symbolic link. Target " + actualPath + "not found."));
            }
            log.debug((Object)"Caused by: ", (Throwable)e);
        }
        requestContext.setProcessingComplete(true);
        return resourceExists;
    }

    @Override
    public Resource get(RequestContext requestContext) throws RegistryException {
        Resource tempResource;
        this.registerHandler(requestContext.getSystemRegistry());
        String fullPath = requestContext.getResourcePath().getPath();
        String subPath = fullPath.substring(this.mountPoint.length(), fullPath.length());
        String actualPath = this.targetPoint + subPath;
        if (requestContext.getRegistry().resourceExists(actualPath)) {
            tempResource = requestContext.getRegistry().get(actualPath);
            if (tempResource instanceof Collection) {
                String[] paths = (String[])tempResource.getContent();
                for (int i = 0; i < paths.length; ++i) {
                    paths[i] = this.targetPoint.equals("/") ? this.mountPoint + paths[i] : this.mountPoint + paths[i].substring(this.targetPoint.length(), paths[i].length());
                }
                ((CollectionImpl)tempResource).setContentWithNoUpdate(paths);
            }
            ((ResourceImpl)tempResource).setPath(fullPath);
            ((ResourceImpl)tempResource).setAuthorUserName(this.author);
            ((ResourceImpl)tempResource).setUserName(CurrentSession.getUser());
            ((ResourceImpl)tempResource).setTenantId(CurrentSession.getTenantId());
        } else {
            tempResource = requestContext.getRepository().get(this.mountPoint);
            ((ResourceImpl)tempResource).addPropertyWithNoUpdate("registry.absent", "true");
            tempResource.setDescription("Couldn't create the symbolic link. Content can't be displayed.");
        }
        ((ResourceImpl)tempResource).addPropertyWithNoUpdate("registry.link", "true");
        ((ResourceImpl)tempResource).removePropertyWithNoUpdate("registry.nonrecursive");
        ((ResourceImpl)tempResource).removePropertyWithNoUpdate("registry.linkrestoration");
        ((ResourceImpl)tempResource).removePropertyWithNoUpdate("registry.realpath");
        ((ResourceImpl)tempResource).addPropertyWithNoUpdate("registry.mountpoint", this.mountPoint);
        ((ResourceImpl)tempResource).addPropertyWithNoUpdate("registry.targetpoint", this.targetPoint);
        ((ResourceImpl)tempResource).addPropertyWithNoUpdate("registry.author", this.author);
        if (tempResource.getProperty("registry.actualpath") == null) {
            ((ResourceImpl)tempResource).addPropertyWithNoUpdate("registry.actualpath", actualPath);
        }
        ((ResourceImpl)tempResource).addPropertyWithNoUpdate("registry.path", fullPath);
        requestContext.setProcessingComplete(true);
        return tempResource;
    }

    @Override
    public void delete(RequestContext requestContext) throws RegistryException {
        this.registerHandler(requestContext.getSystemRegistry());
        String fullPath = requestContext.getResourcePath().getPath();
        RegistryContext registryContext = requestContext.getRegistryContext();
        if (fullPath.equals(this.mountPoint)) {
            requestContext.getRegistry().removeLink(fullPath);
            if (registryContext != null) {
                HandlerManager hm = registryContext.getHandlerManager();
                hm.removeHandler(this, "tenant");
            }
        } else {
            String subPath = fullPath.substring(this.mountPoint.length(), fullPath.length());
            String actualPath = this.targetPoint + subPath;
            requestContext.getRegistry().delete(actualPath);
        }
        requestContext.setProcessingComplete(true);
    }

    @Override
    public String rename(RequestContext requestContext) throws RegistryException {
        this.registerHandler(requestContext.getSystemRegistry());
        String fullResourcePath = requestContext.getSourcePath();
        String fullTargetPath = requestContext.getTargetPath();
        RegistryContext registryContext = requestContext.getRegistryContext();
        if (fullResourcePath.equals(this.mountPoint)) {
            requestContext.getRegistry().removeLink(this.mountPoint);
            if (registryContext != null) {
                HandlerManager hm = registryContext.getHandlerManager();
                hm.removeHandler(this, "tenant");
            }
            requestContext.getRegistry().createLink(fullTargetPath, this.targetPoint);
        } else {
            String subPath = fullResourcePath.substring(this.mountPoint.length(), fullResourcePath.length());
            String actualResourcePath = this.targetPoint + subPath;
            subPath = fullTargetPath.substring(this.mountPoint.length(), fullTargetPath.length());
            String actualTargetPath = this.targetPoint + subPath;
            requestContext.getRegistry().rename(actualResourcePath, actualTargetPath);
        }
        requestContext.setProcessingComplete(true);
        return fullTargetPath;
    }

    @Override
    public String move(RequestContext requestContext) throws RegistryException {
        this.registerHandler(requestContext.getSystemRegistry());
        String fullResourcePath = requestContext.getSourcePath();
        String fullTargetPath = requestContext.getTargetPath();
        RegistryContext registryContext = requestContext.getRegistryContext();
        if (fullResourcePath.equals(this.mountPoint)) {
            requestContext.getRegistry().removeLink(this.mountPoint);
            if (registryContext != null) {
                HandlerManager hm = registryContext.getHandlerManager();
                hm.removeHandler(this, "tenant");
            }
            requestContext.getRegistry().createLink(fullTargetPath, this.targetPoint);
        } else if (fullResourcePath.startsWith(this.mountPoint)) {
            String subPath = fullResourcePath.substring(this.mountPoint.length(), fullResourcePath.length());
            String actualResourcePath = this.targetPoint.equals("/") ? subPath : this.targetPoint + subPath;
            requestContext.getRegistry().move(actualResourcePath, fullTargetPath);
        } else if (fullTargetPath.startsWith(this.mountPoint)) {
            String subPath = fullTargetPath.substring(this.mountPoint.length(), fullTargetPath.length());
            String actualTargetPath = this.targetPoint.equals("/") ? subPath : this.targetPoint + subPath;
            requestContext.getRegistry().move(fullResourcePath, actualTargetPath);
        }
        requestContext.setProcessingComplete(true);
        return fullTargetPath;
    }

    @Override
    public String copy(RequestContext requestContext) throws RegistryException {
        this.registerHandler(requestContext.getSystemRegistry());
        String fullResourcePath = requestContext.getSourcePath();
        String fullTargetPath = requestContext.getTargetPath();
        if (fullResourcePath.equals(this.mountPoint)) {
            requestContext.getRegistry().createLink(fullTargetPath, this.targetPoint);
        } else if (fullResourcePath.startsWith(this.mountPoint)) {
            String subPath = fullResourcePath.substring(this.mountPoint.length(), fullResourcePath.length());
            String actualResourcePath = this.targetPoint.equals("/") ? subPath : this.targetPoint + subPath;
            requestContext.getRegistry().copy(actualResourcePath, fullTargetPath);
        } else if (fullTargetPath.startsWith(this.mountPoint)) {
            String subPath = fullTargetPath.substring(this.mountPoint.length(), fullTargetPath.length());
            String actualTargetPath = this.targetPoint.equals("/") ? subPath : this.targetPoint + subPath;
            requestContext.getRegistry().copy(fullResourcePath, actualTargetPath);
        }
        requestContext.setProcessingComplete(true);
        return fullTargetPath;
    }

    @Override
    public float getAverageRating(RequestContext requestContext) throws RegistryException {
        this.registerHandler(requestContext.getSystemRegistry());
        String fullPath = requestContext.getResourcePath().getPath();
        String actualPath = this.getActualPath(fullPath);
        float rating = requestContext.getRegistry().getAverageRating(actualPath);
        requestContext.setProcessingComplete(true);
        return rating;
    }

    @Override
    public int getRating(RequestContext requestContext) throws RegistryException {
        this.registerHandler(requestContext.getSystemRegistry());
        String fullPath = requestContext.getResourcePath().getPath();
        String actualPath = this.getActualPath(fullPath);
        int rating = requestContext.getRegistry().getRating(actualPath, requestContext.getUserName());
        requestContext.setProcessingComplete(true);
        return rating;
    }

    @Override
    public void rateResource(RequestContext requestContext) throws RegistryException {
        this.registerHandler(requestContext.getSystemRegistry());
        String fullPath = requestContext.getResourcePath().getPath();
        String actualPath = this.getActualPath(fullPath);
        requestContext.getRegistry().rateResource(actualPath, requestContext.getRating());
        requestContext.setProcessingComplete(true);
    }

    @Override
    public Comment[] getComments(RequestContext requestContext) throws RegistryException {
        this.registerHandler(requestContext.getSystemRegistry());
        String fullPath = requestContext.getResourcePath().getPath();
        String actualPath = this.getActualPath(fullPath);
        Comment[] comments = requestContext.getRegistry().getComments(actualPath);
        requestContext.setProcessingComplete(true);
        return comments;
    }

    @Override
    public String addComment(RequestContext requestContext) throws RegistryException {
        this.registerHandler(requestContext.getSystemRegistry());
        String fullPath = requestContext.getResourcePath().getPath();
        String actualPath = this.getActualPath(fullPath);
        String commentPath = requestContext.getRegistry().addComment(actualPath, requestContext.getComment());
        requestContext.setProcessingComplete(true);
        return commentPath;
    }

    @Override
    public Tag[] getTags(RequestContext requestContext) throws RegistryException {
        this.registerHandler(requestContext.getSystemRegistry());
        String fullPath = requestContext.getResourcePath().getPath();
        String actualPath = this.getActualPath(fullPath);
        Tag[] tags = requestContext.getRegistry().getTags(actualPath);
        requestContext.setProcessingComplete(true);
        return tags;
    }

    @Override
    public void applyTag(RequestContext requestContext) throws RegistryException {
        this.registerHandler(requestContext.getSystemRegistry());
        String fullPath = requestContext.getResourcePath().getPath();
        String actualPath = this.getActualPath(fullPath);
        requestContext.getRegistry().applyTag(actualPath, requestContext.getTag());
        requestContext.setProcessingComplete(true);
    }

    @Override
    public Association[] getAllAssociations(RequestContext requestContext) throws RegistryException {
        Association[] associations;
        this.registerHandler(requestContext.getSystemRegistry());
        String fullPath = requestContext.getResourcePath().getPath();
        String actualPath = this.getActualPath(fullPath);
        for (Association association : associations = requestContext.getRegistry().getAllAssociations(actualPath)) {
            String sourcePath = association.getSourcePath();
            String destinationPath = association.getDestinationPath();
            if (sourcePath.equals(actualPath)) {
                association.setSourcePath(fullPath);
            }
            if (!destinationPath.equals(actualPath)) continue;
            association.setDestinationPath(fullPath);
        }
        requestContext.setProcessingComplete(true);
        return associations;
    }

    @Override
    public Association[] getAssociations(RequestContext requestContext) throws RegistryException {
        Association[] associations;
        this.registerHandler(requestContext.getSystemRegistry());
        String fullPath = requestContext.getResourcePath().getPath();
        String actualPath = this.getActualPath(fullPath);
        for (Association association : associations = requestContext.getRegistry().getAssociations(actualPath, requestContext.getAssociationType())) {
            String sourcePath = association.getSourcePath();
            if (sourcePath.substring(sourcePath.lastIndexOf(47), sourcePath.length()).equals(fullPath)) {
                if (this.targetPoint.equals("/")) {
                    association.setSourcePath(this.mountPoint + sourcePath);
                    continue;
                }
                association.setSourcePath(this.mountPoint + sourcePath.substring(this.targetPoint.length(), sourcePath.length()));
                continue;
            }
            String destinationPath = association.getDestinationPath();
            if (this.targetPoint.equals("/")) {
                association.setDestinationPath(this.mountPoint + destinationPath);
                continue;
            }
            association.setDestinationPath(this.mountPoint + destinationPath.substring(this.targetPoint.length(), destinationPath.length()));
        }
        requestContext.setProcessingComplete(true);
        return associations;
    }

    @Override
    public void addAssociation(RequestContext requestContext) throws RegistryException {
        this.registerHandler(requestContext.getSystemRegistry());
        String fullPath = requestContext.getSourcePath();
        String actualPath = this.getActualPath(fullPath);
        requestContext.getRegistry().addAssociation(actualPath, requestContext.getTargetPath(), requestContext.getAssociationType());
        requestContext.setProcessingComplete(true);
    }

    @Override
    public void importResource(RequestContext requestContext) throws RegistryException {
        this.registerHandler(requestContext.getSystemRegistry());
        String fullPath = requestContext.getResourcePath().getPath();
        String actualPath = this.getActualPath(fullPath);
        requestContext.getRegistry().importResource(actualPath, requestContext.getSourceURL(), requestContext.getResource());
        requestContext.setProcessingComplete(true);
    }

    @Override
    public void removeLink(RequestContext requestContext) {
        requestContext.setProperty("SymlinkToRemovePropertyName", this);
    }

    private void registerHandler(Registry registry) throws RegistryException {
        if (!this.isHandlerRegistered) {
            RegistryUtils.addMountEntry(registry, RegistryContext.getBaseInstance(), this.mountPoint, this.targetPoint, false, this.author);
            this.isHandlerRegistered = true;
        }
    }

    public void setMountPoint(String mountPoint) {
        this.mountPoint = mountPoint;
    }

    public String getMountPoint() {
        return this.mountPoint;
    }

    public void setTargetPoint(String targetPoint) {
        this.targetPoint = targetPoint.endsWith("/") ? targetPoint.substring(0, targetPoint.length() - 1) : targetPoint;
    }

    public String getTargetPoint() {
        return this.targetPoint;
    }

    private String getActualPath(String fullPath) {
        String actualPath;
        if (fullPath.equals(this.mountPoint)) {
            actualPath = this.targetPoint;
        } else {
            String subPath = fullPath.substring(this.mountPoint.length(), fullPath.length());
            actualPath = this.targetPoint.equals("/") ? subPath : this.targetPoint + subPath;
        }
        return actualPath;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public static Set<SymLinkHandler> getSymLinkHandlers() {
        return symLinkHandlers;
    }

    @Override
    public void removeAssociation(RequestContext requestContext) throws RegistryException {
        this.registerHandler(requestContext.getSystemRegistry());
        String fullPath = requestContext.getSourcePath();
        String actualPath = this.getActualPath(fullPath);
        requestContext.getRegistry().removeAssociation(actualPath, requestContext.getTargetPath(), requestContext.getAssociationType());
        requestContext.setProcessingComplete(true);
    }

    @Override
    public void removeTag(RequestContext requestContext) throws RegistryException {
        this.registerHandler(requestContext.getSystemRegistry());
        String fullPath = requestContext.getResourcePath().getPath();
        String actualPath = this.getActualPath(fullPath);
        requestContext.getRegistry().removeTag(actualPath, requestContext.getTag());
        requestContext.setProcessingComplete(true);
    }
}

