/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uftp.server;

import eu.unicore.uftp.dpc.AuthorizationFailureException;
import eu.unicore.uftp.dpc.Utils;
import eu.unicore.uftp.server.ACLHandler;
import eu.unicore.uftp.server.ServerThread;
import eu.unicore.uftp.server.UFTPTransferRequest;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.RejectedExecutionException;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;

public class UFTPServer
implements Runnable {
    private static final Logger logger = Logger.getLogger(UFTPServer.class);
    private static String VER = UFTPServer.class.getPackage().getImplementationVersion();
    public static final int SYNERR = 1;
    public static final int LISTENSOCKERR = 2;
    public static final int THREADERR = 3;
    public static final int CMDSOCKERR = 4;
    public static final int BACKLOG = 50;
    private final InetAddress cmdip;
    private final InetAddress srvip;
    private final int cmdport;
    private final int srvport;
    int timeout = 5000;
    int authtimeout = 5000;
    int jobReadTimeout = 5000;
    int maxStreams = 8;
    int maxControlConnectionsPerClient = 16;
    int bufferSize = 131072;
    private ServerThread svrThread;
    private volatile boolean stopped = false;
    private final boolean useSSL;
    private ACLHandler acl;

    public UFTPServer(InetAddress cmdip, int cmdport, InetAddress srvip, int srvport) throws IOException {
        this.cmdip = cmdip;
        this.cmdport = cmdport;
        this.srvip = srvip;
        this.srvport = srvport;
        this.initSSLProperties();
        boolean bl = this.useSSL = System.getProperty("javax.net.ssl.keyStore") != null;
        if (this.useSSL) {
            this.checkSSL();
            File aclFile = new File(System.getProperty("uftpd.acl", "conf/uftpd.acl"));
            this.acl = new ACLHandler(aclFile);
        }
    }

    @Override
    public void run() {
        try {
            this.svrThread = new ServerThread(this.srvip, this.srvport, 50, this.maxStreams);
        }
        catch (IOException ex) {
            logger.error("Error starting 'ftp' listen socket. Please check the parameters for host and port.", ex);
            System.exit(2);
        }
        this.svrThread.setTimeout(this.timeout);
        this.svrThread.setAuthTimeout(this.authtimeout);
        this.svrThread.setMaxControlConnectionsPerClient(this.maxControlConnectionsPerClient);
        this.svrThread.setBufferSize(this.bufferSize);
        this.svrThread.start();
        logger.info("UFTPD Listener server socket started on " + this.srvip.getHostName() + ":" + this.srvport);
        ServerSocket cmdSocket = null;
        try {
            cmdSocket = this.createCommandSocket();
            logger.info("UFTPD Command server socket started on " + this.cmdip.getHostName() + ":" + this.cmdport);
        }
        catch (IOException e) {
            logger.error("Error starting command socket. Please check the parameters for command host and port.", e);
            System.exit(4);
        }
        logger.info("Maximum streams per client: " + this.maxStreams);
        logger.info("File buffer size per client: " + this.bufferSize + " kB");
        while (!this.stopped) {
            Socket jobSocket = null;
            try {
                jobSocket = cmdSocket.accept();
                logger.info("New control connection from " + jobSocket.getInetAddress());
                jobSocket.setSoTimeout(this.jobReadTimeout);
                if (this.useSSL) {
                    X500Principal x = (X500Principal)((SSLSocket)jobSocket).getSession().getPeerPrincipal();
                    this.acl.checkAccess(x.getName());
                }
                JobConnectionWorker jcw = new JobConnectionWorker(jobSocket, this.svrThread);
                Utils.getExecutor().execute(jcw);
            }
            catch (RejectedExecutionException ree) {
                this.handleErrorAndClose(jobSocket, "", ree);
            }
            catch (IOException e) {
                this.handleErrorAndClose(jobSocket, "Error receiving job", e);
            }
            catch (AuthorizationFailureException e) {
                this.handleErrorAndClose(jobSocket, "Access to command port denied", e);
            }
        }
        logger.info("Exiting UFTP server.");
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getAuthtimeout() {
        return this.authtimeout;
    }

    public void setAuthtimeout(int authtimeout) {
        this.authtimeout = authtimeout;
    }

    public void stop() {
        if (!this.stopped) {
            if (this.svrThread != null) {
                try {
                    this.svrThread.close();
                }
                catch (Exception ex) {
                    logger.error("Error stopping", ex);
                }
                this.svrThread.interrupt();
            }
            this.stopped = true;
        }
    }

    public static void main(String[] args) {
        Options options = UFTPServer.createOptions();
        GnuParser parser = new GnuParser();
        CommandLine line = null;
        try {
            line = parser.parse(options, args);
        }
        catch (ParseException pe) {
            System.out.println("Unable to parse options: " + pe.getLocalizedMessage());
            UFTPServer.printUsage(options);
            System.exit(1);
        }
        UFTPServer.printHeader();
        UFTPServer server = null;
        try {
            InetAddress cmdip = InetAddress.getByName(line.getOptionValue("c"));
            int cmdport = Integer.parseInt(line.getOptionValue("p"));
            InetAddress srvip = InetAddress.getByName(line.getOptionValue("l"));
            int srvport = Integer.parseInt(line.getOptionValue("L"));
            server = new UFTPServer(cmdip, cmdport, srvip, srvport);
            server.maxStreams = Integer.parseInt(line.getOptionValue("m", "8"));
            server.bufferSize = Integer.parseInt(line.getOptionValue("b", "128")) * 1024;
        }
        catch (Exception e) {
            System.out.println("Invalid option detected: " + e.getLocalizedMessage());
            UFTPServer.printUsage(options);
            System.exit(1);
        }
        if (server != null) {
            server.run();
        }
    }

    public static Options createOptions() {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"listen-host");
        OptionBuilder.withDescription((String)"Hostname of the listen socket");
        OptionBuilder.withArgName((String)"Listen host");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        options.addOption(OptionBuilder.create((String)"l"));
        OptionBuilder.withLongOpt((String)"listen-port");
        OptionBuilder.withDescription((String)"Port of the listen socket");
        OptionBuilder.withArgName((String)"Listen port");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        options.addOption(OptionBuilder.create((String)"L"));
        OptionBuilder.withLongOpt((String)"command-host");
        OptionBuilder.withDescription((String)"Hostname of the command socket");
        OptionBuilder.withArgName((String)"Command host");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        options.addOption(OptionBuilder.create((String)"c"));
        OptionBuilder.withLongOpt((String)"command-port");
        OptionBuilder.withDescription((String)"Port of the command socket");
        OptionBuilder.withArgName((String)"Command port");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        options.addOption(OptionBuilder.create((String)"p"));
        OptionBuilder.withLongOpt((String)"max-parallel");
        OptionBuilder.withDescription((String)"Limit on the number of parallel streams per client (default: 8)");
        OptionBuilder.withArgName((String)"Stream limit");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        options.addOption(OptionBuilder.create((String)"m"));
        OptionBuilder.withLongOpt((String)"buffersize");
        OptionBuilder.withDescription((String)"Buffer size in kbytes for reading/writing files (default 128)");
        OptionBuilder.withArgName((String)"bufferSize");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        options.addOption(OptionBuilder.create((String)"b"));
        return options;
    }

    public static void printHeader() {
        if (VER == null) {
            VER = "DEVELOPMENT";
        }
        String message = "**** UFTPD Version " + VER + " starting";
        logger.info(message);
    }

    public static void printUsage(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        String syntax = "UFTPD [OPTIONS]" + System.getProperty("line.separator");
        formatter.printHelp(syntax, options);
    }

    private void handleErrorAndClose(Socket jobSocket, String error, Throwable e) {
        logger.error(error, e);
        try {
            if (jobSocket != null) {
                jobSocket.close();
            }
        }
        catch (Exception ex) {
            logger.error("Error closing socket", ex);
        }
    }

    private ServerSocket createCommandSocket() throws IOException {
        if (this.useSSL) {
            return this.createSecureCommandSocket();
        }
        logger.info("*****");
        logger.info("*****   WARNING:");
        logger.info("****    Using a plain-text socket for receiving commands.");
        logger.info("****    On production systems you should enable SSL!");
        logger.info("****    Consult the UFTP manual for details.");
        logger.info("*****");
        return new ServerSocket(this.cmdport, 50, this.cmdip);
    }

    private SSLServerSocket createSecureCommandSocket() throws IOException {
        logger.info("Creating SSL socket for receiving commands.");
        ServerSocketFactory f = SSLServerSocketFactory.getDefault();
        SSLServerSocket s = (SSLServerSocket)f.createServerSocket(this.cmdport, 50, this.cmdip);
        s.setNeedClientAuth(true);
        return s;
    }

    private String getFromCommandline() {
        System.out.println("Please enter the keystore password:");
        return new String(System.console().readPassword());
    }

    private void initSSLProperties() throws IOException {
        String file = System.getProperty("uftpd-ssl.conf");
        if (file != null) {
            File sslProps = new File(file);
            if (!sslProps.exists()) {
                throw new IOException("SSL properties file " + file + " does not exist!");
            }
            logger.info("Loading SSL settings from " + file);
            Properties p = new Properties();
            p.load(new FileInputStream(sslProps));
            System.getProperties().putAll((Map<?, ?>)p);
        }
    }

    private void checkSSL() throws IOException {
        String trustStore;
        String keyStore = System.getProperty("javax.net.ssl.keyStore");
        logger.info("Enabling SSL, using keystore = " + keyStore);
        String keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword");
        if (keyStorePassword == null) {
            keyStorePassword = this.getFromCommandline();
            System.setProperty("javax.net.ssl.keyStorePassword", keyStorePassword);
        }
        if ((trustStore = System.getProperty("javax.net.ssl.trustStore")) == null) {
            logger.warn("No truststore defined, will use Java system truststore.");
        } else {
            logger.info("Using truststore  = " + trustStore);
            String trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword");
            if (trustStorePassword == null && keyStore.equals(trustStore)) {
                System.setProperty("javax.net.ssl.trustStorePassword", keyStorePassword);
            }
        }
    }

    public static class JobConnectionWorker
    implements Runnable {
        final Socket jobSocket;
        final ServerThread serverThread;

        public JobConnectionWorker(Socket jobSocket, ServerThread serverThread) {
            this.jobSocket = jobSocket;
            this.serverThread = serverThread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                String response;
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(this.jobSocket.getInputStream()));
                StringBuilder sb = new StringBuilder();
                while ((line = br.readLine()) != null && line.length() != 0 && !line.equals("END")) {
                    sb.append(line).append("\n");
                }
                String jobString = sb.toString();
                logger.debug("New request: " + jobString);
                try {
                    UFTPTransferRequest j = new UFTPTransferRequest(jobString);
                    this.serverThread.addJob(j);
                    response = "OK::" + String.valueOf(this.serverThread.getPort());
                }
                catch (IOException e) {
                    response = "500::" + Utils.createFaultMessage("Request rejected. Reason: ", e);
                    logger.error("Error adding job: " + jobString, e);
                }
                this.writeResponse(response, this.jobSocket.getOutputStream());
            }
            catch (IOException ioe) {
                logger.info("Error processing job connection.", ioe);
            }
            finally {
                try {
                    this.jobSocket.close();
                }
                catch (IOException iOException) {}
            }
        }

        void writeResponse(String msg, OutputStream os) throws IOException {
            OutputStreamWriter ow = new OutputStreamWriter(os, "UTF-8");
            ow.write(msg + "\n");
            ow.flush();
        }
    }
}

