/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uftp.client;

import eu.unicore.uftp.client.ClientAuthenticator;
import eu.unicore.uftp.dpc.AuthorizationFailureException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;

public class SecretClientAuth
implements ClientAuthenticator {
    private final String secret;

    public SecretClientAuth(String secret) {
        this.secret = secret;
    }

    @Override
    public void authenticate(Socket authSocket) throws AuthorizationFailureException {
        try {
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(authSocket.getOutputStream()));
            bw.write(this.secret + "\n");
            bw.flush();
            String answer = new BufferedReader(new InputStreamReader(authSocket.getInputStream())).readLine();
            if (!"Authorization OK".equals(answer)) {
                throw new AuthorizationFailureException("Unexpected server answer: Authorization OK != " + answer);
            }
        }
        catch (IOException e) {
            throw new AuthorizationFailureException("IOException during authentication " + e.getLocalizedMessage());
        }
    }
}

