/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.wsutil.client.authn;

import eu.unicore.security.canl.CredentialProperties;
import eu.unicore.security.canl.PasswordCallback;
import eu.unicore.security.canl.TruststoreProperties;
import eu.unicore.security.wsutil.client.authn.AuthenticationProvider;
import eu.unicore.security.wsutil.client.authn.DelegationSpecification;
import eu.unicore.security.wsutil.client.authn.PropertiesBasedAuthenticationProvider;
import eu.unicore.util.httpclient.ClientProperties;
import eu.unicore.util.httpclient.DefaultClientConfiguration;
import java.util.Properties;

public class KeystoreAuthN
extends PropertiesBasedAuthenticationProvider
implements AuthenticationProvider {
    public static final String X509 = "X509";

    public KeystoreAuthN(Properties properties, PasswordCallback passwordCallback) {
        super(properties, passwordCallback);
    }

    protected KeystoreAuthN() {
    }

    @Override
    public String getName() {
        return X509;
    }

    @Override
    public String getDescription() {
        return "Uses a local keystore and optional truststore file.";
    }

    @Override
    public DefaultClientConfiguration getClientConfiguration(String targetAddress, String targetDn, DelegationSpecification delegate) throws Exception {
        ClientProperties sp = new ClientProperties(this.properties, this.truststorePasswordCallback, "truststore.", "credential.", "client.");
        this.applyLocalDelegation(sp, targetDn, delegate);
        return sp;
    }

    @Override
    public String getUsage() {
        StringBuilder ret = new StringBuilder();
        ret.append("The following properties can be used in the UCC preference file to configure the X509 authentication. Many of these are optional. Refer to the manual and/or the example files.\n");
        ret.append("\nFor configuring your credential:\n");
        ret.append(this.getMeta(CredentialProperties.class, "credential."));
        ret.append("\nFor configuring your trusted CAs and certificates:\n");
        ret.append(this.getMeta(TruststoreProperties.class, "truststore."));
        return ret.toString();
    }
}

