/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.lookup;

import de.fzj.unicore.uas.StorageFactory;
import de.fzj.unicore.uas.client.StorageFactoryClient;
import de.fzj.unicore.uas.lookup.AddressFilter;
import de.fzj.unicore.uas.lookup.Lister;
import de.fzj.unicore.uas.lookup.Producer;
import de.fzj.unicore.uas.security.WSRFClientConfigurationProvider;
import de.fzj.unicore.uas.util.Pair;
import de.fzj.unicore.wsrflite.xmlbeans.client.IRegistryQuery;
import eu.unicore.security.wsutil.client.authn.DelegationSpecification;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class StorageFactoryLister
extends Lister<StorageFactoryClient> {
    static final Logger log = Log.getLogger("unicore.client", StorageFactoryLister.class);
    private final IRegistryQuery registry;
    private final WSRFClientConfigurationProvider configurationProvider;

    public StorageFactoryLister(IRegistryQuery registry, WSRFClientConfigurationProvider configurationProvider) {
        this(null, registry, configurationProvider, new Lister.AcceptAllFilter<StorageFactoryClient>());
    }

    public StorageFactoryLister(ExecutorService executor, IRegistryQuery registry, WSRFClientConfigurationProvider configurationProvider) {
        this(executor, registry, configurationProvider, new Lister.AcceptAllFilter<StorageFactoryClient>());
    }

    public StorageFactoryLister(ExecutorService executor, IRegistryQuery registry, WSRFClientConfigurationProvider configurationProvider, AddressFilter<StorageFactoryClient> addressFilter) {
        super(executor, addressFilter, Integer.MAX_VALUE);
        this.registry = registry;
        this.configurationProvider = configurationProvider;
    }

    @Override
    public Iterator<StorageFactoryClient> iterator() {
        try {
            this.setupProducers();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return super.iterator();
    }

    protected void setupProducers() throws Exception {
        List<EndpointReferenceType> smfs = this.registry.listAccessibleServices(StorageFactory.SMF_PORT);
        for (EndpointReferenceType smf : smfs) {
            if (!this.addressFilter.accept(smf)) continue;
            this.addProducer(new StorageFactoryProducer(smf, this.configurationProvider.getClientConfiguration(smf, DelegationSpecification.STANDARD), this.addressFilter));
        }
    }

    public static class StorageFactoryProducer
    implements Producer<StorageFactoryClient> {
        private final EndpointReferenceType epr;
        protected final IClientConfiguration securityProperties;
        protected final List<Pair<EndpointReferenceType, String>> errors = new ArrayList<Pair<EndpointReferenceType, String>>();
        private AtomicInteger runCount;
        protected BlockingQueue<StorageFactoryClient> target;
        protected AddressFilter<StorageFactoryClient> addressFilter;

        public StorageFactoryProducer(EndpointReferenceType epr, IClientConfiguration securityProperties, AddressFilter<StorageFactoryClient> addressFilter) {
            this.epr = epr;
            this.securityProperties = securityProperties;
            this.addressFilter = addressFilter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Processing storage factory at " + this.epr.getAddress().getStringValue());
                }
                this.handleEPR(this.epr);
            }
            catch (Exception ex) {
                this.errors.add(new Pair<EndpointReferenceType, String>(this.epr, Log.createFaultMessage("", ex)));
            }
            finally {
                this.runCount.decrementAndGet();
            }
        }

        public void handleEPR(EndpointReferenceType epr) throws Exception {
            StorageFactoryClient c;
            if (this.addressFilter.accept(epr) && this.addressFilter.accept(c = new StorageFactoryClient(epr, this.securityProperties))) {
                this.target.put(c);
            }
        }

        @Override
        public void init(BlockingQueue<StorageFactoryClient> target, AtomicInteger runCount) {
            this.target = target;
            this.runCount = runCount;
        }
    }
}

