/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directconnect.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.directconnect.model.CreatePrivateVirtualInterfaceRequest;
import com.amazonaws.services.directconnect.model.NewPrivateVirtualInterface;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class CreatePrivateVirtualInterfaceRequestMarshaller
implements Marshaller<Request<CreatePrivateVirtualInterfaceRequest>, CreatePrivateVirtualInterfaceRequest> {
    public Request<CreatePrivateVirtualInterfaceRequest> marshall(CreatePrivateVirtualInterfaceRequest createPrivateVirtualInterfaceRequest) {
        if (createPrivateVirtualInterfaceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createPrivateVirtualInterfaceRequest, "AmazonDirectConnect");
        String target = "OvertureService.CreatePrivateVirtualInterface";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            NewPrivateVirtualInterface newPrivateVirtualInterface;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (createPrivateVirtualInterfaceRequest.getConnectionId() != null) {
                jsonWriter.key("connectionId").value((Object)createPrivateVirtualInterfaceRequest.getConnectionId());
            }
            if ((newPrivateVirtualInterface = createPrivateVirtualInterfaceRequest.getNewPrivateVirtualInterface()) != null) {
                jsonWriter.key("newPrivateVirtualInterface");
                jsonWriter.object();
                if (newPrivateVirtualInterface.getVirtualInterfaceName() != null) {
                    jsonWriter.key("virtualInterfaceName").value((Object)newPrivateVirtualInterface.getVirtualInterfaceName());
                }
                if (newPrivateVirtualInterface.getVlan() != null) {
                    jsonWriter.key("vlan").value((Object)newPrivateVirtualInterface.getVlan());
                }
                if (newPrivateVirtualInterface.getAsn() != null) {
                    jsonWriter.key("asn").value((Object)newPrivateVirtualInterface.getAsn());
                }
                if (newPrivateVirtualInterface.getAuthKey() != null) {
                    jsonWriter.key("authKey").value((Object)newPrivateVirtualInterface.getAuthKey());
                }
                if (newPrivateVirtualInterface.getAmazonAddress() != null) {
                    jsonWriter.key("amazonAddress").value((Object)newPrivateVirtualInterface.getAmazonAddress());
                }
                if (newPrivateVirtualInterface.getCustomerAddress() != null) {
                    jsonWriter.key("customerAddress").value((Object)newPrivateVirtualInterface.getCustomerAddress());
                }
                if (newPrivateVirtualInterface.getVirtualGatewayId() != null) {
                    jsonWriter.key("virtualGatewayId").value((Object)newPrivateVirtualInterface.getVirtualGatewayId());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

