/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.multitenancy.transports;

import org.apache.axiom.util.UIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.transport.TransportSender;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.httpclient.HttpMethod;
import org.wso2.carbon.utils.multitenancy.MultitenantConstants;

public class TenantTransportSender
extends AbstractHandler
implements TransportSender {
    private ConfigurationContext superTenantConfigurationContext;

    public TenantTransportSender(ConfigurationContext superTenantConfigurationContext) {
        this.superTenantConfigurationContext = superTenantConfigurationContext;
    }

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        EndpointReference epr;
        MessageContext inMessageContext;
        MessageContext superTenantOutMessageContext = this.superTenantConfigurationContext.createMessageContext();
        superTenantOutMessageContext.setProperty("TRANSPORT_OUT", msgContext.getProperty("TRANSPORT_OUT"));
        superTenantOutMessageContext.setProperty("OutTransportInfo", msgContext.getProperty("OutTransportInfo"));
        AxisConfiguration supperTenantAxisConfiguration = this.superTenantConfigurationContext.getAxisConfiguration();
        AxisService axisService = supperTenantAxisConfiguration.getService("__MultitenantDispatcherService");
        superTenantOutMessageContext.setAxisService(axisService);
        AxisServiceGroup axisServiceGroup = supperTenantAxisConfiguration.getServiceGroup("__MultitenantDispatcherService");
        ServiceGroupContext serviceGroupContext = this.superTenantConfigurationContext.createServiceGroupContext(axisServiceGroup);
        ServiceContext serviceContext = serviceGroupContext.getServiceContext(axisService);
        superTenantOutMessageContext.setServiceContext(serviceContext);
        AxisOperation axisOperation = axisService.getOperation(MultitenantConstants.MULTITENANT_DISPATCHER_OPERATION);
        OperationContext operationContext = serviceContext.createOperationContext(axisOperation);
        operationContext.addMessageContext(superTenantOutMessageContext);
        superTenantOutMessageContext.setOperationContext(operationContext);
        String transportOutName = msgContext.getTransportOut().getName();
        superTenantOutMessageContext.setTransportOut(supperTenantAxisConfiguration.getTransportOut(transportOutName));
        superTenantOutMessageContext.setEnvelope(msgContext.getEnvelope());
        superTenantOutMessageContext.setTo(msgContext.getTo());
        superTenantOutMessageContext.setSoapAction(msgContext.getSoapAction());
        superTenantOutMessageContext.setDoingREST(msgContext.isDoingREST());
        superTenantOutMessageContext.setDoingMTOM(msgContext.isDoingMTOM());
        superTenantOutMessageContext.setProperty("TRANSPORT_HEADERS", msgContext.getProperty("TRANSPORT_HEADERS"));
        superTenantOutMessageContext.setProperty("HTTP_SC", msgContext.getProperty("HTTP_SC"));
        String msgTypeProperty = (String)msgContext.getProperty("messageType");
        superTenantOutMessageContext.setProperty("messageType", (Object)msgTypeProperty);
        String contentTypeProperty = (String)msgContext.getProperty("ContentType");
        superTenantOutMessageContext.setProperty("ContentType", (Object)contentTypeProperty);
        superTenantOutMessageContext.setDoingMTOM(msgContext.isDoingMTOM());
        superTenantOutMessageContext.setProperty("CHARACTER_SET_ENCODING", msgContext.getProperty("CHARACTER_SET_ENCODING"));
        superTenantOutMessageContext.setProperty("enableMTOM", msgContext.getProperty("enableMTOM"));
        superTenantOutMessageContext.setProperty("enableSwA", msgContext.getProperty("enableSwA"));
        superTenantOutMessageContext.setProperty("HTTP_METHOD", msgContext.getProperty("HTTP_METHOD"));
        superTenantOutMessageContext.setProperty("messageType", msgContext.getProperty("messageType"));
        if (msgContext.getOperationContext() != null && (inMessageContext = msgContext.getOperationContext().getMessageContext("In")) != null) {
            superTenantOutMessageContext.setProperty("RequestResponseTransportControl", inMessageContext.getProperty("RequestResponseTransportControl"));
        }
        if (msgContext.getProperty("disableAddressingForOutMessages") != null && ((Boolean)msgContext.getProperty("disableAddressingForOutMessages")).booleanValue()) {
            superTenantOutMessageContext.setProperty("disableAddressingForOutMessages", msgContext.getProperty("disableAddressingForOutMessages"));
        }
        if (msgContext.getProperty("pass-through.pipe") != null) {
            superTenantOutMessageContext.setProperty("pass-through.pipe", msgContext.getProperty("pass-through.pipe"));
            superTenantOutMessageContext.setProperty("message.builder.invoked", msgContext.getProperty("message.builder.invoked") != null ? msgContext.getProperty("message.builder.invoked") : Boolean.FALSE);
        }
        if (msgContext.getProperty("rest_get_delete_invoke") != null) {
            superTenantOutMessageContext.setProperty("rest_get_delete_invoke", msgContext.getProperty("rest_get_delete_invoke"));
        }
        if ((epr = TenantTransportSender.getDestinationEPR(msgContext)) != null) {
            String messageId = UIDGenerator.generateURNString();
            superTenantOutMessageContext.setMessageID(messageId);
            superTenantOutMessageContext.setProperty("TENANT_REQUEST_MSG_CTX", (Object)msgContext);
            superTenantOutMessageContext.setServerSide(true);
            MessageContext superTenantInMessageContext = new MessageContext();
            superTenantInMessageContext.setMessageID(superTenantOutMessageContext.getMessageID());
            superTenantInMessageContext.setProperty("synapse.RelatesToForPox", (Object)messageId);
            superTenantInMessageContext.setServerSide(true);
            superTenantInMessageContext.setMessageID(messageId);
            superTenantInMessageContext.setServiceContext(serviceContext);
            axisOperation.registerOperationContext(superTenantInMessageContext, operationContext);
        }
        if (!JavaUtils.isTrueExplicitly((Object)msgContext.getProperty("tenantMRStartedFault"))) {
            AxisEngine.send((MessageContext)superTenantOutMessageContext);
            if (superTenantOutMessageContext.getProperty("TRANSPORT_IN") != null) {
                msgContext.getOperationContext().setProperty("TRANSPORT_IN", superTenantOutMessageContext.getProperty("TRANSPORT_IN"));
            }
            msgContext.setProperty("HTTP_METHOD_OBJECT", superTenantOutMessageContext.getProperty("HTTP_METHOD_OBJECT"));
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    public void cleanup(MessageContext msgContext) throws AxisFault {
        HttpMethod httpMethod = (HttpMethod)msgContext.getProperty("HTTP_METHOD_OBJECT");
        if (httpMethod != null) {
            httpMethod.releaseConnection();
            msgContext.removeProperty("HTTP_METHOD_OBJECT");
        }
    }

    public void init(ConfigurationContext confContext, TransportOutDescription transportOut) throws AxisFault {
    }

    public void stop() {
    }

    public static EndpointReference getDestinationEPR(MessageContext msgContext) {
        String transportURL = (String)msgContext.getProperty("TransportURL");
        if (transportURL != null) {
            return new EndpointReference(transportURL);
        }
        if (msgContext.getTo() != null && !msgContext.getTo().hasAnonymousAddress()) {
            return msgContext.getTo();
        }
        return null;
    }
}

