/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.accountprovisioning;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.airavata.accountprovisioning.ConfigParam;
import org.apache.airavata.accountprovisioning.SSHAccountProvisioner;
import org.apache.airavata.accountprovisioning.SSHAccountProvisionerProvider;

public class SSHAccountProvisionerFactory {
    private static ServiceLoader<SSHAccountProvisionerProvider> sshAccountProvisionerProviders = ServiceLoader.load(SSHAccountProvisionerProvider.class);

    public static List<SSHAccountProvisionerProvider> getSSHAccountProvisionerProviders() {
        ArrayList<SSHAccountProvisionerProvider> providers = new ArrayList<SSHAccountProvisionerProvider>();
        sshAccountProvisionerProviders.forEach(providers::add);
        return providers;
    }

    public static List<ConfigParam> getSSHAccountProvisionerConfigParams(String provisionerName) {
        return SSHAccountProvisionerFactory.getSSHAccountProvisionerProvider(provisionerName).getConfigParams();
    }

    public static boolean canCreateAccount(String provisionerName) {
        return SSHAccountProvisionerFactory.getSSHAccountProvisionerProvider(provisionerName).canCreateAccount();
    }

    public static SSHAccountProvisioner createSSHAccountProvisioner(String provisionerName, Map<ConfigParam, String> config) {
        SSHAccountProvisionerProvider sshAccountProvisionerProvider = SSHAccountProvisionerFactory.getSSHAccountProvisionerProvider(provisionerName);
        return sshAccountProvisionerProvider.createSSHAccountProvisioner(config);
    }

    private static SSHAccountProvisionerProvider getSSHAccountProvisionerProvider(String provisionerName) {
        for (SSHAccountProvisionerProvider sshAccountProvisionerProvider : sshAccountProvisionerProviders) {
            if (!sshAccountProvisionerProvider.getName().equals(provisionerName)) continue;
            return sshAccountProvisionerProvider;
        }
        throw new RuntimeException("Unknown SSHAccountProvisioner named " + provisionerName);
    }
}

