/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.ns;

import eu.emi.security.authn.x509.helpers.ObserversHandler;
import eu.emi.security.authn.x509.helpers.ns.AbstractNamespacesStore;
import eu.emi.security.authn.x509.helpers.ns.GlobusNamespacesParser;
import eu.emi.security.authn.x509.helpers.ns.NamespacePolicy;
import eu.emi.security.authn.x509.helpers.ns.NamespacesParser;
import eu.emi.security.authn.x509.helpers.trust.OpensslTruststoreHelper;
import eu.emi.security.authn.x509.impl.OpensslNameUtils;
import java.util.List;
import javax.security.auth.x500.X500Principal;

public abstract class AbstractGlobusNamespacesStore
extends AbstractNamespacesStore {
    public static final String SUFFIX = ".signing_policy";

    public AbstractGlobusNamespacesStore(ObserversHandler observers, boolean openssl1Mode) {
        super(observers, openssl1Mode);
    }

    @Override
    protected String getNotificationType() {
        return "EACL namespace (signing_policy)";
    }

    @Override
    protected NamespacesParser getParser(String path) {
        return new GlobusNamespacesParser(path);
    }

    @Override
    protected String getFileSuffix() {
        return SUFFIX;
    }

    @Override
    public synchronized List<NamespacePolicy> getPolicies(X500Principal[] chain, int position) {
        X500Principal issuerSubject = chain[position];
        String dn = OpensslNameUtils.convertFromRfc2253(issuerSubject.getName(), false);
        String normalizedDn = OpensslNameUtils.normalize(dn);
        for (int i = position; i < chain.length; ++i) {
            X500Principal issuer = chain[i];
            String hash = OpensslTruststoreHelper.getOpenSSLCAHash(issuer, this.openssl1Mode);
            List<NamespacePolicy> ret = this.getPoliciesFor(hash, normalizedDn);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    protected abstract List<NamespacePolicy> getPoliciesFor(String var1, String var2);
}

