/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509;

import eu.emi.security.authn.x509.ValidationErrorCategory;
import eu.emi.security.authn.x509.ValidationErrorCode;
import eu.emi.security.authn.x509.impl.X500NameUtils;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ValidationError {
    private static final String BUNDLE_NAME = ValidationError.class.getPackage().getName() + "." + "valiadationErrors";
    private int position;
    private ValidationErrorCode errorCode;
    private ValidationErrorCategory errorCategory;
    private String message;
    private Object[] parameters;
    private X509Certificate[] chain;

    public ValidationError(X509Certificate[] chain, int position, ValidationErrorCode errorCode, Object ... params) {
        String pattern;
        this.position = position;
        this.chain = chain;
        if (errorCode == null) {
            throw new IllegalArgumentException("errorCode can not be null");
        }
        this.errorCode = errorCode;
        this.errorCategory = ValidationErrorCategory.getErrorCategory(errorCode);
        this.parameters = params;
        ResourceBundle bundle = ResourceBundle.getBundle(BUNDLE_NAME);
        try {
            pattern = bundle.getString(errorCode.name());
        }
        catch (MissingResourceException e) {
            pattern = "Other validation error";
        }
        this.message = this.parameters.length > 0 && this.parameters[0] instanceof Throwable && !pattern.matches(".*\\{[0-9]\\}.*") ? pattern + ValidationError.makeReasonFromStack((Throwable)this.parameters[0]) : MessageFormat.format(pattern, params);
    }

    public static String makeReasonFromStack(Throwable t) {
        StringBuilder sb = new StringBuilder();
        do {
            sb.append(" Cause: ").append(ValidationError.makeReason(t));
        } while ((t = t.getCause()) != null);
        return sb.toString();
    }

    public static String makeReason(Throwable t) {
        return t.getMessage() != null ? t.getMessage() : t.getClass().getSimpleName();
    }

    public int getPosition() {
        return this.position;
    }

    public String getMessage() {
        return this.message;
    }

    public ValidationErrorCode getErrorCode() {
        return this.errorCode;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public ValidationErrorCategory getErrorCategory() {
        return this.errorCategory;
    }

    public X509Certificate[] getChain() {
        return this.chain;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("error");
        if (this.position != -1) {
            sb.append(" at position ").append(this.getPosition()).append(" in chain");
            sb.append(", problematic certificate subject: ").append(X500NameUtils.getReadableForm(this.chain[this.position].getSubjectX500Principal()));
        } else {
            sb.append(" affecting the whole chain");
        }
        sb.append(" (category: ").append((Object)this.errorCategory).append(")");
        sb.append(": ").append(this.getMessage());
        return sb.toString();
    }
}

