/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.model;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.ddf.EscherChildAnchorRecord;
import org.apache.poi.ddf.EscherClientAnchorRecord;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherOptRecord;
import org.apache.poi.ddf.EscherProperty;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.EscherSimpleProperty;
import org.apache.poi.ddf.EscherSpRecord;
import org.apache.poi.hslf.model.Fill;
import org.apache.poi.hslf.model.Hyperlink;
import org.apache.poi.hslf.model.ShapeTypes;
import org.apache.poi.hslf.model.Sheet;
import org.apache.poi.hslf.record.ColorSchemeAtom;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public abstract class Shape {
    protected POILogger logger = POILogFactory.getLogger(this.getClass());
    public static final int EMU_PER_INCH = 914400;
    public static final int EMU_PER_POINT = 12700;
    public static final int EMU_PER_CENTIMETER = 360000;
    public static final int MASTER_DPI = 576;
    public static final int PIXEL_DPI = 96;
    public static final int POINT_DPI = 72;
    protected EscherContainerRecord _escherContainer;
    protected Shape _parent;
    protected Sheet _sheet;
    protected Fill _fill;

    protected Shape(EscherContainerRecord escherRecord, Shape parent) {
        this._escherContainer = escherRecord;
        this._parent = parent;
    }

    protected abstract EscherContainerRecord createSpContainer(boolean var1);

    public Shape getParent() {
        return this._parent;
    }

    public String getShapeName() {
        return ShapeTypes.typeName(this.getShapeType());
    }

    public int getShapeType() {
        EscherSpRecord spRecord = (EscherSpRecord)this._escherContainer.getChildById((short)-4086);
        return spRecord.getShapeType();
    }

    public void setShapeType(int type) {
        EscherSpRecord spRecord = (EscherSpRecord)this._escherContainer.getChildById((short)-4086);
        spRecord.setShapeType((short)type);
        spRecord.setVersion((short)2);
    }

    public Rectangle getAnchor() {
        Rectangle2D anchor2d = this.getAnchor2D();
        return anchor2d.getBounds();
    }

    public Rectangle2D getAnchor2D() {
        EscherSpRecord spRecord = (EscherSpRecord)this._escherContainer.getChildById((short)-4086);
        int flags = spRecord.getFlags();
        Rectangle2D anchor = null;
        if ((flags & 2) != 0) {
            EscherChildAnchorRecord rec = (EscherChildAnchorRecord)Shape.getEscherChild(this._escherContainer, -4081);
            anchor = new Rectangle();
            if (rec == null) {
                this.logger.log(5, "EscherSpRecord.FLAG_CHILD is set but EscherChildAnchorRecord was not found");
                EscherClientAnchorRecord clrec = (EscherClientAnchorRecord)Shape.getEscherChild(this._escherContainer, -4080);
                anchor = new Rectangle();
                anchor = new Rectangle2D.Float((float)clrec.getCol1() * 72.0f / 576.0f, (float)clrec.getFlag() * 72.0f / 576.0f, (float)(clrec.getDx1() - clrec.getCol1()) * 72.0f / 576.0f, (float)(clrec.getRow1() - clrec.getFlag()) * 72.0f / 576.0f);
            } else {
                anchor = new Rectangle2D.Float((float)rec.getDx1() * 72.0f / 576.0f, (float)rec.getDy1() * 72.0f / 576.0f, (float)(rec.getDx2() - rec.getDx1()) * 72.0f / 576.0f, (float)(rec.getDy2() - rec.getDy1()) * 72.0f / 576.0f);
            }
        } else {
            EscherClientAnchorRecord rec = (EscherClientAnchorRecord)Shape.getEscherChild(this._escherContainer, -4080);
            anchor = new Rectangle();
            anchor = new Rectangle2D.Float((float)rec.getCol1() * 72.0f / 576.0f, (float)rec.getFlag() * 72.0f / 576.0f, (float)(rec.getDx1() - rec.getCol1()) * 72.0f / 576.0f, (float)(rec.getRow1() - rec.getFlag()) * 72.0f / 576.0f);
        }
        return anchor;
    }

    public Rectangle2D getLogicalAnchor2D() {
        return this.getAnchor2D();
    }

    public void setAnchor(Rectangle2D anchor) {
        EscherSpRecord spRecord = (EscherSpRecord)this._escherContainer.getChildById((short)-4086);
        int flags = spRecord.getFlags();
        if ((flags & 2) != 0) {
            EscherChildAnchorRecord rec = (EscherChildAnchorRecord)Shape.getEscherChild(this._escherContainer, -4081);
            rec.setDx1((int)(anchor.getX() * 576.0 / 72.0));
            rec.setDy1((int)(anchor.getY() * 576.0 / 72.0));
            rec.setDx2((int)((anchor.getWidth() + anchor.getX()) * 576.0 / 72.0));
            rec.setDy2((int)((anchor.getHeight() + anchor.getY()) * 576.0 / 72.0));
        } else {
            EscherClientAnchorRecord rec = (EscherClientAnchorRecord)Shape.getEscherChild(this._escherContainer, -4080);
            rec.setFlag((short)(anchor.getY() * 576.0 / 72.0));
            rec.setCol1((short)(anchor.getX() * 576.0 / 72.0));
            rec.setDx1((short)((anchor.getWidth() + anchor.getX()) * 576.0 / 72.0));
            rec.setRow1((short)((anchor.getHeight() + anchor.getY()) * 576.0 / 72.0));
        }
    }

    public void moveTo(float x, float y) {
        Rectangle2D anchor = this.getAnchor2D();
        anchor.setRect(x, y, anchor.getWidth(), anchor.getHeight());
        this.setAnchor(anchor);
    }

    public static EscherRecord getEscherChild(EscherContainerRecord owner, int recordId) {
        Iterator<EscherRecord> iterator = owner.getChildIterator();
        while (iterator.hasNext()) {
            EscherRecord escherRecord = iterator.next();
            if (escherRecord.getRecordId() != recordId) continue;
            return escherRecord;
        }
        return null;
    }

    public static EscherProperty getEscherProperty(EscherOptRecord opt, int propId) {
        if (opt != null) {
            for (EscherProperty prop : opt.getEscherProperties()) {
                if (prop.getPropertyNumber() != propId) continue;
                return prop;
            }
        }
        return null;
    }

    public static void setEscherProperty(EscherOptRecord opt, short propId, int value) {
        List<EscherProperty> props = opt.getEscherProperties();
        Iterator<EscherProperty> iterator = props.iterator();
        while (iterator.hasNext()) {
            EscherProperty prop = iterator.next();
            if (prop.getId() != propId) continue;
            iterator.remove();
        }
        if (value != -1) {
            opt.addEscherProperty(new EscherSimpleProperty(propId, value));
            opt.sortProperties();
        }
    }

    public void setEscherProperty(short propId, int value) {
        EscherOptRecord opt = (EscherOptRecord)Shape.getEscherChild(this._escherContainer, -4085);
        Shape.setEscherProperty(opt, propId, value);
    }

    public int getEscherProperty(short propId) {
        EscherOptRecord opt = (EscherOptRecord)Shape.getEscherChild(this._escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)Shape.getEscherProperty(opt, propId);
        return prop == null ? 0 : prop.getPropertyValue();
    }

    public int getEscherProperty(short propId, int defaultValue) {
        EscherOptRecord opt = (EscherOptRecord)Shape.getEscherChild(this._escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)Shape.getEscherProperty(opt, propId);
        return prop == null ? defaultValue : prop.getPropertyValue();
    }

    public EscherContainerRecord getSpContainer() {
        return this._escherContainer;
    }

    protected void afterInsert(Sheet sh) {
        if (this._fill != null) {
            this._fill.afterInsert(sh);
        }
    }

    public Sheet getSheet() {
        return this._sheet;
    }

    public void setSheet(Sheet sheet) {
        this._sheet = sheet;
    }

    Color getColor(short colorProperty, short opacityProperty, int defaultColor) {
        EscherOptRecord opt = (EscherOptRecord)Shape.getEscherChild(this._escherContainer, -4085);
        EscherSimpleProperty p = (EscherSimpleProperty)Shape.getEscherProperty(opt, colorProperty);
        if (p == null && defaultColor == -1) {
            return null;
        }
        int val = p == null ? defaultColor : p.getPropertyValue();
        int a = val >> 24 & 0xFF;
        int b = val >> 16 & 0xFF;
        int g = val >> 8 & 0xFF;
        int r = val >> 0 & 0xFF;
        boolean fPaletteIndex = (a & 1) != 0;
        boolean fPaletteRGB = (a & 2) != 0;
        boolean fSystemRGB = (a & 4) != 0;
        boolean fSchemeIndex = (a & 8) != 0;
        boolean fSysIndex = (a & 0x10) != 0;
        Sheet sheet = this.getSheet();
        if (fSchemeIndex && sheet != null) {
            ColorSchemeAtom ca = sheet.getColorScheme();
            int schemeColor = ca.getColor(r);
            r = schemeColor >> 0 & 0xFF;
            g = schemeColor >> 8 & 0xFF;
            b = schemeColor >> 16 & 0xFF;
        } else if (fPaletteIndex || fPaletteRGB || fSystemRGB || fSysIndex) {
            // empty if block
        }
        EscherSimpleProperty op = (EscherSimpleProperty)Shape.getEscherProperty(opt, opacityProperty);
        int defaultOpacity = 65536;
        int opacity = op == null ? defaultOpacity : op.getPropertyValue();
        int i = opacity >> 16;
        int f = opacity >> 0 & 0xFFFF;
        double alpha = ((double)i + (double)f / 65536.0) * 255.0;
        return new Color(r, g, b, (int)alpha);
    }

    Color toRGB(int val) {
        int a = val >> 24 & 0xFF;
        int b = val >> 16 & 0xFF;
        int g = val >> 8 & 0xFF;
        int r = val >> 0 & 0xFF;
        if (a != 254 && a != 255) {
            ColorSchemeAtom ca = this.getSheet().getColorScheme();
            int schemeColor = ca.getColor(a);
            r = schemeColor >> 0 & 0xFF;
            g = schemeColor >> 8 & 0xFF;
            b = schemeColor >> 16 & 0xFF;
        }
        return new Color(r, g, b);
    }

    public int getShapeId() {
        EscherSpRecord spRecord = (EscherSpRecord)this._escherContainer.getChildById((short)-4086);
        return spRecord == null ? 0 : spRecord.getShapeId();
    }

    public void setShapeId(int id) {
        EscherSpRecord spRecord = (EscherSpRecord)this._escherContainer.getChildById((short)-4086);
        if (spRecord != null) {
            spRecord.setShapeId(id);
        }
    }

    public Fill getFill() {
        if (this._fill == null) {
            this._fill = new Fill(this);
        }
        return this._fill;
    }

    public Hyperlink getHyperlink() {
        return Hyperlink.find(this);
    }

    public void draw(Graphics2D graphics) {
        this.logger.log(3, "Rendering " + this.getShapeName());
    }

    public java.awt.Shape getOutline() {
        return this.getLogicalAnchor2D();
    }
}

