/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.delegation.client;

import edu.uiuc.ncsa.security.delegation.client.request.AGRequest;
import edu.uiuc.ncsa.security.delegation.client.request.AGResponse;
import edu.uiuc.ncsa.security.delegation.client.request.ATRequest;
import edu.uiuc.ncsa.security.delegation.client.request.ATResponse;
import edu.uiuc.ncsa.security.delegation.client.request.DelegatedAssetRequest;
import edu.uiuc.ncsa.security.delegation.client.request.DelegatedAssetResponse;
import edu.uiuc.ncsa.security.delegation.client.request.DelegationRequest;
import edu.uiuc.ncsa.security.delegation.client.request.DelegationResponse;
import edu.uiuc.ncsa.security.delegation.client.request.PARequest;
import edu.uiuc.ncsa.security.delegation.client.request.PAResponse;
import edu.uiuc.ncsa.security.delegation.client.server.AGServer;
import edu.uiuc.ncsa.security.delegation.client.server.ATServer;
import edu.uiuc.ncsa.security.delegation.client.server.PAServer;
import edu.uiuc.ncsa.security.delegation.services.Request;
import edu.uiuc.ncsa.security.delegation.services.Response;
import edu.uiuc.ncsa.security.delegation.services.Server;
import java.net.URI;

public abstract class DelegationService
implements Server {
    ATServer atServer;
    AGServer agServer;
    PAServer paServer;

    protected DelegationService(AGServer agServer, ATServer atServer, PAServer paServer) {
        this.agServer = agServer;
        this.atServer = atServer;
        this.paServer = paServer;
    }

    public DelegationResponse processDelegationRequest(DelegationRequest delegationRequest) {
        AGRequest agReq = new AGRequest();
        agReq.setClient(delegationRequest.getClient());
        agReq.setParameters(delegationRequest.getParameters());
        AGResponse agResp = (AGResponse)this.getAgServer().process(agReq);
        DelegationResponse delResp = new DelegationResponse(agResp.getAuthorizationGrant());
        delResp.setRedirectUri(this.createRedirectURL(delegationRequest, agResp));
        return delResp;
    }

    protected ATResponse getAT(DelegatedAssetRequest delegationAssetRequest) {
        ATRequest atr = new ATRequest();
        atr.setAuthorizationGrant(delegationAssetRequest.getAuthorizationGrant());
        atr.setClient(delegationAssetRequest.getClient());
        atr.setVerifier(delegationAssetRequest.getVerifier());
        atr.setParameters(delegationAssetRequest.getParameters());
        ATResponse atresp = (ATResponse)this.getAtServer().process(atr);
        return atresp;
    }

    public DelegatedAssetResponse processAssetRequest(DelegatedAssetRequest delegationAssetRequest) {
        ATResponse atResp = this.getAT(delegationAssetRequest);
        PARequest paReq = new PARequest();
        paReq.setClient(delegationAssetRequest.getClient());
        paReq.setAccessToken(atResp.getAccessToken());
        paReq.setParameters(delegationAssetRequest.getAssetParameters());
        PAResponse paResp = (PAResponse)this.getPaServer().process(paReq);
        DelegatedAssetResponse dap = new DelegatedAssetResponse(paResp.getProtectedAsset());
        dap.setAdditionalInformation(paResp.getAdditionalInformation());
        return dap;
    }

    public abstract URI createRedirectURL(DelegationRequest var1, AGResponse var2);

    public Response process(Request request) {
        return request.process((Server)this);
    }

    public ATServer getAtServer() {
        return this.atServer;
    }

    public PAServer getPaServer() {
        return this.paServer;
    }

    public AGServer getAgServer() {
        return this.agServer;
    }
}

