/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.credential.store.notifier;

import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.DBUtil;
import org.apache.airavata.credential.store.credential.CommunityUser;
import org.apache.airavata.credential.store.credential.Credential;
import org.apache.airavata.credential.store.credential.impl.certificate.CertificateCredential;
import org.apache.airavata.credential.store.notifier.CredentialStoreNotifier;
import org.apache.airavata.credential.store.notifier.impl.EmailNotificationMessage;
import org.apache.airavata.credential.store.notifier.impl.EmailNotifier;
import org.apache.airavata.credential.store.notifier.impl.EmailNotifierConfiguration;
import org.apache.airavata.credential.store.store.CredentialStoreException;
import org.apache.airavata.credential.store.store.impl.CredentialReaderImpl;
import org.apache.airavata.credential.store.util.Utility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotifierBootstrap
extends TimerTask {
    private static boolean enabled = false;
    private static String MESSAGE = "Credentials for community user {0} expires at {1}";
    private static String SUBJECT = "Expiring credentials for user {0}";
    private DBUtil dbUtil;
    private long period;
    protected static Logger log = LoggerFactory.getLogger(NotifierBootstrap.class);
    private CredentialStoreNotifier credentialStoreNotifier;

    public NotifierBootstrap(long period, DBUtil db, EmailNotifierConfiguration configuration) {
        this.period = period;
        if (enabled) {
            Timer timer = new Timer();
            timer.scheduleAtFixedRate((TimerTask)this, 0L, period);
        }
        this.dbUtil = db;
        this.credentialStoreNotifier = new EmailNotifier(configuration);
    }

    public long getPeriod() {
        return this.period;
    }

    public void setPeriod(long period) {
        this.period = period;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void setEnabled(boolean enabled) {
        NotifierBootstrap.enabled = enabled;
    }

    @Override
    public void run() {
        if (!enabled) {
            return;
        }
        try {
            CredentialReaderImpl credentialReader = new CredentialReaderImpl(this.dbUtil);
            List<Credential> credentials = credentialReader.getAllCredentials();
            for (Credential credential : credentials) {
                if (!(credential instanceof CertificateCredential)) continue;
                CertificateCredential certificateCredential = (CertificateCredential)credential;
                Date date = Utility.convertStringToDate(certificateCredential.getNotAfter());
                date.setDate(date.getDate() + 1);
                Date currentDate = new Date();
                if (!currentDate.after(date)) continue;
                CommunityUser communityUser = certificateCredential.getCommunityUser();
                String body = String.format(MESSAGE, communityUser.getUserName(), certificateCredential.getNotAfter());
                String subject = String.format(SUBJECT, communityUser.getUserName());
                EmailNotificationMessage notificationMessage = new EmailNotificationMessage(subject, communityUser.getUserEmail(), body);
                this.credentialStoreNotifier.notifyMessage(notificationMessage);
            }
        }
        catch (ApplicationSettingsException e) {
            log.error("Error configuring email senders.", (Throwable)e);
        }
        catch (CredentialStoreException e) {
            log.error("Error sending emails about credential expiring.", (Throwable)e);
        }
        catch (ParseException e) {
            log.error("Error parsing date time when sending emails", (Throwable)e);
        }
    }
}

