/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.List;
import org.apache.airavata.common.utils.AiravataUtils;
import org.apache.airavata.credential.store.store.CredentialStoreException;
import org.apache.airavata.gfac.core.GFacEngine;
import org.apache.airavata.gfac.core.GFacException;
import org.apache.airavata.gfac.core.GFacUtils;
import org.apache.airavata.gfac.core.context.ProcessContext;
import org.apache.airavata.gfac.impl.Factory;
import org.apache.airavata.model.commons.ErrorModel;
import org.apache.airavata.model.status.ProcessState;
import org.apache.airavata.model.status.ProcessStatus;
import org.apache.curator.framework.CuratorFramework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GFacWorker
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(GFacWorker.class);
    private GFacEngine engine;
    private ProcessContext processContext;
    private String processId;
    private String gatewayId;
    private String tokenId;
    private boolean continueTaskFlow = false;

    public GFacWorker(ProcessContext processContext) throws GFacException {
        if (processContext == null) {
            throw new GFacException("Worker must initialize with valid processContext, Process context is null");
        }
        this.processId = processContext.getProcessId();
        this.gatewayId = processContext.getGatewayId();
        this.tokenId = processContext.getTokenId();
        this.engine = Factory.getGFacEngine();
        this.processContext = processContext;
        this.continueTaskFlow = true;
    }

    public GFacWorker(String processId, String gatewayId, String tokenId) throws GFacException, CredentialStoreException {
        this.processId = processId;
        this.gatewayId = gatewayId;
        this.tokenId = tokenId;
        this.engine = Factory.getGFacEngine();
        this.processContext = this.engine.populateProcessContext(processId, gatewayId, tokenId);
        Factory.getGfacContext().addProcess(this.processContext);
    }

    @Override
    public void run() {
        try {
            ProcessState processState = this.processContext.getProcessState();
            switch (processState) {
                case CREATED: 
                case VALIDATED: 
                case STARTED: {
                    this.executeProcess();
                    break;
                }
                case PRE_PROCESSING: 
                case CONFIGURING_WORKSPACE: 
                case INPUT_DATA_STAGING: 
                case EXECUTING: 
                case MONITORING: 
                case OUTPUT_DATA_STAGING: 
                case POST_PROCESSING: {
                    if (this.continueTaskFlow) {
                        this.continueTaskExecution();
                        break;
                    }
                    this.recoverProcess();
                    break;
                }
                case COMPLETED: {
                    this.completeProcess();
                    break;
                }
                case CANCELLING: {
                    this.cancelProcess();
                    break;
                }
                case CANCELED: {
                    break;
                }
                case FAILED: {
                    break;
                }
                default: {
                    throw new GFacException("process Id : " + this.processId + " Couldn't identify process type");
                }
            }
            if (this.processContext.isCancel()) {
                processState = this.processContext.getProcessState();
                switch (processState) {
                    case EXECUTING: 
                    case MONITORING: {
                        break;
                    }
                    case CANCELLING: {
                        this.cancelProcess();
                        break;
                    }
                    default: {
                        this.sendAck();
                        Factory.getGfacContext().removeProcess(this.processContext.getProcessId());
                    }
                }
            }
        }
        catch (GFacException e) {
            log.error("GFac Worker throws an exception", (Throwable)e);
            ProcessStatus status = new ProcessStatus(ProcessState.FAILED);
            status.setReason(e.getMessage());
            status.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
            this.processContext.setProcessStatus(status);
            StringWriter errors = new StringWriter();
            e.printStackTrace(new PrintWriter(errors));
            ErrorModel errorModel = new ErrorModel();
            errorModel.setUserFriendlyMessage("GFac Worker throws an exception");
            errorModel.setActualErrorMessage(errors.toString());
            errorModel.setCreationTime(AiravataUtils.getCurrentTimestamp().getTime());
            try {
                GFacUtils.saveAndPublishProcessStatus((ProcessContext)this.processContext);
                GFacUtils.saveExperimentError((ProcessContext)this.processContext, (ErrorModel)errorModel);
                GFacUtils.saveProcessError((ProcessContext)this.processContext, (ErrorModel)errorModel);
            }
            catch (GFacException e1) {
                log.error("expId: {}, processId: {} :- Couldn't save and publish process status {}", new Object[]{this.processContext.getExperimentId(), this.processContext.getProcessId(), this.processContext.getProcessState()});
            }
            this.sendAck();
        }
    }

    private void cancelProcess() throws GFacException {
        ProcessStatus processStatus = new ProcessStatus(ProcessState.CANCELED);
        processStatus.setReason("Process cancellation has been triggered");
        this.processContext.setProcessStatus(processStatus);
        GFacUtils.saveAndPublishProcessStatus((ProcessContext)this.processContext);
        this.sendAck();
        Factory.getGfacContext().removeProcess(this.processContext.getProcessId());
    }

    private void completeProcess() throws GFacException {
        ProcessStatus status = new ProcessStatus(ProcessState.COMPLETED);
        status.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
        this.processContext.setProcessStatus(status);
        GFacUtils.saveAndPublishProcessStatus((ProcessContext)this.processContext);
        this.sendAck();
        Factory.getGfacContext().removeProcess(this.processContext.getProcessId());
    }

    private void continueTaskExecution() throws GFacException {
        if (this.processContext.isInterrupted()) {
            return;
        }
        this.processContext.setPauseTaskExecution(false);
        List taskExecutionOrder = this.processContext.getTaskExecutionOrder();
        String currentExecutingTaskId = this.processContext.getCurrentExecutingTaskId();
        boolean found = false;
        String nextTaskId = null;
        for (String taskId : taskExecutionOrder) {
            if (!found) {
                if (!taskId.equalsIgnoreCase(currentExecutingTaskId)) continue;
                found = true;
                continue;
            }
            nextTaskId = taskId;
            break;
        }
        if (nextTaskId != null) {
            this.engine.continueProcess(this.processContext, nextTaskId);
        } else {
            this.processContext.setComplete(true);
        }
        if (this.processContext.isInterrupted()) {
            return;
        }
        if (this.processContext.isComplete()) {
            this.completeProcess();
        }
    }

    private void recoverProcess() throws GFacException {
        this.engine.recoverProcess(this.processContext);
        if (this.processContext.isInterrupted()) {
            return;
        }
        if (this.processContext.isComplete()) {
            this.completeProcess();
        }
    }

    private void executeProcess() throws GFacException {
        if (this.processContext.isInterrupted()) {
            return;
        }
        this.engine.executeProcess(this.processContext);
        if (this.processContext.isInterrupted()) {
            return;
        }
        if (this.processContext.isComplete()) {
            this.completeProcess();
        }
    }

    private void sendAck() {
        if (!this.processContext.isAcknowledge()) {
            try {
                long processDeliveryTag = GFacUtils.getProcessDeliveryTag((CuratorFramework)this.processContext.getCuratorClient(), (String)this.processContext.getExperimentId(), (String)this.processId);
                Factory.getProcessLaunchSubscriber().sendAck(processDeliveryTag);
                this.processContext.setAcknowledge(true);
                log.info("expId: {}, processId: {} :- Sent ack for deliveryTag {}", new Object[]{this.processContext.getExperimentId(), this.processId, processDeliveryTag});
            }
            catch (Exception e1) {
                this.processContext.setAcknowledge(false);
                String format = MessageFormat.format("expId: {0}, processId: {1} :- Couldn't send ack for deliveryTag ", this.processContext.getExperimentId(), this.processId);
                log.error(format, (Throwable)e1);
            }
        } else {
            log.info("expId: {}, processId: {} :- already acknowledged ", (Object)this.processContext.getExperimentId(), (Object)this.processId);
        }
    }
}

