/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.config;

import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.user.api.Property;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.api.UserStoreException;

public class XMLProcessorUtils {
    private static final Log log = LogFactory.getLog(XMLProcessorUtils.class);

    public ArrayList<String> getDomainNames() throws UserStoreException {
        ArrayList<String> domains = new ArrayList<String>();
        RealmConfiguration realmConfiguration = CarbonContext.getThreadLocalCarbonContext().getUserRealm().getRealmConfiguration();
        String domain = realmConfiguration.getUserStoreProperty("DomainName");
        if (domain == null) {
            domain = "PRIMARY";
        }
        domains.add(domain);
        for (RealmConfiguration secondaryRealmConfiguration = realmConfiguration.getSecondaryRealmConfig(); secondaryRealmConfiguration != null; secondaryRealmConfiguration = secondaryRealmConfiguration.getSecondaryRealmConfig()) {
            domains.add(secondaryRealmConfiguration.getUserStoreProperty("DomainName"));
        }
        return domains;
    }

    public boolean isValidDomain(String domainName, Boolean isAdd) throws UserStoreException {
        if (domainName == null || "".equals(domainName)) {
            String msg = "User store domain name should not be empty.";
            throw new UserStoreException(msg);
        }
        if (domainName.contains("_")) {
            String msg = "User store domain name should not contain \"_\".";
            throw new UserStoreException(msg);
        }
        if (isAdd.booleanValue()) {
            if (this.getDomainNames().contains(domainName)) {
                String msg = "Cannot add user store. Domain name already exists.";
                throw new UserStoreException(msg);
            }
        } else if (!this.getDomainNames().contains(domainName)) {
            String msg = "Cannot edit user store, cannot find the domain name " + domainName;
            throw new UserStoreException(msg);
        }
        return true;
    }

    public boolean isMandatoryFieldsProvided(Map<String, String> definedProperties, Property[] mandatories) throws UserStoreException {
        for (int j = 0; j < mandatories.length; ++j) {
            if (definedProperties.containsKey(mandatories[j].getName())) continue;
            log.error((Object)("Required mandatory property " + mandatories[j].getName() + " is not defined!"));
            return false;
        }
        return true;
    }
}

