/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.registries;

import java.util.Map;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.schema.SchemaObjectType;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.ldap.model.schema.registries.DefaultSchemaObjectRegistry;
import org.apache.directory.api.ldap.model.schema.registries.OidRegistry;
import org.apache.directory.api.ldap.model.schema.registries.SyntaxCheckerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSyntaxCheckerRegistry
extends DefaultSchemaObjectRegistry<SyntaxChecker>
implements SyntaxCheckerRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSyntaxCheckerRegistry.class);
    private static final boolean DEBUG = LOG.isDebugEnabled();

    public DefaultSyntaxCheckerRegistry() {
        super(SchemaObjectType.SYNTAX_CHECKER, new OidRegistry());
    }

    @Override
    public void unregisterSchemaElements(String schemaName) throws LdapException {
        if (schemaName == null) {
            return;
        }
        for (SyntaxChecker syntaxChecker : this) {
            if (!schemaName.equalsIgnoreCase(syntaxChecker.getSchemaName())) continue;
            String oid = syntaxChecker.getOid();
            String removed = this.unregister(oid);
            if (!DEBUG) continue;
            LOG.debug("Removed {} with oid {} from the registry", (Object)removed, (Object)oid);
        }
    }

    @Override
    public DefaultSyntaxCheckerRegistry copy() {
        DefaultSyntaxCheckerRegistry copy = new DefaultSyntaxCheckerRegistry();
        copy.copy(this);
        return copy;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.schemaObjectType).append(": ");
        boolean isFirst = true;
        for (Map.Entry entry : this.byName.entrySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            SyntaxChecker syntaxChecker = (SyntaxChecker)entry.getValue();
            String fqcn = syntaxChecker.getFqcn();
            int lastDotPos = fqcn.lastIndexOf(46);
            sb.append('<').append(syntaxChecker.getOid()).append(", ");
            if (lastDotPos > 0) {
                sb.append(fqcn.substring(lastDotPos + 1));
            } else {
                sb.append(fqcn);
            }
            sb.append('>');
        }
        return sb.toString();
    }
}

