/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.standalone;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.apache.directory.api.ldap.codec.api.ControlFactory;
import org.apache.directory.api.ldap.codec.api.ExtendedOperationFactory;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.osgi.DefaultLdapCodecService;
import org.apache.directory.api.ldap.codec.standalone.CodecFactoryUtil;
import org.apache.directory.api.util.Strings;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneLdapApiService
extends DefaultLdapCodecService {
    private static final Logger LOG = LoggerFactory.getLogger(StandaloneLdapApiService.class);
    public static final String CONTROLS_LIST = "apacheds.controls";
    public static final String EXTENDED_OPERATIONS_LIST = "apacheds.extendedOperations";
    private static final String OLD_DEFAULT_CONTROLS_LIST = "default.controls";
    private static final String OLD_EXTRA_EXTENDED_OPERATION_LIST = "extra.extendedOperations";

    public StandaloneLdapApiService() throws Exception {
        this(StandaloneLdapApiService.getControlsFromSystemProperties(), StandaloneLdapApiService.getExtendedOperationsFromSystemProperties());
    }

    public StandaloneLdapApiService(List<String> controls, List<String> extendedOperations) throws Exception {
        CodecFactoryUtil.loadStockControls(this.getControlFactories(), this);
        CodecFactoryUtil.loadStockExtendedOperations(this.getExtendedOperationsFactories(), this);
        this.loadControls(controls);
        this.loadExtendedOperations(extendedOperations);
        if (this.getProtocolCodecFactory() == null) {
            try {
                Class<?> clazz = Class.forName("org.apache.directory.api.ldap.codec.protocol.mina.LdapProtocolCodecFactory");
                Constructor<?> constructor = clazz.getConstructor(LdapApiService.class);
                if (constructor != null) {
                    this.setProtocolCodecFactory((ProtocolCodecFactory)constructor.newInstance(this));
                } else {
                    this.setProtocolCodecFactory((ProtocolCodecFactory)clazz.newInstance());
                }
            }
            catch (Exception cause) {
                throw new RuntimeException("Failed to load default codec factory.", cause);
            }
        }
    }

    private static List<String> getControlsFromSystemProperties() throws Exception {
        ArrayList<String> controlsList;
        block3: {
            block2: {
                controlsList = new ArrayList<String>();
                String controlsString = System.getProperty(CONTROLS_LIST);
                if (Strings.isEmpty(controlsString)) break block2;
                for (String control : controlsString.split(",")) {
                    controlsList.add(control);
                }
                break block3;
            }
            String oldDefaultControlsString = System.getProperty(OLD_DEFAULT_CONTROLS_LIST);
            if (Strings.isEmpty(oldDefaultControlsString)) break block3;
            for (String control : oldDefaultControlsString.split(",")) {
                controlsList.add(control);
            }
        }
        return controlsList;
    }

    private static List<String> getExtendedOperationsFromSystemProperties() throws Exception {
        ArrayList<String> extendedOperationsList;
        block3: {
            block2: {
                extendedOperationsList = new ArrayList<String>();
                String defaultExtendedOperationsList = System.getProperty(EXTENDED_OPERATIONS_LIST);
                if (Strings.isEmpty(defaultExtendedOperationsList)) break block2;
                for (String extendedOperation : defaultExtendedOperationsList.split(",")) {
                    extendedOperationsList.add(extendedOperation);
                }
                break block3;
            }
            String oldDefaultControlsString = System.getProperty(OLD_EXTRA_EXTENDED_OPERATION_LIST);
            if (Strings.isEmpty(oldDefaultControlsString)) break block3;
            for (String extendedOperation : oldDefaultControlsString.split(",")) {
                extendedOperationsList.add(extendedOperation);
            }
        }
        return extendedOperationsList;
    }

    private void loadControls(List<String> controlsList) throws Exception {
        if (!controlsList.isEmpty()) {
            for (String controlFQCN : controlsList) {
                this.loadControl(controlFQCN);
            }
        }
    }

    private void loadControl(String controlFQCN) throws Exception {
        if (this.getControlFactories().containsKey(controlFQCN)) {
            LOG.debug("Factory for control {} was already loaded", (Object)controlFQCN);
            return;
        }
        Class[] types = new Class[]{LdapApiService.class};
        Class<?> clazz = Class.forName(controlFQCN.trim());
        Constructor<?> constructor = clazz.getConstructor(types);
        ControlFactory factory = (ControlFactory)constructor.newInstance(this);
        this.getControlFactories().put(factory.getOid(), factory);
        LOG.info("Registered control factory: {}", (Object)factory.getOid());
    }

    private void loadExtendedOperations(List<String> extendedOperationsList) throws Exception {
        if (!extendedOperationsList.isEmpty()) {
            for (String extendedOperationFQCN : extendedOperationsList) {
                this.loadExtendedOperation(extendedOperationFQCN);
            }
        }
    }

    private void loadExtendedOperation(String extendedOperationFQCN) throws Exception {
        if (this.getExtendedOperationsFactories().containsKey(extendedOperationFQCN)) {
            LOG.debug("Factory for extended operation {} was already loaded", (Object)extendedOperationFQCN);
            return;
        }
        Class[] types = new Class[]{LdapApiService.class};
        Class<?> clazz = Class.forName(extendedOperationFQCN.trim());
        Constructor<?> constructor = clazz.getConstructor(types);
        ExtendedOperationFactory factory = (ExtendedOperationFactory)constructor.newInstance(this);
        this.getExtendedOperationsFactories().put(factory.getOid(), factory);
        LOG.info("Registered pre-bundled extended operation factory: {}", (Object)factory.getOid());
    }
}

