/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model.transform;

import com.amazonaws.services.elasticloadbalancing.model.ConnectionSettings;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class ConnectionSettingsStaxUnmarshaller
implements Unmarshaller<ConnectionSettings, StaxUnmarshallerContext> {
    private static ConnectionSettingsStaxUnmarshaller instance;

    public ConnectionSettings unmarshall(StaxUnmarshallerContext context) throws Exception {
        ConnectionSettings connectionSettings = new ConnectionSettings();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return connectionSettings;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (!context.testExpression("IdleTimeout", targetDepth)) continue;
                connectionSettings.setIdleTimeout(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return connectionSettings;
    }

    public static ConnectionSettingsStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ConnectionSettingsStaxUnmarshaller();
        }
        return instance;
    }
}

