/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.operations;

import com.hazelcast.collection.CollectionProxyId;
import com.hazelcast.collection.CollectionRecord;
import com.hazelcast.collection.operations.CollectionKeyBasedOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AddAllBackupOperation
extends CollectionKeyBasedOperation
implements BackupOperation {
    Collection<CollectionRecord> recordList;
    int index;

    public AddAllBackupOperation() {
    }

    public AddAllBackupOperation(CollectionProxyId proxyId, Data dataKey, Collection<CollectionRecord> recordList, int index) {
        super(proxyId, dataKey);
        this.recordList = recordList;
        this.index = index;
    }

    @Override
    public void run() throws Exception {
        Collection<CollectionRecord> coll = this.getOrCreateCollectionWrapper().getCollection();
        if (this.index == -1) {
            this.response = coll.addAll(this.recordList);
        } else {
            List list = (List)coll;
            try {
                this.response = list.addAll(this.index, this.recordList);
            }
            catch (IndexOutOfBoundsException e) {
                this.response = e;
            }
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.index);
        out.writeInt(this.recordList.size());
        for (CollectionRecord record : this.recordList) {
            record.writeData(out);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.index = in.readInt();
        int size = in.readInt();
        this.recordList = new ArrayList<CollectionRecord>(size);
        for (int i = 0; i < size; ++i) {
            CollectionRecord rec = new CollectionRecord();
            rec.readData(in);
            this.recordList.add(rec);
        }
    }

    @Override
    public int getId() {
        return 0;
    }
}

