/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.sharing.registry.db.repositories;

import java.util.HashMap;
import java.util.List;
import org.apache.airavata.sharing.registry.db.entities.PermissionTypeEntity;
import org.apache.airavata.sharing.registry.db.entities.PermissionTypePK;
import org.apache.airavata.sharing.registry.db.repositories.AbstractRepository;
import org.apache.airavata.sharing.registry.models.PermissionType;
import org.apache.airavata.sharing.registry.models.SharingRegistryException;
import org.apache.airavata.sharing.registry.server.SharingRegistryServerHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PermissionTypeRepository
extends AbstractRepository<PermissionType, PermissionTypeEntity, PermissionTypePK> {
    private static final Logger logger = LoggerFactory.getLogger(PermissionTypeRepository.class);

    public PermissionTypeRepository() {
        super(PermissionType.class, PermissionTypeEntity.class);
    }

    public String getOwnerPermissionTypeIdForDomain(String domainId) throws SharingRegistryException {
        HashMap<String, String> filters = new HashMap<String, String>();
        filters.put("domainId", domainId);
        filters.put("name", SharingRegistryServerHandler.OWNER_PERMISSION_NAME);
        List permissionTypeList = this.select(filters, 0, -1);
        if (permissionTypeList.size() != 1) {
            throw new SharingRegistryException("GLOBAL Permission inconsistency. Found " + permissionTypeList.size() + " records with " + SharingRegistryServerHandler.OWNER_PERMISSION_NAME + " name");
        }
        return ((PermissionType)permissionTypeList.get(0)).getPermissionTypeId();
    }
}

