/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.replica.catalog.utils;

import java.util.HashMap;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.ServerSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicaCatalogJPAUtils {
    private static final Logger logger = LoggerFactory.getLogger(ReplicaCatalogJPAUtils.class);
    private static final String PERSISTENCE_UNIT_NAME = "replicacatalog_data";
    private static final String REPLICACATALOG_JDBC_DRIVER = "replicacatalog.jdbc.driver";
    private static final String REPLICACATALOG_JDBC_URL = "replicacatalog.jdbc.url";
    private static final String REPLICACATALOG_JDBC_USER = "replicacatalog.jdbc.user";
    private static final String REPLICACATALOG_JDBC_PWD = "replicacatalog.jdbc.password";
    private static final String REPLICACATALOG_VALIDATION_QUERY = "replicacatalog.validationQuery";
    @PersistenceUnit(unitName="replicacatalog_data")
    protected static EntityManagerFactory factory;
    @PersistenceContext(unitName="replicacatalog_data")
    private static EntityManager dataCatEntityManager;

    public static EntityManager getEntityManager() throws ApplicationSettingsException {
        if (factory == null) {
            String connectionProperties = "DriverClassName=" + ReplicaCatalogJPAUtils.readServerProperties(REPLICACATALOG_JDBC_DRIVER) + ",Url=" + ReplicaCatalogJPAUtils.readServerProperties(REPLICACATALOG_JDBC_URL) + "?autoReconnect=true,Username=" + ReplicaCatalogJPAUtils.readServerProperties(REPLICACATALOG_JDBC_USER) + ",Password=" + ReplicaCatalogJPAUtils.readServerProperties(REPLICACATALOG_JDBC_PWD) + ",validationQuery=" + ReplicaCatalogJPAUtils.readServerProperties(REPLICACATALOG_VALIDATION_QUERY);
            System.out.println(connectionProperties);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("openjpa.ConnectionDriverName", "org.apache.commons.dbcp.BasicDataSource");
            properties.put("openjpa.ConnectionProperties", connectionProperties);
            properties.put("openjpa.DynamicEnhancementAgent", "true");
            properties.put("openjpa.RuntimeUnenhancedClasses", "unsupported");
            properties.put("openjpa.RemoteCommitProvider", "sjvm");
            properties.put("openjpa.Log", "DefaultLevel=INFO, Runtime=INFO, Tool=INFO, SQL=INFO");
            properties.put("openjpa.jdbc.SynchronizeMappings", "buildSchema(ForeignKeys=true)");
            properties.put("openjpa.jdbc.QuerySQLCache", "false");
            properties.put("openjpa.ConnectionFactoryProperties", "PrettyPrint=true, PrettyPrintLineLength=72, PrintParameters=true, MaxActive=10, MaxIdle=5, MinIdle=2, MaxWait=31536000,  autoReconnect=true");
            factory = Persistence.createEntityManagerFactory((String)PERSISTENCE_UNIT_NAME, properties);
        }
        dataCatEntityManager = factory.createEntityManager();
        return dataCatEntityManager;
    }

    private static String readServerProperties(String propertyName) throws ApplicationSettingsException {
        try {
            return ServerSettings.getSetting((String)propertyName);
        }
        catch (ApplicationSettingsException e) {
            logger.error("Unable to read airavata-server.properties...", (Throwable)e);
            throw new ApplicationSettingsException("Unable to read airavata-server.properties...");
        }
    }
}

