/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.app.catalog.resources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.registry.core.app.catalog.model.AppModuleMapping;
import org.apache.airavata.registry.core.app.catalog.model.AppModuleMapping_PK;
import org.apache.airavata.registry.core.app.catalog.model.ApplicationInterface;
import org.apache.airavata.registry.core.app.catalog.model.ApplicationModule;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatAbstractResource;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatalogResource;
import org.apache.airavata.registry.core.app.catalog.resources.AppInterfaceResource;
import org.apache.airavata.registry.core.app.catalog.resources.AppModuleResource;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogJPAUtils;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogQueryGenerator;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogResourceType;
import org.apache.airavata.registry.cpi.AppCatalogException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppModuleMappingAppCatalogResourceAppCat
extends AppCatAbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(AppModuleMappingAppCatalogResourceAppCat.class);
    private String interfaceId;
    private String moduleId;
    private AppInterfaceResource appInterfaceResource;
    private AppModuleResource moduleResource;

    public String getModuleId() {
        return this.moduleId;
    }

    public void setModuleId(String moduleId) {
        this.moduleId = moduleId;
    }

    public String getInterfaceId() {
        return this.interfaceId;
    }

    public void setInterfaceId(String interfaceId) {
        this.interfaceId = interfaceId;
    }

    public AppInterfaceResource getAppInterfaceResource() {
        return this.appInterfaceResource;
    }

    public void setAppInterfaceResource(AppInterfaceResource appInterfaceResource) {
        this.appInterfaceResource = appInterfaceResource;
    }

    public AppModuleResource getModuleResource() {
        return this.moduleResource;
    }

    public void setModuleResource(AppModuleResource moduleResource) {
        this.moduleResource = moduleResource;
    }

    @Override
    public void remove(Object identifier) throws AppCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new AppCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("AppModuleMapping", new Object[0][]);
            generator.setParameter("interfaceID", ids.get("interfaceID"));
            if (ids.get("moduleID") != null) {
                generator.setParameter("moduleID", ids.get("moduleID"));
            }
            Query q = generator.deleteQuery(em);
            q.executeUpdate();
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public void removeAll() throws AppCatalogException {
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("AppModuleMapping", new Object[0][]);
            Query q = generator.deleteQuery(em);
            q.executeUpdate();
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public AppCatalogResource get(Object identifier) throws AppCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new AppCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("AppModuleMapping", new Object[0][]);
            generator.setParameter("interfaceID", ids.get("interfaceID"));
            generator.setParameter("moduleID", ids.get("moduleID"));
            Query q = generator.selectQuery(em);
            AppModuleMapping result = (AppModuleMapping)q.getSingleResult();
            AppModuleMappingAppCatalogResourceAppCat resource = (AppModuleMappingAppCatalogResourceAppCat)AppCatalogJPAUtils.getResource(AppCatalogResourceType.APP_MODULE_MAPPING, result);
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            AppModuleMappingAppCatalogResourceAppCat appModuleMappingAppCatalogResourceAppCat = resource;
            return appModuleMappingAppCatalogResourceAppCat;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public List<AppCatalogResource> get(String fieldName, Object value) throws AppCatalogException {
        ArrayList<AppCatalogResource> resourceList = new ArrayList<AppCatalogResource>();
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("AppModuleMapping", new Object[0][]);
            if (fieldName.equals("interfaceID")) {
                generator.setParameter("interfaceID", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        AppModuleMapping moduleMapping = (AppModuleMapping)result;
                        AppModuleMappingAppCatalogResourceAppCat resource = (AppModuleMappingAppCatalogResourceAppCat)AppCatalogJPAUtils.getResource(AppCatalogResourceType.APP_MODULE_MAPPING, moduleMapping);
                        resourceList.add(resource);
                    }
                }
            } else if (fieldName.equals("moduleID")) {
                generator.setParameter("moduleID", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        AppModuleMapping moduleMapping = (AppModuleMapping)result;
                        AppModuleMappingAppCatalogResourceAppCat resource = (AppModuleMappingAppCatalogResourceAppCat)AppCatalogJPAUtils.getResource(AppCatalogResourceType.APP_MODULE_MAPPING, moduleMapping);
                        resourceList.add(resource);
                    }
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for app module mapping resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for app module mapping resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return resourceList;
    }

    @Override
    public List<AppCatalogResource> getAll() throws AppCatalogException {
        return null;
    }

    @Override
    public List<String> getAllIds() throws AppCatalogException {
        return null;
    }

    @Override
    public List<String> getIds(String fieldName, Object value) throws AppCatalogException {
        logger.error("Unsupported for objects with a composite identifier");
        throw new AppCatalogException("Unsupported for objects with a composite identifier");
    }

    @Override
    public void save() throws AppCatalogException {
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            AppModuleMapping existngModuleMap = (AppModuleMapping)em.find(AppModuleMapping.class, (Object)new AppModuleMapping_PK(this.interfaceId, this.moduleId));
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            ApplicationInterface applicationInterface = (ApplicationInterface)em.find(ApplicationInterface.class, (Object)this.interfaceId);
            ApplicationModule applicationModule = (ApplicationModule)em.find(ApplicationModule.class, (Object)this.moduleId);
            if (existngModuleMap != null) {
                existngModuleMap.setApplicationInterface(applicationInterface);
                existngModuleMap.setApplicationModule(applicationModule);
                em.merge((Object)existngModuleMap);
            } else {
                AppModuleMapping appModuleMapping = new AppModuleMapping();
                appModuleMapping.setInterfaceID(this.interfaceId);
                appModuleMapping.setApplicationInterface(applicationInterface);
                appModuleMapping.setModuleID(this.moduleId);
                appModuleMapping.setApplicationModule(applicationModule);
                em.persist((Object)appModuleMapping);
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public boolean isExists(Object identifier) throws AppCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new AppCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            AppModuleMapping moduleMapping = (AppModuleMapping)em.find(AppModuleMapping.class, (Object)new AppModuleMapping_PK((String)ids.get("interfaceID"), (String)ids.get("moduleID")));
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            boolean bl = moduleMapping != null;
            return bl;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }
}

