/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.java2wsdl.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.axis2.description.java2wsdl.Java2WSDLConstants;
import org.apache.ws.java2wsdl.utils.Java2WSDLCommandLineOption;
import org.apache.ws.java2wsdl.utils.Java2WSDLOptionsValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Java2WSDLCommandLineOptionParser
implements Java2WSDLConstants {
    private static int STARTED = 0;
    private static int NEW_OPTION = 1;
    private static int SUB_PARAM_OF_OPTION = 2;
    private Map<String, Java2WSDLCommandLineOption> commandLineOptions;

    public Java2WSDLCommandLineOptionParser(Map<String, Java2WSDLCommandLineOption> commandLineOptions) {
        this.commandLineOptions = commandLineOptions;
    }

    public Java2WSDLCommandLineOptionParser(String[] args) {
        this.commandLineOptions = this.parse(args);
    }

    private Map<String, Java2WSDLCommandLineOption> parse(String[] args) {
        Java2WSDLCommandLineOption commandLineOption;
        HashMap<String, Java2WSDLCommandLineOption> commandLineOptions = new HashMap<String, Java2WSDLCommandLineOption>();
        if (0 == args.length) {
            return commandLineOptions;
        }
        int state = STARTED;
        ArrayList<String> optionBundle = null;
        String optionType = null;
        for (String arg : args) {
            if (arg.startsWith("-")) {
                if (STARTED == state) {
                    state = NEW_OPTION;
                    optionType = arg;
                    continue;
                }
                if (SUB_PARAM_OF_OPTION != state && NEW_OPTION != state) continue;
                commandLineOption = new Java2WSDLCommandLineOption(optionType, optionBundle);
                commandLineOptions.put(commandLineOption.getOptionType(), commandLineOption);
                state = NEW_OPTION;
                optionType = arg;
                optionBundle = null;
                continue;
            }
            if (STARTED == state) {
                commandLineOption = new Java2WSDLCommandLineOption("SOLE_INPUT", args);
                commandLineOptions.put(commandLineOption.getOptionType(), commandLineOption);
                return commandLineOptions;
            }
            if (NEW_OPTION == state) {
                Java2WSDLCommandLineOption old = (Java2WSDLCommandLineOption)commandLineOptions.get(this.getOptionType(optionType));
                if (old != null) {
                    old.getOptionValues().add(arg);
                    optionBundle = null;
                    state = STARTED;
                    continue;
                }
                optionBundle = new ArrayList<String>();
                optionBundle.add(arg);
                state = SUB_PARAM_OF_OPTION;
                continue;
            }
            if (SUB_PARAM_OF_OPTION != state) continue;
            optionBundle.add(arg);
        }
        if (state != STARTED) {
            commandLineOption = new Java2WSDLCommandLineOption(optionType, optionBundle);
            commandLineOptions.put(commandLineOption.getOptionType(), commandLineOption);
        }
        return commandLineOptions;
    }

    private String getOptionType(String type) {
        if (type.startsWith("--")) {
            type = type.replaceFirst("--", "");
        }
        if (type.startsWith("-")) {
            type = type.replaceFirst("-", "");
        }
        return type;
    }

    public Map<String, Java2WSDLCommandLineOption> getAllOptions() {
        return this.commandLineOptions;
    }

    public List<Java2WSDLCommandLineOption> getInvalidOptions(Java2WSDLOptionsValidator validator) {
        ArrayList<Java2WSDLCommandLineOption> faultList = new ArrayList<Java2WSDLCommandLineOption>();
        for (Java2WSDLCommandLineOption commandLineOption : this.commandLineOptions.values()) {
            if (!validator.isInvalid(commandLineOption)) continue;
            faultList.add(commandLineOption);
        }
        return faultList;
    }
}

