/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisBindingOperation;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.dispatchers.HTTPLocationBasedDispatcher;
import org.apache.axis2.dispatchers.RequestURIBasedDispatcher;
import org.apache.axis2.dispatchers.RequestURIOperationDispatcher;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.http.HTTPTransportUtils;

public class RESTUtil {
    public static Handler.InvocationResponse processXMLRequest(MessageContext msgContext, InputStream in, OutputStream out, String contentType) throws AxisFault {
        try {
            msgContext.setDoingREST(true);
            String charSetEncoding = BuilderUtil.getCharSetEncoding(contentType);
            msgContext.setProperty("CHARACTER_SET_ENCODING", charSetEncoding);
            RESTUtil.dispatchAndVerify(msgContext);
            in = HTTPTransportUtils.handleGZip(msgContext, in);
            SOAPEnvelope soapEnvelope = msgContext.getAxisService() == null ? TransportUtils.createSOAPEnvelope(null) : TransportUtils.createSOAPMessage(msgContext, in, contentType);
            msgContext.setEnvelope(soapEnvelope);
            msgContext.setProperty("ContentType", contentType);
            msgContext.setProperty("TRANSPORT_OUT", out);
        }
        catch (AxisFault axisFault) {
            throw axisFault;
        }
        catch (XMLStreamException e) {
            throw AxisFault.makeFault(e);
        }
        catch (IOException e) {
            throw AxisFault.makeFault(e);
        }
        finally {
            String messageType = (String)msgContext.getProperty("messageType");
            if ("application/x-www-form-urlencoded".equals(messageType) || "multipart/form-data".equals(messageType)) {
                msgContext.setProperty("messageType", "application/xml");
            }
        }
        return RESTUtil.invokeAxisEngine(msgContext);
    }

    public static Handler.InvocationResponse processURLRequest(MessageContext msgContext, OutputStream out, String contentType) throws AxisFault {
        try {
            SOAPEnvelope soapEnvelope;
            if (contentType == null || "".equals(contentType)) {
                contentType = "application/x-www-form-urlencoded";
            }
            msgContext.setDoingREST(true);
            msgContext.setProperty("TRANSPORT_OUT", out);
            String charSetEncoding = BuilderUtil.getCharSetEncoding(contentType);
            msgContext.setProperty("CHARACTER_SET_ENCODING", charSetEncoding);
            RESTUtil.dispatchAndVerify(msgContext);
            if (msgContext.getAxisService() == null) {
                soapEnvelope = TransportUtils.createSOAPEnvelope(null);
                msgContext.setProperty("messageType", TransportUtils.getContentType(contentType, msgContext));
            } else {
                try {
                    soapEnvelope = TransportUtils.createSOAPMessage(msgContext, null, contentType);
                }
                catch (XMLStreamException e) {
                    throw AxisFault.makeFault(e);
                }
            }
            msgContext.setEnvelope(soapEnvelope);
        }
        catch (AxisFault axisFault) {
            throw axisFault;
        }
        catch (IOException e) {
            throw AxisFault.makeFault(e);
        }
        finally {
            String messageType = (String)msgContext.getProperty("messageType");
            if ("application/x-www-form-urlencoded".equals(messageType) || "multipart/form-data".equals(messageType)) {
                msgContext.setProperty("messageType", "application/xml");
            }
        }
        return RESTUtil.invokeAxisEngine(msgContext);
    }

    private static Handler.InvocationResponse invokeAxisEngine(MessageContext messageContext) throws AxisFault {
        return AxisEngine.receive(messageContext);
    }

    private static void dispatchAndVerify(MessageContext msgContext) throws AxisFault {
        RequestURIBasedDispatcher requestDispatcher = new RequestURIBasedDispatcher();
        requestDispatcher.invoke(msgContext);
        AxisService axisService = msgContext.getAxisService();
        if (axisService != null) {
            AxisOperation axisOperation;
            HTTPLocationBasedDispatcher httpLocationBasedDispatcher = new HTTPLocationBasedDispatcher();
            httpLocationBasedDispatcher.invoke(msgContext);
            if (msgContext.getAxisOperation() == null) {
                RequestURIOperationDispatcher requestURIOperationDispatcher = new RequestURIOperationDispatcher();
                requestURIOperationDispatcher.invoke(msgContext);
            }
            if ((axisOperation = msgContext.getAxisOperation()) != null) {
                AxisEndpoint axisEndpoint = (AxisEndpoint)msgContext.getProperty("endpoint");
                if (axisEndpoint != null) {
                    AxisBindingOperation axisBindingOperation = (AxisBindingOperation)axisEndpoint.getBinding().getChild(axisOperation.getName());
                    msgContext.setProperty("AxisBindingOperation", axisBindingOperation);
                }
                msgContext.setAxisOperation(axisOperation);
            }
        }
    }
}

