/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.transaction;

import javax.transaction.Transaction;
import javax.transaction.UserTransaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.engine.SearchEngine;
import org.compass.core.spi.InternalCompassSession;
import org.compass.core.transaction.AbstractJTATransaction;
import org.compass.core.transaction.TransactionFactory;

public class XATransaction
extends AbstractJTATransaction {
    public XATransaction(UserTransaction ut, TransactionFactory transactionFactory) {
        super(ut, transactionFactory);
    }

    protected void doBindToTransaction(Transaction tx, InternalCompassSession session, boolean newTransaction) throws Exception {
        tx.enlistResource((XAResource)new CompassXAResource(session));
    }

    private static class CompassXAResource
    implements XAResource {
        private static final Log log = LogFactory.getLog(CompassXAResource.class);
        private InternalCompassSession session;
        private SearchEngine searchEngine;

        public CompassXAResource(InternalCompassSession session) {
            this.session = session;
            this.searchEngine = session.getSearchEngine();
        }

        public int getTransactionTimeout() throws XAException {
            return 0;
        }

        public boolean setTransactionTimeout(int i) throws XAException {
            return false;
        }

        public boolean isSameRM(XAResource xares) throws XAException {
            return xares != null && xares instanceof CompassXAResource && this.session == ((CompassXAResource)xares).session;
        }

        public Xid[] recover(int i) throws XAException {
            return null;
        }

        public void forget(Xid xid) throws XAException {
            this.session.close();
        }

        public void start(Xid xid, int flags) throws XAException {
            switch (flags) {
                default: 
            }
        }

        public void end(Xid xid, int flags) throws XAException {
            switch (flags) {
                case 0x2000000: {
                    break;
                }
                case 0x20000000: {
                    break;
                }
            }
        }

        public int prepare(Xid xid) throws XAException {
            try {
                this.searchEngine.prepare();
            }
            catch (Exception e) {
                log.error((Object)("Failed to prepare transaction [" + xid + "]"), (Throwable)e);
                throw new XAException(e.getMessage());
            }
            if (this.searchEngine.isReadOnly()) {
                this.commit(xid, false);
                return 3;
            }
            return 0;
        }

        public void commit(Xid xid, boolean onePhase) throws XAException {
            if (this.searchEngine.wasRolledBack()) {
                throw new XAException(100);
            }
            try {
                this.searchEngine.commit(onePhase);
            }
            catch (Exception e) {
                log.error((Object)("Failed to commit transaction [" + xid + "]"), (Throwable)e);
                throw new XAException(e.getMessage());
            }
        }

        public void rollback(Xid xid) throws XAException {
            try {
                this.searchEngine.rollback();
            }
            catch (Exception e) {
                log.error((Object)("Failed to rollback transaction [" + xid + "]"), (Throwable)e);
                throw new XAException(e.getMessage());
            }
        }
    }
}

