/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.extended;

import org.compass.core.Property;
import org.compass.core.Resource;
import org.compass.core.ResourceFactory;
import org.compass.core.converter.ConversionException;
import org.compass.core.converter.Converter;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.ResourcePropertyMapping;
import org.compass.core.marshall.MarshallingContext;

public class ObjectByteArrayConverter
implements Converter {
    public boolean marshall(Resource resource, Object root, Mapping mapping, MarshallingContext context) throws ConversionException {
        ResourcePropertyMapping resourcePropertyMapping = (ResourcePropertyMapping)mapping;
        ResourceFactory resourceFactory = context.getResourceFactory();
        if (root == null && !this.handleNulls(context)) {
            return false;
        }
        String propertyName = resourcePropertyMapping.getPath().getPath();
        Byte[] oValue = (Byte[])root;
        byte[] value = new byte[oValue.length];
        for (int i = 0; i < oValue.length; ++i) {
            value[i] = oValue[i];
        }
        Property p = resourceFactory.createProperty(propertyName, value, resourcePropertyMapping.getStore());
        p.setBoost(resourcePropertyMapping.getBoost());
        resource.addProperty(p);
        return resourcePropertyMapping.getStore() != Property.Store.NO;
    }

    public Object unmarshall(Resource resource, Mapping mapping, MarshallingContext context) throws ConversionException {
        ResourcePropertyMapping resourcePropertyMapping = (ResourcePropertyMapping)mapping;
        if (resourcePropertyMapping.getStore() == Property.Store.NO) {
            return null;
        }
        String propertyName = resourcePropertyMapping.getPath().getPath();
        Property p = resource.getProperty(propertyName);
        if (p == null) {
            return null;
        }
        byte[] value = p.getBinaryValue();
        Byte[] oValue = new Byte[value.length];
        for (int i = 0; i < value.length; ++i) {
            oValue[i] = new Byte(value[i]);
        }
        return oValue;
    }

    protected boolean handleNulls(MarshallingContext context) {
        return context.handleNulls();
    }
}

