/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.jdbc.dialect;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.LinkedList;
import javax.sql.DataSource;
import org.apache.lucene.store.jdbc.JdbcStoreException;
import org.apache.lucene.store.jdbc.datasource.DataSourceUtils;
import org.apache.lucene.store.jdbc.dialect.DB2Dialect;
import org.apache.lucene.store.jdbc.dialect.Dialect;
import org.apache.lucene.store.jdbc.dialect.HSQLDialect;
import org.apache.lucene.store.jdbc.dialect.MySQLDialect;
import org.apache.lucene.store.jdbc.dialect.Oracle8Dialect;
import org.apache.lucene.store.jdbc.dialect.Oracle9Dialect;
import org.apache.lucene.store.jdbc.dialect.OracleDialect;
import org.apache.lucene.store.jdbc.dialect.PostgreSQLDialect;
import org.apache.lucene.store.jdbc.dialect.SQLServerDialect;
import org.apache.lucene.store.jdbc.dialect.SybaseDialect;

public class DialectResolver {
    private LinkedList mappers = new LinkedList();

    public DialectResolver() {
        this(true);
    }

    public DialectResolver(boolean useDefaultMappers) {
        if (!useDefaultMappers) {
            return;
        }
        this.mappers.add(new DatabaseNameToDialectMapper("HSQL Database Engine", HSQLDialect.class));
        this.mappers.add(new DatabaseNameToDialectMapper("DB2/NT", DB2Dialect.class));
        this.mappers.add(new DatabaseNameToDialectMapper("MySQL", MySQLDialect.class));
        this.mappers.add(new DatabaseNameToDialectMapper("PostgreSQL", PostgreSQLDialect.class));
        this.mappers.add(new DatabaseNameStartsWithToDialectMapper("Microsoft SQL Server", SQLServerDialect.class));
        this.mappers.add(new DatabaseNameToDialectMapper("Sybase SQL Server", SybaseDialect.class));
        this.mappers.add(new DatabaseNameAndVersionToDialectMapper("Oracle", 8, Oracle8Dialect.class));
        this.mappers.add(new DatabaseNameAndVersionToDialectMapper("Oracle", 9, Oracle9Dialect.class));
        this.mappers.add(new DatabaseNameToDialectMapper("Oracle", OracleDialect.class));
    }

    public void addFirstMapper(DatabaseMetaDataToDialectMapper mapper) {
        this.mappers.addFirst(mapper);
    }

    public void addLastMapper(DatabaseMetaDataToDialectMapper mapper) {
        this.mappers.addLast(mapper);
    }

    public Dialect getDialect(DataSource dataSource) throws JdbcStoreException {
        String driverName;
        int databaseMinorVersion;
        int databaseMajorVersion;
        String databaseName;
        Connection conn = DataSourceUtils.getConnection(dataSource);
        try {
            DatabaseMetaData metaData = conn.getMetaData();
            databaseName = metaData.getDatabaseProductName();
            databaseMajorVersion = metaData.getDatabaseMajorVersion();
            databaseMinorVersion = metaData.getDatabaseMinorVersion();
            driverName = metaData.getDriverName();
            for (int i = 0; i < this.mappers.size(); ++i) {
                DatabaseMetaDataToDialectMapper mapper = (DatabaseMetaDataToDialectMapper)this.mappers.get(i);
                Class dialectClass = mapper.getDialect(metaData);
                if (dialectClass == null) continue;
                Dialect dialect = (Dialect)dialectClass.newInstance();
                return dialect;
            }
        }
        catch (Exception e) {
            throw new JdbcStoreException("Failed to auto detect dialect", e);
        }
        finally {
            DataSourceUtils.releaseConnection(conn);
        }
        throw new JdbcStoreException("Failed to auto detect dialect, no match found for database [" + databaseName + "] version [" + databaseMajorVersion + "/" + databaseMinorVersion + "] driver [" + driverName + "]");
    }

    public static class DatabaseNameAndVersionToDialectMapper
    implements DatabaseMetaDataToDialectMapper {
        private String databaseName;
        private Class dialect;
        private int version;

        public DatabaseNameAndVersionToDialectMapper(String databaseName, int version, Class dialect) {
            this.databaseName = databaseName;
            this.dialect = dialect;
            this.version = version;
        }

        public Class getDialect(DatabaseMetaData metaData) throws SQLException {
            if (metaData.getDatabaseProductName().equals(this.databaseName) && metaData.getDatabaseMajorVersion() == this.version) {
                return this.dialect;
            }
            return null;
        }
    }

    public static class DatabaseNameStartsWithToDialectMapper
    implements DatabaseMetaDataToDialectMapper {
        private String databaseName;
        private Class dialect;

        public DatabaseNameStartsWithToDialectMapper(String databaseName, Class dialect) {
            this.databaseName = databaseName;
            this.dialect = dialect;
        }

        public Class getDialect(DatabaseMetaData metaData) throws SQLException {
            if (metaData.getDatabaseProductName().startsWith(this.databaseName)) {
                return this.dialect;
            }
            return null;
        }
    }

    public static class DatabaseNameToDialectMapper
    implements DatabaseMetaDataToDialectMapper {
        private String databaseName;
        private Class dialect;

        public DatabaseNameToDialectMapper(String databaseName, Class dialect) {
            this.databaseName = databaseName;
            this.dialect = dialect;
        }

        public Class getDialect(DatabaseMetaData metaData) throws SQLException {
            if (metaData.getDatabaseProductName().equals(this.databaseName)) {
                return this.dialect;
            }
            return null;
        }
    }

    public static interface DatabaseMetaDataToDialectMapper {
        public Class getDialect(DatabaseMetaData var1) throws SQLException;
    }
}

