/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.DefaultErrorResponseHandler;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.simpledb.AmazonSimpleDB;
import com.amazonaws.services.simpledb.SimpleDBResponseMetadata;
import com.amazonaws.services.simpledb.internal.SimpleDBStaxResponseHandler;
import com.amazonaws.services.simpledb.model.BatchDeleteAttributesRequest;
import com.amazonaws.services.simpledb.model.BatchPutAttributesRequest;
import com.amazonaws.services.simpledb.model.CreateDomainRequest;
import com.amazonaws.services.simpledb.model.DeleteAttributesRequest;
import com.amazonaws.services.simpledb.model.DeleteDomainRequest;
import com.amazonaws.services.simpledb.model.DomainMetadataRequest;
import com.amazonaws.services.simpledb.model.DomainMetadataResult;
import com.amazonaws.services.simpledb.model.GetAttributesRequest;
import com.amazonaws.services.simpledb.model.GetAttributesResult;
import com.amazonaws.services.simpledb.model.ListDomainsRequest;
import com.amazonaws.services.simpledb.model.ListDomainsResult;
import com.amazonaws.services.simpledb.model.PutAttributesRequest;
import com.amazonaws.services.simpledb.model.SelectRequest;
import com.amazonaws.services.simpledb.model.SelectResult;
import com.amazonaws.services.simpledb.model.transform.AttributeDoesNotExistExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.BatchDeleteAttributesRequestMarshaller;
import com.amazonaws.services.simpledb.model.transform.BatchPutAttributesRequestMarshaller;
import com.amazonaws.services.simpledb.model.transform.CreateDomainRequestMarshaller;
import com.amazonaws.services.simpledb.model.transform.DeleteAttributesRequestMarshaller;
import com.amazonaws.services.simpledb.model.transform.DeleteDomainRequestMarshaller;
import com.amazonaws.services.simpledb.model.transform.DomainMetadataRequestMarshaller;
import com.amazonaws.services.simpledb.model.transform.DomainMetadataResultStaxUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.DuplicateItemNameExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.GetAttributesRequestMarshaller;
import com.amazonaws.services.simpledb.model.transform.GetAttributesResultStaxUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.InvalidNextTokenExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.InvalidNumberPredicatesExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.InvalidNumberValueTestsExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.InvalidParameterValueExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.InvalidQueryExpressionExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.ListDomainsRequestMarshaller;
import com.amazonaws.services.simpledb.model.transform.ListDomainsResultStaxUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.MissingParameterExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.NoSuchDomainExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.NumberDomainAttributesExceededExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.NumberDomainBytesExceededExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.NumberDomainsExceededExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.NumberItemAttributesExceededExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.NumberSubmittedAttributesExceededExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.NumberSubmittedItemsExceededExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.PutAttributesRequestMarshaller;
import com.amazonaws.services.simpledb.model.transform.RequestTimeoutExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.SelectRequestMarshaller;
import com.amazonaws.services.simpledb.model.transform.SelectResultStaxUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.TooManyRequestedAttributesExceptionUnmarshaller;
import com.amazonaws.transform.LegacyErrorUnmarshaller;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

public class AmazonSimpleDBClient
extends AmazonWebServiceClient
implements AmazonSimpleDB {
    private AWSCredentialsProvider awsCredentialsProvider;
    protected final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();

    public AmazonSimpleDBClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AmazonSimpleDBClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonSimpleDBClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonSimpleDBClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonSimpleDBClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AmazonSimpleDBClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AmazonSimpleDBClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new InvalidParameterValueExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new NumberDomainBytesExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new NoSuchDomainExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new NumberDomainsExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new NumberSubmittedItemsExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new RequestTimeoutExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new InvalidQueryExpressionExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new NumberSubmittedAttributesExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new DuplicateItemNameExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new NumberDomainAttributesExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new InvalidNumberPredicatesExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new TooManyRequestedAttributesExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new InvalidNextTokenExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new NumberItemAttributesExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new AttributeDoesNotExistExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new MissingParameterExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new InvalidNumberValueTestsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new LegacyErrorUnmarshaller());
        this.setEndpoint("sdb.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/simpledb/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/simpledb/request.handler2s"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SelectResult select(SelectRequest selectRequest) {
        ExecutionContext executionContext = this.createExecutionContext(selectRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SelectRequest> request = null;
        Response<SelectResult> response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SelectRequestMarshaller().marshall(selectRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new SelectResultStaxUnmarshaller(), executionContext);
            SelectResult selectResult = (SelectResult)response.getAwsResponse();
            return selectResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAttributes(PutAttributesRequest putAttributesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<PutAttributesRequest> request = null;
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new PutAttributesRequestMarshaller().marshall(putAttributesRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void batchDeleteAttributes(BatchDeleteAttributesRequest batchDeleteAttributesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchDeleteAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<BatchDeleteAttributesRequest> request = null;
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new BatchDeleteAttributesRequestMarshaller().marshall(batchDeleteAttributesRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteDomain(DeleteDomainRequest deleteDomainRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteDomainRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DeleteDomainRequest> request = null;
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DeleteDomainRequestMarshaller().marshall(deleteDomainRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createDomain(CreateDomainRequest createDomainRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createDomainRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<CreateDomainRequest> request = null;
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new CreateDomainRequestMarshaller().marshall(createDomainRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAttributes(DeleteAttributesRequest deleteAttributesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DeleteAttributesRequest> request = null;
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DeleteAttributesRequestMarshaller().marshall(deleteAttributesRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDomainsResult listDomains(ListDomainsRequest listDomainsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDomainsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDomainsRequest> request = null;
        Response<ListDomainsResult> response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDomainsRequestMarshaller().marshall(listDomainsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new ListDomainsResultStaxUnmarshaller(), executionContext);
            ListDomainsResult listDomainsResult = (ListDomainsResult)response.getAwsResponse();
            return listDomainsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAttributesResult getAttributes(GetAttributesRequest getAttributesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetAttributesRequest> request = null;
        Response<GetAttributesResult> response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetAttributesRequestMarshaller().marshall(getAttributesRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new GetAttributesResultStaxUnmarshaller(), executionContext);
            GetAttributesResult getAttributesResult = (GetAttributesResult)response.getAwsResponse();
            return getAttributesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void batchPutAttributes(BatchPutAttributesRequest batchPutAttributesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchPutAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<BatchPutAttributesRequest> request = null;
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new BatchPutAttributesRequestMarshaller().marshall(batchPutAttributesRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DomainMetadataResult domainMetadata(DomainMetadataRequest domainMetadataRequest) {
        ExecutionContext executionContext = this.createExecutionContext(domainMetadataRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DomainMetadataRequest> request = null;
        Response<DomainMetadataResult> response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DomainMetadataRequestMarshaller().marshall(domainMetadataRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new DomainMetadataResultStaxUnmarshaller(), executionContext);
            DomainMetadataResult domainMetadataResult = (DomainMetadataResult)response.getAwsResponse();
            return domainMetadataResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListDomainsResult listDomains() throws AmazonServiceException, AmazonClientException {
        return this.listDomains(new ListDomainsRequest());
    }

    public SimpleDBResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        ResponseMetadata metadata = this.client.getResponseMetadataForRequest(request);
        if (metadata != null) {
            return new SimpleDBResponseMetadata(metadata);
        }
        return null;
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, Unmarshaller<X, StaxUnmarshallerContext> unmarshaller, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        for (Map.Entry entry : originalRequest.copyPrivateRequestParameters().entrySet()) {
            request.addParameter((String)entry.getKey(), (String)entry.getValue());
        }
        AWSCredentials credentials = this.awsCredentialsProvider.getCredentials();
        if (originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setCredentials(credentials);
        SimpleDBStaxResponseHandler<X> responseHandler = new SimpleDBStaxResponseHandler<X>(unmarshaller);
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.client.execute(request, responseHandler, (HttpResponseHandler)errorResponseHandler, executionContext);
    }
}

