/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.core.config;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.airavata.gfac.core.GFacException;
import org.apache.airavata.gfac.core.config.DataTransferTaskConfig;
import org.apache.airavata.gfac.core.config.JobSubmitterTaskConfig;
import org.apache.airavata.gfac.core.config.ResourceConfig;
import org.apache.airavata.model.appcatalog.computeresource.JobSubmissionProtocol;
import org.apache.airavata.model.appcatalog.computeresource.ResourceJobManagerType;
import org.apache.airavata.model.data.movement.DataMovementProtocol;
import org.yaml.snakeyaml.Yaml;

public class GFacYamlConfigruation {
    private static final String CONFIG = "config";
    private static final String JOB_SUBMITTERS = "jobSubmitters";
    private static final String SUBMISSIO_PROTOCOL = "submissionProtocol";
    private static final String TASK_CLASS = "taskClass";
    private static final String COMMON_TASKS = "commonTasks";
    private static final String TYPE = "type";
    private static final String FILE_TRANSFER_TASKS = "fileTransferTasks";
    private static final String TRANSFER_PROTOCOL = "transferProtocol";
    private static final String RESOURCES = "resources";
    private static final String JOB_MANAGER_TYPE = "jobManagerType";
    private static final String COMMAND_OUTPUT_PARSER = "commandOutputParser";
    private static final String EMAIL_PARSER = "emailParser";
    private static final String RESOURCE_EMAIL_ADDRESS = "resourceEmailAddresses";
    private static final String PROPERTIES = "properties";
    private List<JobSubmitterTaskConfig> jobSubmitters = new ArrayList<JobSubmitterTaskConfig>();
    private List<DataTransferTaskConfig> fileTransferTasks = new ArrayList<DataTransferTaskConfig>();
    private List<ResourceConfig> resources = new ArrayList<ResourceConfig>();

    public GFacYamlConfigruation() throws GFacException {
        InputStream resourceAsStream = GFacYamlConfigruation.class.getClassLoader().getResourceAsStream("gfac-config.yaml");
        this.parse(resourceAsStream);
    }

    private void parse(InputStream resourceAsStream) throws GFacException {
        if (resourceAsStream == null) {
            throw new GFacException("Configuration file{gfac-config.yaml} is not fund");
        }
        Yaml yaml = new Yaml();
        Object load = yaml.load(resourceAsStream);
        if (load == null) {
            throw new GFacException("Yaml configuration object null");
        }
        if (load instanceof Map) {
            List resourcesYaml;
            List fileTransYamls;
            String identifier;
            Map loadMap = (Map)load;
            List jobSubYamls = (List)loadMap.get(JOB_SUBMITTERS);
            if (jobSubYamls != null) {
                for (Map jobSub : jobSubYamls) {
                    List propertiesList;
                    JobSubmitterTaskConfig jobSubmitterTaskConfig = new JobSubmitterTaskConfig();
                    identifier = (String)jobSub.get(SUBMISSIO_PROTOCOL);
                    jobSubmitterTaskConfig.setSubmissionProtocol(JobSubmissionProtocol.valueOf((String)identifier));
                    jobSubmitterTaskConfig.setTaskClass((String)jobSub.get(TASK_CLASS));
                    Iterator<Object> propertiesObj = jobSub.get(PROPERTIES);
                    if (propertiesObj instanceof List && (propertiesList = (List)((Object)propertiesObj)).size() > 0) {
                        Map props = (Map)propertiesList.get(0);
                        jobSubmitterTaskConfig.addProperties(props);
                    }
                    this.jobSubmitters.add(jobSubmitterTaskConfig);
                }
            }
            if ((fileTransYamls = (List)loadMap.get(FILE_TRANSFER_TASKS)) != null) {
                for (Map fileTransConfig : fileTransYamls) {
                    List propertiesList;
                    DataTransferTaskConfig dataTransferTaskConfig = new DataTransferTaskConfig();
                    identifier = (String)fileTransConfig.get(TRANSFER_PROTOCOL);
                    dataTransferTaskConfig.setTransferProtocol(DataMovementProtocol.valueOf((String)identifier));
                    dataTransferTaskConfig.setTaskClass((String)fileTransConfig.get(TASK_CLASS));
                    Object propertiesObj = fileTransConfig.get(PROPERTIES);
                    if (propertiesObj instanceof List && (propertiesList = (List)propertiesObj).size() > 0) {
                        Map props = (Map)propertiesList.get(0);
                        dataTransferTaskConfig.addProperties(props);
                    }
                    this.fileTransferTasks.add(dataTransferTaskConfig);
                }
            }
            if ((resourcesYaml = (List)loadMap.get(RESOURCES)) != null) {
                for (Map resource : resourcesYaml) {
                    ResourceConfig resourceConfig = new ResourceConfig();
                    identifier = resource.get(JOB_MANAGER_TYPE).toString();
                    resourceConfig.setJobManagerType(ResourceJobManagerType.valueOf((String)identifier));
                    resourceConfig.setCommandOutputParser(resource.get(COMMAND_OUTPUT_PARSER).toString());
                    Object emailParser = resource.get(EMAIL_PARSER);
                    if (emailParser != null) {
                        resourceConfig.setEmailParser(emailParser.toString());
                    }
                    List emailAddressList = (List)resource.get(RESOURCE_EMAIL_ADDRESS);
                    resourceConfig.setResourceEmailAddresses(emailAddressList);
                    this.resources.add(resourceConfig);
                }
            }
        }
    }

    public List<JobSubmitterTaskConfig> getJobSbumitters() {
        return this.jobSubmitters;
    }

    public List<DataTransferTaskConfig> getFileTransferTasks() {
        return this.fileTransferTasks;
    }

    public List<ResourceConfig> getResourceConfiguration() {
        return this.resources;
    }
}

