/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.util;

import java.io.IOException;
import java.net.InetAddress;
import java.security.SecureRandom;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.lang.exception.NestableRuntimeException;
import org.apache.openjpa.lib.util.Base16Encoder;
import org.apache.openjpa.lib.util.Bytes;

public class UUIDGenerator {
    public static final int TYPE1 = 1;
    public static final int TYPE4 = 4;
    private static final byte IDX_TIME_HI = 6;
    private static final byte IDX_TYPE = 6;
    private static final byte IDX_TIME_MID = 4;
    private static final byte IDX_TIME_LO = 0;
    private static final byte IDX_TIME_SEQ = 8;
    private static final byte IDX_VARIATION = 8;
    private static final byte TS_TIME_LO_IDX = 4;
    private static final byte TS_TIME_LO_LEN = 4;
    private static final byte TS_TIME_MID_IDX = 2;
    private static final byte TS_TIME_MID_LEN = 2;
    private static final byte TS_TIME_HI_IDX = 0;
    private static final byte TS_TIME_HI_LEN = 2;
    private static final long GREG_OFFSET = 12219292800000L;
    private static final long MILLI_MULT = 10000L;
    private static final byte TYPE_TIME_BASED = 16;
    private static Random RANDOM;
    private static byte[] IP;
    private static int _counter;
    private static long _currentMillis;
    private static long _lastMillis;
    private static final int MAX_14BIT = 16383;
    private static short _seq;
    private static boolean type1Initialized;

    private static synchronized void initializeForType1() {
        if (type1Initialized) {
            return;
        }
        RANDOM = new SecureRandom();
        _seq = (short)RANDOM.nextInt(16383);
        byte[] ip = null;
        try {
            ip = InetAddress.getLocalHost().getAddress();
        }
        catch (IOException ioe) {
            throw new NestableRuntimeException(ioe);
        }
        IP = new byte[6];
        RANDOM.nextBytes(IP);
        System.arraycopy(ip, 0, IP, 2, ip.length);
        type1Initialized = true;
    }

    public static byte[] next(int type) {
        if (type == 4) {
            return UUIDGenerator.createType4();
        }
        return UUIDGenerator.createType1();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] createType1() {
        if (!type1Initialized) {
            UUIDGenerator.initializeForType1();
        }
        byte[] uuid = new byte[16];
        System.arraycopy(IP, 0, uuid, 10, IP.length);
        long now = 0L;
        Class<UUIDGenerator> clazz = UUIDGenerator.class;
        synchronized (UUIDGenerator.class) {
            now = UUIDGenerator.getTime();
            uuid[8] = (byte)((_seq & 0x3F00) >>> 8);
            uuid[8] = (byte)(uuid[8] | 0x80);
            uuid[9] = (byte)(_seq & 0xFF);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            byte[] timeBytes = Bytes.toBytes(now);
            System.arraycopy(timeBytes, 4, uuid, 0, 4);
            System.arraycopy(timeBytes, 2, uuid, 4, 2);
            System.arraycopy(timeBytes, 0, uuid, 6, 2);
            uuid[6] = (byte)(uuid[6] | 0x10);
            return uuid;
        }
    }

    private static byte[] createType4() {
        UUID type4 = UUID.randomUUID();
        byte[] uuid = new byte[16];
        UUIDGenerator.longToBytes(type4.getMostSignificantBits(), uuid, 0);
        UUIDGenerator.longToBytes(type4.getLeastSignificantBits(), uuid, 8);
        return uuid;
    }

    private static void longToBytes(long longVal, byte[] buf, int sPos) {
        sPos += 7;
        for (int i = 0; i < 8; ++i) {
            buf[sPos - i] = (byte)(longVal >>> i * 8);
        }
    }

    public static String nextString(int type) {
        byte[] bytes = UUIDGenerator.next(type);
        try {
            return new String(bytes, "ISO-8859-1");
        }
        catch (Exception e) {
            return new String(bytes);
        }
    }

    public static String nextHex(int type) {
        return Base16Encoder.encode(UUIDGenerator.next(type));
    }

    static long getTime() {
        long newTime;
        if (RANDOM == null) {
            UUIDGenerator.initializeForType1();
        }
        if ((newTime = UUIDGenerator.getUUIDTime()) <= _lastMillis) {
            UUIDGenerator.incrementSequence();
            newTime = UUIDGenerator.getUUIDTime();
        }
        _lastMillis = newTime;
        return newTime;
    }

    private static long getUUIDTime() {
        if (_currentMillis != System.currentTimeMillis()) {
            _currentMillis = System.currentTimeMillis();
            _counter = 0;
        }
        if ((long)(_counter + 1) >= 10000L) {
            ++_currentMillis;
            _counter = 0;
        }
        long currentTime = (_currentMillis + 12219292800000L) * 10000L;
        return currentTime + (long)_counter++;
    }

    private static void incrementSequence() {
        if ((_seq = (short)(_seq + 1)) > 16383) {
            _seq = (short)RANDOM.nextInt(16383);
        }
    }

    static {
        _lastMillis = 0L;
        _seq = 0;
        type1Initialized = false;
    }
}

