/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.event;

import org.apache.openjpa.event.BeginTransactionListener;
import org.apache.openjpa.event.EndTransactionListener;
import org.apache.openjpa.event.FlushTransactionListener;
import org.apache.openjpa.event.TransactionEvent;
import org.apache.openjpa.lib.util.concurrent.AbstractConcurrentEventManager;

public class TransactionEventManager
extends AbstractConcurrentEventManager {
    private int _begin = 0;
    private int _flush = 0;
    private int _end = 0;

    @Override
    public void addListener(Object listener) {
        super.addListener(listener);
        if (listener instanceof BeginTransactionListener) {
            ++this._begin;
        }
        if (listener instanceof FlushTransactionListener) {
            ++this._flush;
        }
        if (listener instanceof EndTransactionListener) {
            ++this._end;
        }
    }

    @Override
    public boolean removeListener(Object listener) {
        if (!super.removeListener(listener)) {
            return false;
        }
        if (listener instanceof BeginTransactionListener) {
            --this._begin;
        }
        if (listener instanceof FlushTransactionListener) {
            --this._flush;
        }
        if (listener instanceof EndTransactionListener) {
            --this._end;
        }
        return true;
    }

    public boolean hasBeginListeners() {
        return this._begin > 0;
    }

    public boolean hasFlushListeners() {
        return this._flush > 0;
    }

    public boolean hasEndListeners() {
        return this._end > 0;
    }

    @Override
    protected void fireEvent(Object event, Object listener) {
        TransactionEvent ev = (TransactionEvent)event;
        switch (ev.getType()) {
            case 0: {
                if (!(listener instanceof BeginTransactionListener)) break;
                ((BeginTransactionListener)listener).afterBegin(ev);
                break;
            }
            case 1: {
                if (!(listener instanceof FlushTransactionListener)) break;
                ((FlushTransactionListener)listener).beforeFlush(ev);
                break;
            }
            case 2: {
                if (!(listener instanceof FlushTransactionListener)) break;
                ((FlushTransactionListener)listener).afterFlush(ev);
                break;
            }
            case 3: {
                if (!(listener instanceof EndTransactionListener)) break;
                ((EndTransactionListener)listener).beforeCommit(ev);
                break;
            }
            case 4: {
                if (!(listener instanceof EndTransactionListener)) break;
                ((EndTransactionListener)listener).afterCommit(ev);
                break;
            }
            case 5: {
                if (!(listener instanceof EndTransactionListener)) break;
                ((EndTransactionListener)listener).afterRollback(ev);
                break;
            }
            case 6: {
                if (!(listener instanceof EndTransactionListener)) break;
                ((EndTransactionListener)listener).afterStateTransitions(ev);
                break;
            }
            case 7: {
                if (!(listener instanceof EndTransactionListener)) break;
                ((EndTransactionListener)listener).afterCommitComplete(ev);
                break;
            }
            case 8: {
                if (!(listener instanceof EndTransactionListener)) break;
                ((EndTransactionListener)listener).afterRollbackComplete(ev);
            }
        }
    }
}

