/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.catalina.Container;
import org.apache.catalina.Wrapper;
import org.apache.catalina.comet.CometEvent;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.valves.ValveBase;
import org.apache.tomcat.util.buf.MessageBytes;

final class StandardContextValve
extends ValveBase {
    private static final String info = "org.apache.catalina.core.StandardContextValve/1.0";
    private StandardContext context = null;

    public StandardContextValve() {
        super(true);
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public void setContainer(Container container) {
        super.setContainer(container);
        this.context = (StandardContext)container;
    }

    @Override
    public final void invoke(Request request, Response response) throws IOException, ServletException {
        Wrapper wrapper;
        MessageBytes requestPathMB = request.getRequestPathMB();
        if (requestPathMB.startsWithIgnoreCase("/META-INF/", 0) || requestPathMB.equalsIgnoreCase("/META-INF") || requestPathMB.startsWithIgnoreCase("/WEB-INF/", 0) || requestPathMB.equalsIgnoreCase("/WEB-INF")) {
            response.sendError(404);
            return;
        }
        boolean reloaded = false;
        while (this.context.getPaused()) {
            reloaded = true;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {}
        }
        if (reloaded && this.context.getLoader() != null && this.context.getLoader().getClassLoader() != null) {
            Thread.currentThread().setContextClassLoader(this.context.getLoader().getClassLoader());
        }
        if ((wrapper = request.getWrapper()) == null) {
            response.sendError(404);
            return;
        }
        if (wrapper.isUnavailable() && (wrapper = (Wrapper)this.container.findChild(wrapper.getName())) == null) {
            response.sendError(404);
            return;
        }
        try {
            response.sendAcknowledgement();
        }
        catch (IOException ioe) {
            this.container.getLogger().error((Object)sm.getString("standardContextValve.acknowledgeException"), (Throwable)ioe);
            request.setAttribute("javax.servlet.error.exception", ioe);
            response.sendError(500);
            return;
        }
        if (request.isAsyncSupported()) {
            request.setAsyncSupported(wrapper.getPipeline().isAsyncSupported());
        }
        wrapper.getPipeline().getFirst().invoke(request, response);
    }

    @Override
    public final void event(Request request, Response response, CometEvent event) throws IOException, ServletException {
        Wrapper wrapper = request.getWrapper();
        wrapper.getPipeline().getFirst().event(request, response, event);
    }
}

