/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.impl;

import eu.emi.security.authn.x509.helpers.ssl.HostnameToCertificateChecker;
import eu.emi.security.authn.x509.impl.CertificateUtils;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;

@Deprecated
public abstract class AbstractHostnameToCertificateChecker
implements HandshakeCompletedListener {
    @Override
    public void handshakeCompleted(HandshakeCompletedEvent hce) {
        X509Certificate cert;
        try {
            Certificate[] serverChain = hce.getPeerCertificates();
            if (serverChain == null || serverChain.length == 0) {
                this.processingError(hce, new Exception("JDK BUG? Got null or empty peer certificate array"));
                return;
            }
            if (!(serverChain[0] instanceof X509Certificate)) {
                this.processingError(hce, new ClassCastException("Peer certificate should be an X.509 certificate, but is " + serverChain[0].getClass().getName()));
                return;
            }
            cert = (X509Certificate)serverChain[0];
        }
        catch (SSLPeerUnverifiedException e) {
            this.processingError(hce, new Exception("Peer is unverified when handshake is completed - is it really an X.509-authenticated connection?", e));
            return;
        }
        String hostname = hce.getSocket().getInetAddress().getHostName();
        try {
            HostnameToCertificateChecker checker = new HostnameToCertificateChecker();
            if (!checker.checkMatching(hostname, cert)) {
                this.nameMismatch(hce, cert, hostname);
            }
        }
        catch (Exception e) {
            this.processingError(hce, e);
            return;
        }
    }

    protected abstract void nameMismatch(HandshakeCompletedEvent var1, X509Certificate var2, String var3) throws SSLException;

    protected void processingError(HandshakeCompletedEvent hce, Exception e) {
        throw new IllegalStateException("Error occured when verifying if the SSL peer's hostname matches its certificate", e);
    }

    static {
        CertificateUtils.configureSecProvider();
    }
}

