/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.trust;

import eu.emi.security.authn.x509.StoreUpdateListener;
import eu.emi.security.authn.x509.helpers.ObserversHandler;
import eu.emi.security.authn.x509.helpers.ns.EuGridPmaNamespacesStore;
import eu.emi.security.authn.x509.helpers.ns.GlobusNamespacesStore;
import eu.emi.security.authn.x509.helpers.ns.NamespacesStore;
import eu.emi.security.authn.x509.helpers.trust.DirectoryTrustAnchorStore;
import eu.emi.security.authn.x509.helpers.trust.OpensslTrustAnchorStore;
import eu.emi.security.authn.x509.helpers.trust.OpensslTruststoreHelper;
import eu.emi.security.authn.x509.helpers.trust.TrustAnchorExt;
import eu.emi.security.authn.x509.impl.CertificateUtils;
import java.io.File;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;

public class OpensslTrustAnchorStoreImpl
extends DirectoryTrustAnchorStore
implements OpensslTrustAnchorStore {
    public static final String CERT_WILDCARD = "????????.*";
    private boolean loadEuGridPmaNs;
    private boolean loadGlobusNs;
    private boolean openssl1Mode;
    private NamespacesStore pmaNsStore;
    private NamespacesStore globusNsStore;

    public OpensslTrustAnchorStoreImpl(String basePath, Timer t, long updateInterval, boolean loadGlobusNs, boolean loadEuGridPmaNs, ObserversHandler observers, boolean openssl1Mode) {
        super(Collections.singletonList(basePath + File.separator + CERT_WILDCARD), null, 0, t, updateInterval, CertificateUtils.Encoding.PEM, observers, true);
        this.openssl1Mode = openssl1Mode;
        this.pmaNsStore = new EuGridPmaNamespacesStore(observers, openssl1Mode);
        this.globusNsStore = new GlobusNamespacesStore(observers, openssl1Mode);
        this.loadEuGridPmaNs = loadEuGridPmaNs;
        this.loadGlobusNs = loadGlobusNs;
        this.update();
        this.scheduleUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void reloadCerts(Collection<URL> locations) {
        ArrayList<String> correctLocations = new ArrayList<String>();
        HashSet<TrustAnchorExt> tmpAnchors = new HashSet<TrustAnchorExt>();
        HashMap<URL, TrustAnchorExt> tmpLoc2anch = new HashMap<URL, TrustAnchorExt>();
        for (URL location : locations) {
            boolean loaded = this.tryLoadCert(location, tmpAnchors, tmpLoc2anch);
            if (!loaded) continue;
            correctLocations.add(location.getPath());
        }
        OpensslTrustAnchorStoreImpl opensslTrustAnchorStoreImpl = this;
        synchronized (opensslTrustAnchorStoreImpl) {
            this.anchors.addAll(tmpAnchors);
            this.locations2anchors.putAll(tmpLoc2anch);
            if (this.loadEuGridPmaNs) {
                this.pmaNsStore.setPolicies(correctLocations);
            }
            if (this.loadGlobusNs) {
                this.globusNsStore.setPolicies(correctLocations);
            }
        }
    }

    protected boolean tryLoadCert(URL location, Set<TrustAnchorExt> tmpAnchors, Map<URL, TrustAnchorExt> tmpLoc2anch) {
        X509Certificate cert;
        String fileHash = OpensslTruststoreHelper.getFileHash(location.getPath(), "^([0-9a-fA-F]{8})\\.[\\d]+$");
        if (fileHash == null) {
            return false;
        }
        try {
            cert = this.loadCert(location);
        }
        catch (Exception e) {
            this.observers.notifyObservers(location.toExternalForm(), "CA Certificate", StoreUpdateListener.Severity.ERROR, e);
            return false;
        }
        String certHash = OpensslTruststoreHelper.getOpenSSLCAHash(cert.getSubjectX500Principal(), this.openssl1Mode);
        if (!fileHash.equalsIgnoreCase(certHash)) {
            return false;
        }
        TrustAnchorExt anchor = new TrustAnchorExt(cert, null);
        tmpAnchors.add(anchor);
        tmpLoc2anch.put(location, anchor);
        return true;
    }

    @Override
    public NamespacesStore getPmaNsStore() {
        return this.pmaNsStore;
    }

    @Override
    public NamespacesStore getGlobusNsStore() {
        return this.globusNsStore;
    }
}

