/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.ns;

import eu.emi.security.authn.x509.NamespaceCheckingMode;
import eu.emi.security.authn.x509.ValidationError;
import eu.emi.security.authn.x509.ValidationErrorCode;
import eu.emi.security.authn.x509.helpers.ns.NamespacePolicy;
import eu.emi.security.authn.x509.helpers.ns.NamespacesStore;
import eu.emi.security.authn.x509.impl.X500NameUtils;
import eu.emi.security.authn.x509.proxy.ProxyUtils;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.security.auth.x500.X500Principal;

public class NamespaceChecker {
    private boolean namespaceRequired;
    private boolean checkAll;
    private NamespacesStore[] nsStores;

    public NamespaceChecker(NamespaceCheckingMode mode, NamespacesStore pmaStore, NamespacesStore globusStore) {
        this.namespaceRequired = mode.isRequired();
        this.checkAll = mode == NamespaceCheckingMode.EUGRIDPMA_AND_GLOBUS || mode == NamespaceCheckingMode.EUGRIDPMA_AND_GLOBUS_REQUIRE;
        int used = 0;
        if (mode.globusEnabled()) {
            ++used;
        }
        if (mode.euGridPmaEnabled()) {
            ++used;
        }
        this.nsStores = new NamespacesStore[used];
        if (mode.isGlobusFirst()) {
            this.nsStores[0] = globusStore;
            if (mode.euGridPmaEnabled()) {
                this.nsStores[1] = pmaStore;
            }
        } else {
            if (mode.euGridPmaEnabled()) {
                this.nsStores[0] = pmaStore;
            }
            if (mode.globusEnabled()) {
                this.nsStores[1] = globusStore;
            }
        }
    }

    public List<ValidationError> check(X509Certificate[] chain) {
        if (this.nsStores.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<ValidationError> ret = new ArrayList<ValidationError>();
        for (int i = 0; i < chain.length; ++i) {
            X500Principal certSubject;
            boolean found = false;
            X500Principal certIssuer = chain[i].getIssuerX500Principal();
            if (certIssuer.equals(certSubject = chain[i].getSubjectX500Principal()) || ProxyUtils.isProxy(chain[i])) continue;
            for (NamespacesStore nsStore : this.nsStores) {
                List<NamespacePolicy> policies = nsStore.getPolicies(chain, i);
                if (policies == null || policies.size() == 0) continue;
                found = true;
                this.doCheck(certSubject, policies, ret, i, chain);
                if (!this.checkAll) break;
            }
            if (found || !this.namespaceRequired) continue;
            ret.add(new ValidationError(chain, i, ValidationErrorCode.nsUndefinedAndRequired, X500NameUtils.getReadableForm(certIssuer)));
        }
        return ret;
    }

    private void doCheck(X500Principal subject, List<NamespacePolicy> policies, List<ValidationError> ret, int pos, X509Certificate[] chain) {
        boolean permitFound = false;
        StringBuilder policyNames = new StringBuilder();
        for (NamespacePolicy policy : policies) {
            policyNames.append(policy.getIdentification()).append(" ");
            if (!policy.isSubjectMatching(subject)) continue;
            if (!policy.isPermit()) {
                ret.add(new ValidationError(chain, pos, ValidationErrorCode.nsDeny, X500NameUtils.getReadableForm(subject), policy.getIdentification()));
                continue;
            }
            permitFound = true;
        }
        if (!permitFound) {
            ret.add(new ValidationError(chain, pos, ValidationErrorCode.nsNotAccepted, X500NameUtils.getReadableForm(subject), policyNames.toString()));
        }
    }
}

