/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.logs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TestMetricFilterRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String filterPattern;
    private ListWithAutoConstructFlag<String> logEventMessages;

    public String getFilterPattern() {
        return this.filterPattern;
    }

    public void setFilterPattern(String filterPattern) {
        this.filterPattern = filterPattern;
    }

    public TestMetricFilterRequest withFilterPattern(String filterPattern) {
        this.filterPattern = filterPattern;
        return this;
    }

    public List<String> getLogEventMessages() {
        if (this.logEventMessages == null) {
            this.logEventMessages = new ListWithAutoConstructFlag();
            this.logEventMessages.setAutoConstruct(true);
        }
        return this.logEventMessages;
    }

    public void setLogEventMessages(Collection<String> logEventMessages) {
        if (logEventMessages == null) {
            this.logEventMessages = null;
            return;
        }
        ListWithAutoConstructFlag logEventMessagesCopy = new ListWithAutoConstructFlag(logEventMessages.size());
        logEventMessagesCopy.addAll(logEventMessages);
        this.logEventMessages = logEventMessagesCopy;
    }

    public TestMetricFilterRequest withLogEventMessages(String ... logEventMessages) {
        if (this.getLogEventMessages() == null) {
            this.setLogEventMessages(new ArrayList<String>(logEventMessages.length));
        }
        for (String value : logEventMessages) {
            this.getLogEventMessages().add(value);
        }
        return this;
    }

    public TestMetricFilterRequest withLogEventMessages(Collection<String> logEventMessages) {
        if (logEventMessages == null) {
            this.logEventMessages = null;
        } else {
            ListWithAutoConstructFlag logEventMessagesCopy = new ListWithAutoConstructFlag(logEventMessages.size());
            logEventMessagesCopy.addAll(logEventMessages);
            this.logEventMessages = logEventMessagesCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFilterPattern() != null) {
            sb.append("FilterPattern: " + this.getFilterPattern() + ",");
        }
        if (this.getLogEventMessages() != null) {
            sb.append("LogEventMessages: " + this.getLogEventMessages());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFilterPattern() == null ? 0 : this.getFilterPattern().hashCode());
        hashCode = 31 * hashCode + (this.getLogEventMessages() == null ? 0 : this.getLogEventMessages().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestMetricFilterRequest)) {
            return false;
        }
        TestMetricFilterRequest other = (TestMetricFilterRequest)obj;
        if (other.getFilterPattern() == null ^ this.getFilterPattern() == null) {
            return false;
        }
        if (other.getFilterPattern() != null && !other.getFilterPattern().equals(this.getFilterPattern())) {
            return false;
        }
        if (other.getLogEventMessages() == null ^ this.getLogEventMessages() == null) {
            return false;
        }
        return other.getLogEventMessages() == null || other.getLogEventMessages().equals(this.getLogEventMessages());
    }
}

