/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.util.jetty;

import eu.unicore.util.Log;
import eu.unicore.util.configuration.ConfigurationException;
import eu.unicore.util.configuration.DocumentationReferenceMeta;
import eu.unicore.util.configuration.PropertiesHelper;
import eu.unicore.util.configuration.PropertyMD;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class HttpServerProperties
extends PropertiesHelper {
    private static final Logger log = Log.getLogger("unicore.configuration", HttpServerProperties.class);
    public static final String DEFAULT_PREFIX = "httpServer.";
    public static final String FAST_RANDOM = "fastRandom";
    public static final String USE_NIO = "useNIO";
    public static final String MIN_THREADS = "minThreads";
    public static final String MAX_THREADS = "maxThreads";
    public static final String HIGH_LOAD_CONNECTIONS = "highLoadConnections";
    public static final String MAX_IDLE_TIME = "maxIdleTime";
    public static final String LOW_RESOURCE_MAX_IDLE_TIME = "lowResourceMaxIdleTime";
    public static final String SO_LINGER_TIME = "soLingerTime";
    public static final String WANT_CLIENT_AUTHN = "wantClientAuthn";
    public static final String REQUIRE_CLIENT_AUTHN = "requireClientAuthn";
    public static final String DISABLED_CIPHER_SUITES = "disabledCipherSuites";
    public static final String GZIP_PREFIX = "gzip.";
    public static final String MIN_GZIP_SIZE = "gzip.minGzipSize";
    public static final String ENABLE_GZIP = "gzip.enable";
    @DocumentationReferenceMeta
    protected static final Map<String, PropertyMD> defaults = new HashMap<String, PropertyMD>();

    public HttpServerProperties() throws ConfigurationException {
        this(new Properties(), DEFAULT_PREFIX);
    }

    public HttpServerProperties(Properties properties) throws ConfigurationException {
        this(properties, DEFAULT_PREFIX);
    }

    public HttpServerProperties(Properties properties, String prefix) throws ConfigurationException {
        super(prefix, properties, defaults, log);
    }

    protected HttpServerProperties(Properties properties, String prefix, Map<String, PropertyMD> defaults) throws ConfigurationException {
        super(prefix, properties, defaults, log);
    }

    public static HttpServerProperties getSimpleTestSettings() {
        Properties p = new Properties();
        HttpServerProperties ret = new HttpServerProperties(p);
        ret.setProperty(FAST_RANDOM, "true");
        ret.setProperty(SO_LINGER_TIME, "1");
        return ret;
    }

    static {
        defaults.put(MAX_THREADS, new PropertyMD("255").setPositive().setDescription("Maximum number of threads to have in the thread pool for processing HTTP connections."));
        defaults.put(MIN_THREADS, new PropertyMD("1").setPositive().setDescription("Minimum number of threads to have in the thread pool for processing HTTP connections."));
        defaults.put(HIGH_LOAD_CONNECTIONS, new PropertyMD("200").setPositive().setDescription("If the number of connections exceeds this amount, then the connector is put into a special 'low on resources' state. Existing connections will be closed faster. Note that this value is honored only for NIO connectors. Legacy connectors go into low resources mode when no more threads are available."));
        defaults.put(MAX_IDLE_TIME, new PropertyMD("200000").setPositive().setDescription("Time (in ms.) before an idle connection will time out. It should be large enough not to expire connections with slow clients, values below 30s are getting quite risky."));
        defaults.put(LOW_RESOURCE_MAX_IDLE_TIME, new PropertyMD("100").setPositive().setDescription("In low resource conditions, time (in ms.) before an idle connection will time out."));
        defaults.put(FAST_RANDOM, new PropertyMD("false").setDescription("Use insecure, but fast pseudo random generator to generate session ids instead of secure generator for SSL sockets."));
        defaults.put(SO_LINGER_TIME, new PropertyMD("-1").setDescription("Socket linger time."));
        defaults.put(WANT_CLIENT_AUTHN, new PropertyMD("true").setDescription("Controls whether the SSL socket accepts (but does not require) client-side authentication."));
        defaults.put(REQUIRE_CLIENT_AUTHN, new PropertyMD("true").setDescription("Controls whether the SSL socket requires client-side authentication."));
        defaults.put(DISABLED_CIPHER_SUITES, new PropertyMD("").setDescription("Space separated list of SSL cipher suites to be disabled."));
        defaults.put(MIN_GZIP_SIZE, new PropertyMD("100000").setDescription("Specifies the minimal size of message that should be compressed."));
        defaults.put(ENABLE_GZIP, new PropertyMD("false").setDescription("Controls whether to enable compression of HTTP responses."));
        defaults.put(USE_NIO, new PropertyMD("true").setDescription("Controls whether the NIO connector be used. NIO is best suited under high-load, when lots of connections exist that are idle for long periods."));
    }
}

