/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uftp.server;

import eu.unicore.uftp.dpc.DPCServer;
import eu.unicore.uftp.dpc.Session;
import eu.unicore.uftp.dpc.Utils;
import eu.unicore.uftp.jparss.PSocket;
import eu.unicore.uftp.rsync.Master;
import eu.unicore.uftp.rsync.MasterChannel;
import eu.unicore.uftp.rsync.RsyncStats;
import eu.unicore.uftp.rsync.Slave;
import eu.unicore.uftp.rsync.SocketMasterChannel;
import eu.unicore.uftp.rsync.SocketSlaveChannel;
import eu.unicore.uftp.server.FileAccess;
import eu.unicore.uftp.server.ServerThread;
import eu.unicore.uftp.server.UFTPTransferRequest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.Socket;
import org.apache.log4j.Logger;

public class UFTPWorker
extends Thread {
    private static final Logger logger = Logger.getLogger(UFTPWorker.class);
    private final ServerThread server;
    private final DPCServer.Connection connection;
    private final UFTPTransferRequest job;
    public static final int BUFFSIZE = 16384;
    private final int maxStreams;
    private final byte[] buffer = new byte[16384];
    private Socket socket = null;
    private final int bufferSize;
    public static final String sessionModeTag = "___UFTP___MULTI___FILE___SESSION___MODE___";
    private int sleepTime = 0;

    public UFTPWorker(ServerThread server, DPCServer.Connection connection, UFTPTransferRequest job, int maxStreams, int bufferSize) {
        this.server = server;
        this.connection = connection;
        this.job = job;
        this.maxStreams = maxStreams;
        this.bufferSize = bufferSize;
    }

    @Override
    public void run() {
        String fileName = this.job.getFile().getName();
        if (fileName.endsWith(sessionModeTag)) {
            this.runSession();
        } else {
            this.runSingle(this.job.getFile());
        }
    }

    protected void runSession() {
        Session session = new Session(this.connection, this.job, this.server.getFileAccess());
        logger.info("Session-mode connection from " + this.connection.getAddress() + " base directory \"" + session.getBaseDirectory() + "\"");
        try {
            this.connection.setControlTimeout(0);
            this.socket = this.makeSocket(this.maxStreams, this.connection);
            while (session.isAlive()) {
                int action = session.getNextAction();
                switch (action) {
                    case 1: {
                        this.sendData(session);
                        break;
                    }
                    case 2: {
                        this.readData(session);
                        break;
                    }
                    case 3: {
                        this.syncMaster(session);
                        break;
                    }
                    case 4: {
                        this.syncSlave(session);
                        break;
                    }
                }
            }
        }
        catch (Exception ex) {
            String msg = "Error processing session-mode connection from " + this.connection.getAddress();
            logger.error(msg, ex);
            try {
                this.connection.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    protected void runSingle(File localFile) {
        InputStream reader = null;
        OutputStream writer = null;
        FileAccess fileAccess = this.server.getFileAccess();
        long total = 0L;
        long maxBytes = Long.MAX_VALUE;
        String fileName = localFile.getAbsolutePath();
        if (fileName.startsWith("/dev/") && fileName.contains("_")) {
            String[] s = fileName.split("_");
            fileName = s[0];
            maxBytes = Long.parseLong(s[1]);
        }
        try {
            boolean controlRate;
            this.socket = this.makeSocket(this.maxStreams, this.connection);
            File file = new File(fileName).getCanonicalFile();
            String userID = this.job.getUser();
            String groupID = this.job.getGroup();
            long startTime = System.currentTimeMillis();
            boolean bl = controlRate = this.job.getRateLimit() > 0L;
            if (this.job.isSendJob()) {
                maxBytes = maxBytes != Long.MAX_VALUE ? maxBytes : file.length();
                logger.info("Sending " + maxBytes + " bytes from " + file.getAbsolutePath());
                reader = fileAccess.readFile(file.getAbsolutePath(), userID, groupID, this.bufferSize);
                if (!(this.socket instanceof PSocket)) {
                    writer = this.job.getKey() != null ? Utils.getEncryptStream(this.socket.getOutputStream(), this.job.getKey()) : this.socket.getOutputStream();
                    if (this.job.isCompress()) {
                        writer = Utils.getCompressStream(writer);
                    }
                } else {
                    writer = this.socket.getOutputStream();
                }
            } else {
                logger.info("Receiving " + file.getAbsolutePath());
                writer = fileAccess.writeFile(file.getAbsolutePath(), this.job.isAppend(), userID, groupID, this.bufferSize);
                if (!(this.socket instanceof PSocket)) {
                    reader = this.job.getKey() != null ? Utils.getDecryptStream(this.socket.getInputStream(), this.job.getKey()) : this.socket.getInputStream();
                    if (this.job.isCompress()) {
                        reader = Utils.getDecompressStream(reader);
                    }
                } else {
                    reader = this.socket.getInputStream();
                }
            }
            int n = 0;
            while (total < maxBytes && (n = reader.read(this.buffer)) >= 0) {
                writer.write(this.buffer, 0, n);
                total += (long)n;
                if (!controlRate) continue;
                this.controlRate(total, startTime);
            }
            writer.flush();
            logger.debug("Time: " + (System.currentTimeMillis() - startTime) + " total bytes transferred: " + total);
            if (!this.job.isSendJob()) {
                this.server.getFileAccess().setUser(file.getCanonicalPath(), userID, groupID);
            }
        }
        catch (Exception e) {
            logger.error("Error", e);
            try {
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (IOException i) {
                // empty catch block
            }
        }
        this.cleanup(reader, writer);
    }

    private void cleanup(InputStream reader, OutputStream writer) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException e) {
            logger.warn("Error closing reader", e);
        }
        try {
            if (writer != null) {
                writer.close();
            }
        }
        catch (IOException e) {
            logger.warn("Error closing writer", e);
        }
        try {
            this.connection.close();
        }
        catch (IOException e) {
            logger.warn("Error closing connection.", e);
        }
        this.server.notifyConnectionClosed(this.connection.getAddress());
    }

    private void controlRate(long total, long startTime) throws InterruptedException {
        long rateLimit;
        long rate;
        long interval = System.currentTimeMillis() - startTime;
        if (interval == 0L) {
            interval = 1L;
        }
        if ((rate = 1000L * total / interval) < (rateLimit = this.job.getRateLimit())) {
            this.sleepTime /= 2;
            return;
        }
        this.sleepTime += 5;
        Thread.sleep(this.sleepTime);
    }

    protected void sendData(Session session) throws IOException, InterruptedException {
        long total;
        RandomAccessFile ra = session.getLocalRandomAccessFile();
        OutputStream target = this.job.getKey() != null && !(this.socket instanceof PSocket) ? Utils.getEncryptStream(this.socket.getOutputStream(), this.job.getKey()) : this.socket.getOutputStream();
        long offset = session.getOffset();
        long bytesToSend = session.getBytesToSend();
        ra.seek(offset);
        long startTime = System.currentTimeMillis();
        boolean controlRate = this.job.getRateLimit() > 0L;
        int bufSize = this.buffer.length;
        int n = 0;
        int len = 0;
        for (total = 0L; total < bytesToSend && (n = ra.read(this.buffer, 0, len = (int)Math.min((long)bufSize, bytesToSend - total))) >= 0; total += (long)n) {
            target.write(this.buffer, 0, n);
            if (!controlRate) continue;
            this.controlRate(total, startTime);
        }
        target.flush();
        session.reset();
        logger.debug("Time: " + (System.currentTimeMillis() - startTime) + " total bytes transferred: " + total);
    }

    protected void readData(Session session) throws IOException {
        long total;
        RandomAccessFile ra = session.getLocalRandomAccessFile();
        InputStream reader = this.job.getKey() != null && !(this.socket instanceof PSocket) ? Utils.getDecryptStream(this.socket.getInputStream(), this.job.getKey()) : this.socket.getInputStream();
        long offset = session.getOffset();
        long bytesToRead = session.getBytesToRead();
        ra.seek(offset);
        long time = System.currentTimeMillis();
        int bufSize = this.buffer.length;
        int n = 0;
        int len = 0;
        for (total = 0L; total < bytesToRead && (n = reader.read(this.buffer, 0, len = (int)Math.min((long)bufSize, bytesToRead - total))) >= 0; total += (long)n) {
            ra.write(this.buffer, 0, n);
        }
        session.reset();
        logger.debug("Time: " + (System.currentTimeMillis() - time) + " total bytes transferred: " + total);
    }

    protected void syncMaster(Session session) throws Exception {
        SocketMasterChannel channel = new SocketMasterChannel(this.socket);
        String name = session.getLocalFile().getAbsolutePath();
        Master master = new Master(session.getLocalRandomAccessFile(), (MasterChannel)channel, name);
        RsyncStats stats = master.call();
        logger.info(stats);
    }

    protected void syncSlave(Session session) throws Exception {
        SocketSlaveChannel channel = new SocketSlaveChannel(this.socket);
        String name = session.getLocalFile().getAbsolutePath();
        int blockSize = Slave.reasonableBlockSize(session.getLocalFile());
        Slave slave = new Slave(session.getLocalRandomAccessFile(), channel, name, blockSize);
        RsyncStats stats = slave.call();
        logger.info(stats);
    }

    protected Socket makeSocket(int max, DPCServer.Connection connection) throws Exception {
        Socket localSocket;
        int n = Math.min(this.job.getNumCons(), max);
        if (n > 1) {
            logger.info("Creating parallel socket with " + n + " streams.");
            Socket[] dataCons = connection.openDataConnections(n);
            PSocket parallelSocket = new PSocket(this.job.getKey(), this.job.isCompress());
            parallelSocket.init(1, dataCons.length);
            for (Socket dataCon : dataCons) {
                parallelSocket.addSocketStream(dataCon);
            }
            localSocket = parallelSocket;
        } else {
            localSocket = connection.openDataConnections(1)[0];
        }
        return localSocket;
    }

    public UFTPTransferRequest getJob() {
        return this.job;
    }

    public DPCServer.Connection getConnection() {
        return this.connection;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }
}

