/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uftp.client;

import eu.unicore.uftp.client.AbstractUFTPClient;
import eu.unicore.uftp.client.ClientFactory;
import eu.unicore.uftp.dpc.ProtocolViolationException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;

public class UFTPClient
extends AbstractUFTPClient
implements Runnable {
    private static final Logger logger = Logger.getLogger(UFTPClient.class);
    private final InputStream fileReadStream;
    private final OutputStream fileWriteStream;
    long maxBytes = Long.MAX_VALUE;
    private final boolean send;
    private long finalTransferRate;

    public UFTPClient(InetAddress[] servers, int port, String fileName, boolean send, boolean append) throws FileNotFoundException {
        super(servers, port);
        this.send = send;
        File file = new File(fileName);
        if (send) {
            String realFileName = file.getAbsolutePath();
            if (realFileName.startsWith("/dev/") && realFileName.contains("_")) {
                String[] s = realFileName.split("_");
                this.maxBytes = Long.parseLong(s[1]);
            } else {
                this.maxBytes = file.length();
            }
            logger.info("Sending " + realFileName + " length " + this.maxBytes);
            this.fileReadStream = new FileInputStream(realFileName);
            this.fileWriteStream = null;
        } else {
            logger.info("Writing to " + file.getAbsolutePath());
            this.fileWriteStream = new FileOutputStream(file, append);
            this.fileReadStream = null;
        }
    }

    public UFTPClient(InetAddress[] servers, int port, InputStream source) throws IOException {
        super(servers, port);
        this.send = true;
        this.fileReadStream = source;
        this.fileWriteStream = null;
    }

    public UFTPClient(InetAddress[] servers, int port, OutputStream target) throws IOException {
        super(servers, port);
        this.send = false;
        this.fileReadStream = null;
        this.fileWriteStream = target;
    }

    @Override
    public void run() {
        try {
            int n;
            logger.info("Connecting...");
            this.connect();
            if (this.send) {
                this.preparePut(this.fileReadStream);
            } else {
                this.prepareGet(this.fileWriteStream);
            }
            byte[] buffer = new byte[16384];
            long time = System.currentTimeMillis();
            long total = 0L;
            boolean notify = this.progressListener != null;
            long c = 0L;
            while (total < this.maxBytes && (n = this.reader.read(buffer)) >= 0) {
                total += (long)n;
                this.writer.write(buffer, 0, n);
                if (!notify) continue;
                if (c % 1000L == 0L) {
                    this.progressListener.notifyTotalBytesTransferred(total);
                }
                ++c;
            }
            this.writer.flush();
            if (notify) {
                this.progressListener.notifyTotalBytesTransferred(total);
            }
            time = System.currentTimeMillis() - time;
            long rate = (long)((double)total / (double)time);
            logger.info("Finished, data rate " + rate + " kB/sec. (" + total + " bytes in " + time + " ms.)");
            this.finalTransferRate = rate * 1000L;
        }
        catch (Exception e) {
            throw new RuntimeException("Error running transfer", e);
        }
        this.cleanup();
    }

    public long getFinalTransferRate() {
        return this.finalTransferRate;
    }

    public static void main(String[] args) throws Exception {
        try {
            AbstractUFTPClient client = ClientFactory.create(args);
            client.run();
            System.exit(0);
        }
        catch (Exception ex) {
            logger.error("Error running UFTP client", ex);
            System.err.println("Error running UFTP client: " + ex.getMessage());
            if (ex.getCause() instanceof ProtocolViolationException) {
                System.err.println();
                System.err.println("Please check hostname and port of the remote server!");
            }
            System.exit(1);
        }
    }

    static UFTPClient create(String[] args) throws UnknownHostException, FileNotFoundException {
        Options options = ClientFactory.createOptions();
        GnuParser parser = new GnuParser();
        CommandLine line = null;
        try {
            line = parser.parse(options, args);
        }
        catch (ParseException pe) {
            pe.printStackTrace();
            System.out.println();
            ClientFactory.printUsage(options);
            System.exit(1);
        }
        boolean send = ClientFactory.isSend(line);
        String file = line.getOptionValue('f');
        boolean append = Boolean.parseBoolean(line.getOptionValue('a'));
        int port = Integer.parseInt(line.getOptionValue("L"));
        InetAddress[] server = ClientFactory.getServers(line, logger);
        UFTPClient client = new UFTPClient(server, port, file, send, append);
        ClientFactory.configureClient(client, line, logger);
        logger.info("New UFTP client for server " + Arrays.asList(server) + " at port " + port);
        return client;
    }

    public static String makeCommandline(String host, int port, String localFile, boolean sendData, String secret, int numStreams, String encryptionKey, boolean append, boolean compress, int bufferSize) {
        String c1 = UFTPClient.makeCommandline(host, port, localFile, sendData, secret, numStreams, encryptionKey, append, compress);
        return c1 + " -b " + bufferSize;
    }

    public static String makeCommandline(String host, int port, String localFile, boolean sendData, String secret, int numStreams, String encryptionKey, boolean append, boolean compress) {
        StringBuilder sb = new StringBuilder();
        sb.append("-l ").append(host);
        sb.append(" -L ").append(port);
        sb.append(" -f \"").append(localFile).append("\"");
        if (sendData) {
            sb.append(" -s");
        } else {
            sb.append(" -r");
        }
        sb.append(" -x ").append(secret);
        sb.append(" -n ").append(numStreams);
        if (encryptionKey != null) {
            sb.append(" -E ");
            sb.append(encryptionKey);
        }
        if (append) {
            sb.append(" -a");
        }
        if (compress) {
            sb.append(" -z");
        }
        return sb.toString();
    }
}

