/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.samly2.trust;

import eu.emi.security.authn.x509.impl.X500NameUtils;
import eu.unicore.samly2.SAMLUtils;
import eu.unicore.samly2.exceptions.SAMLValidationException;
import eu.unicore.samly2.trust.DsigSamlTrustCheckerBase;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import xmlbeans.org.oasis.saml2.assertion.NameIDType;
import xmlbeans.org.w3.x2000.x09.xmldsig.SignatureType;

public class StrictSamlTrustChecker
extends DsigSamlTrustCheckerBase {
    protected Map<String, List<PublicKey>> trustedIssuers = new HashMap<String, List<PublicKey>>();

    public void addTrustedIssuer(String samlId, String type, PublicKey trustedKey) {
        this.addTrustedIssuer(samlId, type, Collections.singletonList(trustedKey));
    }

    public void addTrustedIssuer(String samlId, String type, List<PublicKey> trustedKeys) {
        if (trustedKeys == null || trustedKeys.size() == 0) {
            throw new IllegalArgumentException("Must have a non empty set of trusted keys");
        }
        if ("urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName".equals(type)) {
            samlId = X500NameUtils.getComparableForm((String)samlId);
        }
        this.trustedIssuers.put(type + "--_--" + samlId, trustedKeys);
    }

    @Override
    protected PublicKey establishKey(NameIDType issuer, SignatureType signature) throws SAMLValidationException {
        if (issuer == null) {
            throw new SAMLValidationException("Issuer must be set when SAML artifact is signed");
        }
        List<PublicKey> keys = this.getPublicKeys(issuer);
        X509Certificate[] issuerCC = SAMLUtils.getIssuerFromSignature(signature);
        if (issuerCC == null) {
            if (keys.size() == 1) {
                return keys.get(0);
            }
            throw new SAMLValidationException("Issuer certificate is not set and the issuer '" + issuer.getStringValue() + "' has several trusted public keys - it is undefined which was used for signing.");
        }
        for (PublicKey trustedKey : keys) {
            if (!trustedKey.equals(issuerCC[0].getPublicKey())) continue;
            return trustedKey;
        }
        throw new SAMLValidationException("Issuer certificate is not among trusted certificates for the issuer'" + issuer.getStringValue() + "' Untrusted issuer certificate subject is: " + X500NameUtils.getReadableForm((X500Principal)issuerCC[0].getSubjectX500Principal()));
    }

    protected List<PublicKey> getPublicKeys(NameIDType issuer) throws SAMLValidationException {
        String key = this.getIssuerKey(issuer);
        List<PublicKey> trustedKeys = this.trustedIssuers.get(key);
        if (trustedKeys == null) {
            throw new SAMLValidationException("The issuer of the SAML artifact is not trusted: " + issuer.getStringValue());
        }
        return trustedKeys;
    }

    protected String getIssuerKey(NameIDType issuer) throws SAMLValidationException {
        String format = issuer.getFormat();
        if (format == null || format.equals("urn:oasis:names:tc:SAML:2.0:nameid-format:entity") || format.equals("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent") || format.equals("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified") || format.equals("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress")) {
            return format + "--_--" + issuer.getStringValue();
        }
        if (issuer.getFormat().equals("urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName")) {
            return format + "--_--" + X500NameUtils.getComparableForm((String)issuer.getStringValue());
        }
        throw new SAMLValidationException("Issuer name format is unknown: " + issuer.getFormat());
    }
}

