/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.QueryableEntry;
import java.io.IOException;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AndResultSet
extends AbstractSet<QueryableEntry> {
    private final Set<QueryableEntry> setSmallest;
    private final List<Set<QueryableEntry>> otherIndexedResults;
    private final List<Predicate> lsNoIndexPredicates;

    public AndResultSet(Set<QueryableEntry> setSmallest, List<Set<QueryableEntry>> otherIndexedResults, List<Predicate> lsNoIndexPredicates) {
        this.setSmallest = setSmallest;
        this.otherIndexedResults = otherIndexedResults;
        this.lsNoIndexPredicates = lsNoIndexPredicates;
    }

    public byte[] toByteArray(ObjectDataOutput out) throws IOException {
        for (QueryableEntry entry : this.setSmallest) {
            Iterator<Object> i$;
            if (this.otherIndexedResults != null) {
                Set otherIndexedResult;
                i$ = this.otherIndexedResults.iterator();
                while (i$.hasNext() && (otherIndexedResult = (Set)i$.next()).contains(entry)) {
                }
            }
            if (this.lsNoIndexPredicates != null) {
                Predicate noIndexPredicate;
                i$ = this.lsNoIndexPredicates.iterator();
                while (i$.hasNext() && (noIndexPredicate = (Predicate)i$.next()).apply(entry)) {
                }
            }
            entry.getKeyData().writeData(out);
        }
        return out.toByteArray();
    }

    @Override
    public boolean contains(Object o) {
        if (!this.setSmallest.contains(o)) {
            return false;
        }
        if (this.otherIndexedResults != null) {
            for (Set set : this.otherIndexedResults) {
                if (set.contains(o)) continue;
                return false;
            }
        }
        if (this.lsNoIndexPredicates != null) {
            for (Predicate predicate : this.lsNoIndexPredicates) {
                if (predicate.apply((Map.Entry)o)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Iterator<QueryableEntry> iterator() {
        return new It();
    }

    @Override
    public int size() {
        return this.setSmallest.size();
    }

    static /* synthetic */ Set access$000(AndResultSet x0) {
        return x0.setSmallest;
    }

    class It
    implements Iterator<QueryableEntry> {
        QueryableEntry currentEntry = null;
        final Iterator<QueryableEntry> it = AndResultSet.access$000(AndResultSet.this).iterator();

        It() {
        }

        @Override
        public boolean hasNext() {
            if (!this.it.hasNext()) {
                return false;
            }
            this.currentEntry = this.it.next();
            if (AndResultSet.this.otherIndexedResults != null) {
                for (Set otherIndexedResult : AndResultSet.this.otherIndexedResults) {
                    if (otherIndexedResult.contains(this.currentEntry)) continue;
                    return this.hasNext();
                }
            }
            if (AndResultSet.this.lsNoIndexPredicates != null) {
                for (Predicate noIndexPredicate : AndResultSet.this.lsNoIndexPredicates) {
                    if (noIndexPredicate.apply(this.currentEntry)) continue;
                    return this.hasNext();
                }
            }
            return true;
        }

        @Override
        public QueryableEntry next() {
            return this.currentEntry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

