/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.multimap.tx;

import com.hazelcast.collection.CollectionContainer;
import com.hazelcast.collection.CollectionProxyId;
import com.hazelcast.collection.CollectionRecord;
import com.hazelcast.collection.CollectionService;
import com.hazelcast.collection.CollectionWrapper;
import com.hazelcast.collection.operations.CollectionKeyBasedOperation;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.Clock;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class TxnRemoveAllOperation
extends CollectionKeyBasedOperation {
    Collection<Long> recordIds;
    transient long begin = -1L;
    transient Collection<CollectionRecord> removed;

    public TxnRemoveAllOperation() {
    }

    public TxnRemoveAllOperation(CollectionProxyId proxyId, Data dataKey, Collection<CollectionRecord> records) {
        super(proxyId, dataKey);
        this.recordIds = new ArrayList<Long>();
        for (CollectionRecord record : records) {
            this.recordIds.add(record.getRecordId());
        }
    }

    @Override
    public void run() throws Exception {
        this.begin = Clock.currentTimeMillis();
        CollectionContainer container = this.getOrCreateContainer();
        CollectionWrapper wrapper = container.getOrCreateCollectionWrapper(this.dataKey);
        this.response = true;
        for (Long recordId : this.recordIds) {
            if (wrapper.containsRecordId(recordId)) continue;
            this.response = false;
            return;
        }
        Collection<CollectionRecord> coll = wrapper.getCollection();
        this.removed = new LinkedList<CollectionRecord>();
        block1: for (Long recordId : this.recordIds) {
            Iterator<CollectionRecord> iter = coll.iterator();
            while (iter.hasNext()) {
                CollectionRecord record = iter.next();
                if (record.getRecordId() != recordId.longValue()) continue;
                iter.remove();
                this.removed.add(record);
                continue block1;
            }
        }
        if (coll.isEmpty()) {
            this.removeCollection();
        }
    }

    @Override
    public void afterRun() throws Exception {
        long elapsed = Math.max(0L, Clock.currentTimeMillis() - this.begin);
        CollectionService service = (CollectionService)this.getService();
        service.getLocalMultiMapStatsImpl(this.proxyId).incrementRemoves(elapsed);
        if (this.removed != null) {
            this.getOrCreateContainer().update();
            for (CollectionRecord record : this.removed) {
                this.publishEvent(EntryEventType.REMOVED, this.dataKey, record.getObject());
            }
        }
    }

    public Collection<Long> getRecordIds() {
        return this.recordIds;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.recordIds.size());
        for (Long recordId : this.recordIds) {
            out.writeLong(recordId);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int size = in.readInt();
        this.recordIds = new ArrayList<Long>();
        for (int i = 0; i < size; ++i) {
            this.recordIds.add(in.readLong());
        }
    }

    @Override
    public int getId() {
        return 34;
    }
}

